/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.twitterplugin;

import com.sonyericsson.eventstream.twitterplugin.utility.ContactLookupHelper;

import android.test.AndroidTestCase;

public class UContactLookupHandlerTests extends AndroidTestCase {

    private static final int ILLEGAL_TWITTER_USER_ID = -1;

    private static final String EMPTY_STRING = "";

    private static final int FAKED_USER_ID = 23;

    public void testContactRawContactExitParametersAreNull() {
        assertFalse("Expected value to be false", ContactLookupHelper.rawContactExist(null,
                "name"));
        assertFalse("Expected value to be false", ContactLookupHelper.rawContactExist(
                getContext().getContentResolver(), null));
    }

    public void testGetRawContactParametersAreNull() {
        String result = ContactLookupHelper.getRawContactUriInContacts(getContext()
                .getContentResolver(), FAKED_USER_ID);
        assertEquals("Expected empty string when parameter is null", EMPTY_STRING, result);

        result = ContactLookupHelper.getRawContactUriInContacts(null, FAKED_USER_ID);
        assertEquals("Expected empty string when parameter is null", EMPTY_STRING, result);

        result = ContactLookupHelper.getRawContactUriInContacts(getContext()
                .getContentResolver(), ILLEGAL_TWITTER_USER_ID);
        assertEquals("Expected empty string when parameter is null", EMPTY_STRING, result);
    }

}
