/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;

import com.sonyericsson.eventstream.twitterplugin.PluginConstants;
import com.sonyericsson.eventstream.twitterplugin.PluginConstants.EventStreamIntentActions;
import com.sonyericsson.eventstream.twitterplugin.PluginConstants.EventStreamIntentExtraParams;
import com.sonyericsson.eventstream.twitterplugin.service.EventStreamListener;

import junit.framework.Assert;

import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;


@RunWith(PowerMockRunner.class)
@PrepareForTest({EventStreamListener.class, Log.class, Intent.class, Bundle.class, Context.class, ComponentName.class})
public class TestEventStreamListener {

    /**
     * Test set up
     */
    @Before
    public void setUp() {

    }

    /**
     * Test service registration call
     * @throws Exception
     */
    @Test
    public void testStartServiceWithRegister() throws Exception {

        // Mock objects
        Context context = PowerMock.createMock(Context.class);
        Intent intent = PowerMock.createMock(Intent.class);
        ComponentName comp = PowerMock.createMock(ComponentName.class);
        EventStreamListener listener = PowerMock.createPartialMock(EventStreamListener.class,
        "launchWebIntent");

        // Suppress
        PowerMock.suppress(BroadcastReceiver.class.getConstructors());
        PowerMock.suppress(Log.class.getMethods());

        EasyMock.expect(intent.getAction()).andReturn(EventStreamIntentActions.REGISTER).times(2);

        try {
            PowerMock.expectNew(Intent.class).andReturn(intent).once();
        } catch (Exception e) {
            Assert.fail("Could not create intent class: " + e.getMessage());
        }

        EasyMock.expect(intent.setAction(PluginConstants.TWITTER_REGISTER_PLUGIN)).andReturn(intent).once();
        EasyMock.expect(context.startService(intent)).andReturn(comp).once();

        PowerMock.replayAll();
        listener.onReceive(context, intent);
        PowerMock.verifyAll();
    }

    /**
     * Test service refresh call
     * @throws Exception
     */
    @Test
    public void testStartServiceWithRefresh() throws Exception {
        // Mock objects
        Context context = PowerMock.createMock(Context.class);
        Intent intent = PowerMock.createMock(Intent.class);
        Bundle bundle = PowerMock.createMock(Bundle.class);
        ComponentName comp = PowerMock.createMock(ComponentName.class);
        EventStreamListener listener = PowerMock.createPartialMock(EventStreamListener.class,
        "launchWebIntent");

        // Suppress
        PowerMock.suppress(BroadcastReceiver.class.getConstructors());
        PowerMock.suppress(Log.class.getMethods());

        // Expect
        try {
            PowerMock.expectNew(Intent.class).andReturn(intent).once();
        } catch (Exception e) {
            Assert.fail("Could not create intent class: " + e.getMessage());
        }

        EasyMock.expect(intent.getExtras()).andReturn(bundle).once();
        EasyMock.expect(bundle.getString(EventStreamIntentExtraParams.EXTRA_PLUGIN_KEY)).andReturn(PluginConstants.PLUGIN_IDENTIFIER).once();
        EasyMock.expect(intent.getAction()).andReturn(EventStreamIntentActions.REFRESH).times(2);
        EasyMock.expect(intent.setAction(PluginConstants.TWITTER_REFRESH_REQUEST)).andReturn(intent).once();
        EasyMock.expect(context.startService(intent)).andReturn(comp).once();

        PowerMock.replayAll();
        listener.onReceive(context, intent);
        PowerMock.verifyAll();
    }

    /**
     * Test service status update call
     * @throws Exception
     */
    @Test
    public void testStartServiceWithStatusUpdate() throws Exception {
        String message = "statusmessage";
        // Mock objects
        Context context = PowerMock.createMock(Context.class);
        Intent intent = PowerMock.createMock(Intent.class);
        Bundle bundle = PowerMock.createMock(Bundle.class);
        ComponentName comp = PowerMock.createMock(ComponentName.class);
        EventStreamListener listener = PowerMock.createPartialMock(EventStreamListener.class,
        "launchWebIntent");

        // Suppress
        PowerMock.suppress(BroadcastReceiver.class.getConstructors());
        PowerMock.suppress(Log.class.getMethods());

        // Expect
        try {
            PowerMock.expectNew(Intent.class).andReturn(intent).once();
        } catch (Exception e) {
            Assert.fail("Could not create intent class: " + e.getMessage());
        }

        EasyMock.expect(intent.getAction()).andReturn(EventStreamIntentActions.STATUS_UPDATE).times(2);;
        EasyMock.expect(intent.getExtras()).andReturn(bundle).times(2);
        EasyMock.expect(bundle.getString(EventStreamIntentExtraParams.EXTRA_PLUGIN_KEY)).andReturn(PluginConstants.PLUGIN_IDENTIFIER).once();
        EasyMock.expect(bundle.getString(EventStreamIntentExtraParams.EXTRA_STATUS_UPDATE_MESSAGE)).andReturn(message).once();
        EasyMock.expect(intent.setAction(PluginConstants.TWITTER_UPDATE_STATUS)).andReturn(intent).once();
        EasyMock.expect(intent.putExtra(EventStreamIntentExtraParams.EXTRA_STATUS_UPDATE_MESSAGE, message)).andReturn(intent).once();
        EasyMock.expect(context.startService(intent)).andReturn(comp).once();

        PowerMock.replayAll();
        listener.onReceive(context, intent);
        PowerMock.verifyAll();
    }

    /**
     * Test action null
     * @throws Exception
     */
    @Test
    public void testInvalidNullAction() throws Exception {
        // Mock objects
        Context context = PowerMock.createMock(Context.class);
        Intent intent = PowerMock.createMock(Intent.class);
        EventStreamListener listener = PowerMock.createPartialMock(EventStreamListener.class,
        "launchWebIntent");

        // Suppress
        PowerMock.suppress(BroadcastReceiver.class.getConstructors());
        PowerMock.suppress(Log.class.getMethods());

        EasyMock.expect(intent.getAction()).andReturn(null).once();

        PowerMock.replayAll();
        listener.onReceive(context, intent);
        PowerMock.verifyAll();
    }

    /**
     * Test intent null
     * @throws Exception
     */
    @Test
    public void testInvalidNullIntent() throws Exception {
        // Mock objects
        Context context = PowerMock.createMock(Context.class);
        EventStreamListener listener = PowerMock.createPartialMock(EventStreamListener.class,
        "launchWebIntent");

        // Suppress
        PowerMock.suppress(BroadcastReceiver.class.getConstructors());
        PowerMock.suppress(Log.class.getMethods());

        PowerMock.replayAll();
        listener.onReceive(context, null);
        PowerMock.verifyAll();
    }
}
