/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/
package com.sonyericsson.eventstream.twitterplugin.utility;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

import com.sonyericsson.eventstream.twitterplugin.R;
import com.sonyericsson.eventstream.twitterplugin.PluginConstants.Config;

public class NotificationHelper {

    private static final int NOTIFICATION_ID = 1;

    public static void notifyError(Context context, String errorMessage) {
        if (context == null || errorMessage == null) {
            return;
        }
        // Remove a previous notification if already exist
        NotificationHelper.removeFromStatusBar(context);

        NotificationHelper.notifyInStatusBar(context,
                R.drawable.notif_data_fetch_failed_icn,
                context.getResources().getString(R.string.ts_twitter_notify_fetch_failed_title_txt),
                errorMessage);
    }

    /**
    *
    */
   public static void notifyInStatusBar(Context context, int iconId, String title, String message) {
       if (context == null || title == null || message == null) {
           return;
       }

       NotificationManager nm = (NotificationManager)context.getSystemService(Context.NOTIFICATION_SERVICE);
       Notification notification = new Notification(iconId, null, System.currentTimeMillis());
       PendingIntent pendingIntent = PendingIntent.getActivity(context, 0, null, Intent.FLAG_ACTIVITY_NEW_TASK);
       notification.setLatestEventInfo(context, title, message, pendingIntent);
       if (nm != null) {
           nm.notify(NOTIFICATION_ID, notification);
       } else {
           Log.e(Config.LOG_TAG, "Could not add notification, manager returned null");
       }
   }

   /**
    *
    */
   public static void removeFromStatusBar(Context context) {
       if (context == null) {
           return;
       }
       NotificationManager nm = (NotificationManager)context.getSystemService(Context.NOTIFICATION_SERVICE);
       if (nm != null) {
           nm.cancel(NOTIFICATION_ID);
       } else {
           Log.e(Config.LOG_TAG, "Could not remove notification, manager returned null");
       }
   }

}
