package com.sonyericsson.eventstream.telephonyplugin.utils;

import android.test.mock.MockCursor;

import java.util.ArrayList;

public class MockTestCursor extends MockCursor {

    ArrayList<FunctionCall> mCursorCalls = new ArrayList<FunctionCall>();

    String ANY_ARGUMENT = "ANY_ARGUMENT";

    public class FunctionCall {

        public class Result {

            /** The value that is returned */
            public Object mValue;

            private Result(Object value) {
                mValue = value;
            }
        }

        /** The name of the function being called */
        private String mFunctionName;

        /** The arguments that are expected */
        private String mExpectedArguments;

        /** The value to return */
        private Result mReturnValue;

        /** Creates a FunctionCall */
        private FunctionCall(String functionName, String expectedArguments) {
            mFunctionName = functionName;
            mExpectedArguments = expectedArguments;
            mReturnValue = null;
        }

        /**
         * Set an object to return when the function is called
         *
         * @param returnValue
         */
        public void andReturn(Object returnValue) {
            mReturnValue = new Result(returnValue);
        }
    }

    @Override
    public void close() {
    }

    @Override
    public int getColumnIndex(String columnName) {
        FunctionCall.Result returnValue = reportFunctionCall("getColumnIndex", columnName);
        if (returnValue != null) {
            return (Integer)returnValue.mValue;
        }
        return 0;
    }

    @Override
    public int getColumnIndexOrThrow(String columnName) {
        FunctionCall.Result returnValue = reportFunctionCall("getColumnIndexOrThrow",
                columnName);
        if (returnValue != null) {
            return (Integer)returnValue.mValue;
        }
        return 0;
    }

    @Override
    public int getInt(int columnIndex) {
        FunctionCall.Result returnValue = reportFunctionCall("getInt", String
                .valueOf(columnIndex));
        if (returnValue != null) {
            return (Integer)returnValue.mValue;
        }
        return 0;
    }

    @Override
    public String getString(int columnIndex) {
        FunctionCall.Result returnValue = reportFunctionCall("getString", String
                .valueOf(columnIndex));
        if (returnValue != null) {
            return (String)returnValue.mValue;
        }
        return null;
    }

    @Override
    public long getLong(int columnIndex) {
        FunctionCall.Result returnValue = reportFunctionCall("getLong", String
                .valueOf(columnIndex));
        if (returnValue != null) {
            return (Long)returnValue.mValue;
        }
        return 0;
    }

    @Override
    public boolean moveToFirst() {
        FunctionCall.Result returnValue = reportFunctionCall("moveToFirst", "");
        if (returnValue != null) {
            return (Boolean)returnValue.mValue;
        }
        return false;
    }

    @Override
    public int getCount() {
        System.out.println("TEST::::::::getCount");
        FunctionCall.Result returnValue = reportFunctionCall("getCount", "");
        if (returnValue != null) {
            return (Integer)returnValue.mValue;
        }
        return 0;
    }

    @Override
    public boolean moveToNext() {
        FunctionCall.Result returnValue = reportFunctionCall("moveToNext", "");
        if (returnValue != null) {
            return (Boolean)returnValue.mValue;
        }
        return false;
    }

    public FunctionCall expectedData(String functionName, String expectedArguments) {
        FunctionCall functionCall = new FunctionCall(functionName, expectedArguments);
        mCursorCalls.add(functionCall);
        return functionCall;
    }

    public FunctionCall.Result reportFunctionCall(String function, String arguments) {
        for (FunctionCall functionCall : mCursorCalls) {
            if (functionCall.mFunctionName.equals(function)
                    && verifyArguments(functionCall.mExpectedArguments, arguments)) {
                mCursorCalls.remove(functionCall);
                return functionCall.mReturnValue;
            }
        }
        return null;
    }

    private boolean verifyArguments(String expected, String actual) {
        if (expected.equals(ANY_ARGUMENT)) {
            return true;
        }
        String[] expectedArguments = expected.split(";");
        String[] actualArguments = actual.split(";");
        if (expectedArguments.length != actualArguments.length) {
            return false;
        }
        for (int i = 0; i < expectedArguments.length; i++) {
            if (!expectedArguments[i].equals(ANY_ARGUMENT)
                    && !expectedArguments[i].equals(actualArguments[i])) {
                return false;
            }
        }
        return true;
    }
}
