/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.simpleui.activity;

import com.sonyericsson.simpleui.R;
import com.sonyericsson.simpleui.provider.EventStreamContentProvider;

import android.app.ListActivity;
import android.content.Intent;
import android.database.Cursor;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleCursorAdapter;
import android.widget.TextView;
import android.widget.Toast;

import java.util.ArrayList;
import java.util.List;

public class SimpleUiStatusUpdateActivity extends ListActivity implements OnClickListener {

    private EditText statusUpdateEditText;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.status_update);
        Button submitBtn = (Button)findViewById(R.id.status_update_submit_btn);
        submitBtn.setOnClickListener(this);
        statusUpdateEditText = (EditText)findViewById(R.id.status_update_edit_text);
        TextView emptyListText = (TextView)findViewById(R.id.status_update_empty_list_text);

        Cursor pluginCursor = managedQuery(EventStreamContentProvider.Uris.PLUGIN_URI, null,
                EventStreamContentProvider.PluginColumns.STATUS_SUPPORT + " = ? ", new String[] {
                    String.valueOf(EventStreamContentProvider.StatusSupport.HAS_SUPPORT_TRUE)
                }, null);

        ListAdapter adapter = new SimpleCursorAdapter(this,
                android.R.layout.simple_list_item_multiple_choice, pluginCursor, new String[] {
                    EventStreamContentProvider.PluginColumns.NAME
                }, new int[] {
                    android.R.id.text1
                });

        setListAdapter(adapter);

        if (adapter.isEmpty()) {
            emptyListText.setVisibility(View.VISIBLE);
            submitBtn.setEnabled(false);
            statusUpdateEditText.setEnabled(false);
        } else {
            emptyListText.setVisibility(View.GONE);
            submitBtn.setEnabled(true);
            statusUpdateEditText.setEnabled(true);
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.status_update_submit_btn) {
            String statusText = statusUpdateEditText.getText().toString();
            if (statusText == null || statusText.equals("")) {
                Toast.makeText(this, "You need to enter a text", Toast.LENGTH_SHORT).show();
                return;
            }
            Intent intent = new Intent(
                    EventStreamContentProvider.OutgoingIntents.STATUS_UPDATE_INTENT);
            intent.putExtra(EventStreamContentProvider.IntentData.EXTRA_STATUS_UPDATE_MESSAGE,
                    statusText);
            List<String> packageList = getSelectedPackages();
            if (packageList.isEmpty()) {
                Toast.makeText(this, "You must select at least one plugin", Toast.LENGTH_SHORT)
                        .show();
                return;
            }
            for (String packageName : packageList) {
                setPackageAndLegacyExtra(packageName, intent);
                sendBroadcast(intent);
            }
            finish();
        }
    }

    void setPackageAndLegacyExtra(String packageName, Intent intent) {
        Cursor pluginCursor = getContentResolver().query(EventStreamContentProvider.Uris.PLUGIN_URI,
                new String[] {EventStreamContentProvider.PluginColumns.API_VERSION,
                EventStreamContentProvider.PluginColumns.PLUGIN_KEY},
                EventStreamContentProvider.PluginColumns.PACKAGE_NAME + " = ?",
                new String[] {packageName}, null);
        try {
            if(pluginCursor != null && pluginCursor.moveToFirst()) {
                int apiVersion = pluginCursor.getInt(pluginCursor.getColumnIndex(EventStreamContentProvider.PluginColumns.API_VERSION));

                if(apiVersion == 0) {
                    intent.setPackage(EventStreamContentProvider.LEGACY_WRAPPER_PACKAGE);
                    intent.putExtra(EventStreamContentProvider.IntentData.EXTRA_LEGACY_PACKAGE, packageName);
                } else {
                    intent.setPackage(packageName);
                }

                String pluginKey = pluginCursor.getString(pluginCursor
                        .getColumnIndex(EventStreamContentProvider.PluginColumns.PLUGIN_KEY));
                if (pluginKey != null && !pluginKey.equals("")) {
                    intent.putExtra(EventStreamContentProvider.IntentData.EXTRA_PLUGIN_KEY, pluginKey);
                }

            }
        } finally {
            if(pluginCursor != null) {
                pluginCursor.close();
            }
        }
    }

    private List<String> getSelectedPackages() {
        List<String> packageList = new ArrayList<String>();
        ListView listView = getListView();
        Cursor c = ((SimpleCursorAdapter)getListAdapter()).getCursor();
        for (int i = 0; i < listView.getChildCount(); i++) {
            View v = listView.getChildAt(i);
            CheckedTextView checkedTextView = (CheckedTextView)v.findViewById(android.R.id.text1);
            boolean checked = checkedTextView.isChecked();
            if (checked) {
                c.moveToPosition(i);
                String packageName = c.getString(c
                        .getColumnIndex(EventStreamContentProvider.PluginColumns.PACKAGE_NAME));
                packageList.add(packageName);
            }
        }

        return packageList;
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        super.onListItemClick(l, v, position, id);
        CheckedTextView checkedTextView = (CheckedTextView)v.findViewById(android.R.id.text1);
        boolean checked = checkedTextView.isChecked();
        if (checked) {
            checkedTextView.setChecked(false);
        } else {
            checkedTextView.setChecked(true);
        }
    }
}
