/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.rssplugin.util;

import com.sonyericsson.eventstream.rssplugin.R;
import com.sonyericsson.eventstream.rssplugin.PluginConstants.EventStream;
import android.content.Context;
import android.database.Cursor;

public class DBUtils {

    public static int DELAY = 2000;

    public static void deletePluginAndSourceFromDatabase(Context context) {
        context.getContentResolver().delete(
                EventStream.EVENTSTREAM_SOURCE_PROVIDER_URI, EventStream.SourceColumns.NAME + " = ?",
                new String[]{context.getResources().getString(R.string.rss_source_name)});
        context.getContentResolver().delete(
                EventStream.EVENTSTREAM_PLUGIN_PROVIDER_URI, EventStream.PluginColumns.NAME + " = ?",
                new String[]{context.getResources().getString(R.string.rss_plugin_name)});
    }

    public static boolean isSourceInDB(Context context) {
        Cursor cursor = context.getContentResolver().query(
                EventStream.EVENTSTREAM_SOURCE_PROVIDER_URI, null, EventStream.SourceColumns.NAME + " = ?",
                new String[]{context.getResources().getString(R.string.rss_source_name)}, null);
        return (cursor != null && cursor.getCount() > 0) ? true: false;
    }

    public static boolean isPluginInDB(Context context) {
        Cursor cursor = context.getContentResolver().query(
                EventStream.EVENTSTREAM_PLUGIN_PROVIDER_URI, null, EventStream.PluginColumns.NAME + " = ?",
                new String[]{context.getResources().getString(R.string.rss_plugin_name)}, null);
        return (cursor != null && cursor.getCount() > 0) ? true: false;
    }
}

