/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/

package com.sonyericsson.eventstream.facebookplugin;

import android.test.AndroidTestCase;

public class UFacebookPluginTestCredentialHandler extends AndroidTestCase {

    public void testInstantiate() {
        CredentialHandler ch = CredentialHandler.getInstance();
        assertNotNull(ch);
    }

    public void testGetFacebookCredentials() {
        CredentialHandler ch = CredentialHandler.getInstance();
        String apikey = ch.getCredential(CredentialHandler.FACEBOOK_API_KEY);
        assertNotNull(apikey);
        String secretkey = ch.getCredential(CredentialHandler.FACEBOOK_SECRET_KEY);
        assertNotNull(secretkey);
    }

    public void testGetUnknownKey() {
        try {
            CredentialHandler ch = CredentialHandler.getInstance();
            ch.getCredential(100);
            fail("getCredentials for unknown type should throw exception");
        } catch (IllegalArgumentException e) {}
    }

    public void testSingleton() {
        CredentialHandler ch = CredentialHandler.getInstance();
        assertSame(ch, CredentialHandler.getInstance());
    }

}
