/*********************************************************************
 *  ____                      _____      _                           *
 * / ___|  ___  _ __  _   _  | ____|_ __(_) ___ ___ ___  ___  _ __   *
 * \___ \ / _ \| '_ \| | | | |  _| | '__| |/ __/ __/ __|/ _ \| '_ \  *
 *  ___) | (_) | | | | |_| | | |___| |  | | (__\__ \__ \ (_) | | | | *
 * |____/ \___/|_| |_|\__, | |_____|_|  |_|\___|___/___/\___/|_| |_| *
 *                    |___/                                          *
 *                                                                   *
 *********************************************************************
 * Copyright 2010 Sony Ericsson Mobile Communications AB.            *
 * All rights, including trade secret rights, reserved.              *
 *********************************************************************/
package com.sonyericsson.eventstream.calllogplugin;

import com.sonyericsson.eventstream.calllogplugin.PluginConstants.Config;
import com.sonyericsson.eventstream.calllogplugin.PluginConstants.ServiceIntentCmd;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

/**
* This BroadcastReceiver listens for language changes. Source configuration
* is updated in the EventStream database according to the new locale.*/

public class CallLogLocaleListener extends BroadcastReceiver{

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();

        if (intent.ACTION_LOCALE_CHANGED.equals(action)) {
            if (Config.DEBUG) {
                Log.d(Config.LOG_TAG, "Service received LOCALE_CHANGED");
            }
            Intent serviceIntent = new Intent();
            serviceIntent.setComponent(new ComponentName(context, CallLogPluginService.class));
            serviceIntent.putExtra(ServiceIntentCmd.SERVICE_COMMAND_KEY, ServiceIntentCmd.CALLLOG_LOCALE_CHANGED);
            context.startService(serviceIntent);
        }
    }
}