/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.http;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import twitter4j.internal.http.HttpResponse;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpResponseImpl
extends HttpResponse {
    private HttpURLConnection con;

    HttpResponseImpl(HttpURLConnection con) throws IOException {
        this.con = con;
        this.statusCode = con.getResponseCode();
        this.is = con.getErrorStream();
        if (null == this.is) {
            this.is = con.getInputStream();
        }
        if (null != this.is && "gzip".equals(con.getContentEncoding())) {
            this.is = new GZIPInputStream(this.is);
        }
    }

    HttpResponseImpl(String content) {
        this.responseAsString = content;
    }

    @Override
    public String getResponseHeader(String name) {
        return this.con.getHeaderField(name);
    }

    @Override
    public Map<String, List<String>> getResponseHeaderFields() {
        return this.con.getHeaderFields();
    }

    @Override
    public void disconnect() {
        this.con.disconnect();
    }
}

