/*
This class controls a stack of _stackSize_ objects, which will be stored in the app’s defaults with _name_.

If an object that is already in the list is added, it will be moved to the top of the list instead.
If the list grows beyond _stackSize_ objects, the last object will be removed before the new item is added.
*/

@interface OakHistoryList : NSObject
{
	NSMutableArray* list;
	NSUInteger stackSize;
	NSString* name;
}
@property (nonatomic, assign, readonly) NSUInteger stackSize;
@property (nonatomic, retain) id head;

- (id)initWithName:(NSString*)defaultsName stackSize:(NSUInteger)size;
- (id)initWithName:(NSString*)defaultsName stackSize:(NSUInteger)size defaultItems:(id)firstItem, ...;
- (void)addObject:(id)newItem;
- (NSEnumerator*)objectEnumerator;
- (id)objectAtIndex:(NSUInteger)index;
- (NSUInteger)count;
@end
