/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.envjs;

import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tools.envjs.Global;
import org.mozilla.javascript.tools.envjs.Main;
import org.mozilla.javascript.tools.envjs.Proxy;

public class Window
extends org.mozilla.javascript.tools.shell.Global {
    public void init(Context cx) {
        Object[] propIds;
        super.init(cx);
        String[] names = new String[]{"getFreshScopeObj", "getProxyFor", "getScope", "setScope", "configureScope", "restoreScope", "loadIntoFnsScope", "javaHashCode"};
        this.defineFunctionProperties(names, Window.class, 2);
        for (Object anId : propIds = this.getAllIds()) {
            try {
                Scriptable aProp = (Scriptable)this.get((String)anId, (Scriptable)this);
                if (aProp.getClassName() != "Function") continue;
                aProp.setParentScope(Main.global);
            }
            catch (ClassCastException ccExcept) {
                // empty catch block
            }
        }
    }

    public static void loadIntoFnsScope(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        org.mozilla.javascript.tools.shell.Global.load(cx, funObj.getParentScope(), args, funObj);
    }

    public static Scriptable getFreshScopeObj(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        org.mozilla.javascript.tools.shell.Global gObj;
        Class<Window> c = Window.class;
        for (gObj = (org.mozilla.javascript.tools.shell.Global)ScriptableObject.getTopLevelScope(funObj); gObj != null && gObj.getClass() != c; gObj = (org.mozilla.javascript.tools.shell.Global)gObj.getPrototype()) {
        }
        if (gObj == null) {
            throw new IllegalStateException("Window.getFreshScopeObj: couldn't find our Global scope obj.");
        }
        return new Global(gObj);
    }

    public static Scriptable getProxyFor(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Window.getProxyFor: wrong argument count.");
        }
        Scriptable proxysTarget = (Scriptable)args[0];
        if (proxysTarget == null) {
            throw new IllegalArgumentException("Window.getProxyFor: can't proxy 'null'.");
        }
        Scriptable proxysScope = proxysTarget.getParentScope() == null ? proxysTarget : proxysTarget.getParentScope();
        return new Proxy(proxysScope, proxysTarget);
    }

    public static Scriptable getScope(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Window.getScope: wrong argument count.");
        }
        return ScriptableObject.getTopLevelScope((Function)args[0]);
    }

    public static void setScope(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Scriptable nextObj;
        Function targetFn;
        if (args.length != 2) {
            throw new IllegalArgumentException("Window.setScope: wrong argument count.");
        }
        Scriptable previousObj = targetFn = (Function)args[0];
        Scriptable currentObj = targetFn.getParentScope();
        while ((nextObj = currentObj.getParentScope()) != null) {
            previousObj = currentObj;
            currentObj = nextObj;
        }
        previousObj.setParentScope((Scriptable)args[1]);
    }

    public static NativeArray configureScope(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArrayList<Scriptable> pairs = new ArrayList<Scriptable>();
        Scriptable targetFn = (Scriptable)args[0];
        Object[] objectPair = new Object[]{targetFn, targetFn.getParentScope()};
        pairs.add(cx.newArray((Scriptable)funObj, objectPair));
        NativeArray argArray = (NativeArray)args[1];
        targetFn.setParentScope((Scriptable)argArray.get(0, thisObj));
        long len = argArray.getLength();
        int c = 0;
        while ((long)c < len - 1L) {
            Scriptable elem = (Scriptable)argArray.get(c, thisObj);
            objectPair = new Object[]{elem, elem.getParentScope()};
            pairs.add(cx.newArray((Scriptable)funObj, objectPair));
            Scriptable scope = (Scriptable)argArray.get(c + 1, thisObj);
            elem.setParentScope(scope);
            ++c;
        }
        return (NativeArray)cx.newArray((Scriptable)funObj, pairs.toArray());
    }

    public static void restoreScope(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        NativeArray jsPairs = (NativeArray)args[0];
        long len = jsPairs.getLength();
        int c = 0;
        while ((long)c < len) {
            NativeArray objAndItsScope = (NativeArray)jsPairs.get(c, thisObj);
            Scriptable anObj = (Scriptable)objAndItsScope.get(0, thisObj);
            Scriptable oldScope = (Scriptable)objAndItsScope.get(1, thisObj);
            anObj.setParentScope(oldScope);
            ++c;
        }
    }

    public static Integer javaHashCode(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Window.javaHashCode: wrong argument count, should be 1.");
        }
        if (args[0] == null) {
            throw new IllegalArgumentException("Window.javaHashCode: argument can't be null.");
        }
        return new Integer(args[0].hashCode());
    }
}

