package org.dyndns.nuda.logger;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import org.dyndns.nuda.reflect.ClassLoaderUtil;
import org.dyndns.nuda.tools.util.StringUtil;

public class SLF4JLoggerAdaptor implements LoggerAdaptor {
	private static Class<?>	loggerClass			= null;
	private static Class<?>	loggerFactoryClass	= null;
	
	private static Method	getLogger			= null;
	private static Method	debug				= null;
	private static Method	debugT				= null;
	private static Method	info				= null;
	private static Method	infoT				= null;
	private static Method	warn				= null;
	private static Method	warnT				= null;
	private static Method	error				= null;
	private static Method	errorT				= null;
	
	private Object			logger				= null;
	
	public SLF4JLoggerAdaptor() {
		if (loggerClass == null && loggerFactoryClass == null) {
			loggerClass = this.getLoggerClass();
			loggerFactoryClass = this.getLoggerFactoryClass();
			
			if (loggerClass == null) {
				String message =
					StringUtil.format(
						"以下のクラスが見つかりませんでした[{}]",
						this.getLoggerClassName());
				
				IllegalStateException e = new IllegalStateException(message);
				
				throw e;
			}
			if (loggerFactoryClass == null) {
				String message =
					StringUtil.format(
						"以下のクラスが見つかりませんでした[{}]",
						"org.slf4j.LoggerFactory");
				
				IllegalStateException e = new IllegalStateException(message);
				
				throw e;
			}
			
			this.initLoggerContainer();
		}
		this.createLoggerObject("default");
	}
	
	public SLF4JLoggerAdaptor(final String loggerName) {
		if (loggerClass == null && loggerFactoryClass == null) {
			loggerClass = this.getLoggerClass();
			loggerFactoryClass = this.getLoggerFactoryClass();
			
			if (loggerClass == null) {
				String message =
					StringUtil.format(
						"以下のクラスが見つかりませんでした[{}]",
						this.getLoggerClassName());
				
				IllegalStateException e = new IllegalStateException(message);
				
				throw e;
			}
			if (loggerFactoryClass == null) {
				String message =
					StringUtil.format(
						"以下のクラスが見つかりませんでした[{}]",
						"org.slf4j.LoggerFactory");
				
				IllegalStateException e = new IllegalStateException(message);
				
				throw e;
			}
			
			this.initLoggerContainer();
		}
		this.createLoggerObject(loggerName);
	}
	
	private void initLoggerContainer() {
		//		Logger l = LoggerFactory.getLogger("");
		//		l.debug("");
		//		l.info("");
		//		l.error("");
		//		l.warn("");
		if (loggerClass != null && loggerFactoryClass != null) {
			try {
				getLogger =
					loggerFactoryClass.getDeclaredMethod(
						"getLogger",
						new Class<?>[] { String.class });
				
				debug =
					loggerClass.getMethod(
						"debug",
						new Class<?>[] { String.class });
				debugT =
					loggerClass.getDeclaredMethod("debug", new Class<?>[] {
						String.class,
						Throwable.class });
				
				// infoメソッドの作成
				info =
					loggerClass.getDeclaredMethod(
						"info",
						new Class<?>[] { String.class });
				infoT =
					loggerClass.getDeclaredMethod("info", new Class<?>[] {
						String.class,
						Throwable.class });
				
				// errorメソッドの作成
				error =
					loggerClass.getDeclaredMethod(
						"error",
						new Class<?>[] { String.class });
				errorT =
					loggerClass.getDeclaredMethod("error", new Class<?>[] {
						String.class,
						Throwable.class });
				
				// warnメソッドの作成
				warn =
					loggerClass.getDeclaredMethod(
						"warn",
						new Class<?>[] { String.class });
				warnT =
					loggerClass.getDeclaredMethod("warn", new Class<?>[] {
						String.class,
						Throwable.class });
			} catch (SecurityException e) {
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public String getRecommendVersion() {
		// TODO 自動生成されたメソッド・スタブ
		return "1.7.5";
	}
	
	@Override
	public String getLoggerClassName() {
		return "org.slf4j.Logger";
	}
	
	@Override
	public Class<?> getLoggerClass() {
		boolean isValid =
			ClassLoaderUtil.isClassDefined(this.getLoggerClassName());
		if (isValid) {
			try {
				Class<?> loggerClass = Class.forName(this.getLoggerClassName());
				return loggerClass;
			} catch (ClassNotFoundException e) {
			}
		}
		return null;
	}
	
	private Class<?> getLoggerFactoryClass() {
		boolean isValid =
			ClassLoaderUtil.isClassDefined("org.slf4j.LoggerFactory");
		if (isValid) {
			try {
				Class<?> loggerFactoryClass =
					Class.forName("org.slf4j.LoggerFactory");
				return loggerFactoryClass;
			} catch (ClassNotFoundException e) {
			}
		}
		return null;
	}
	
	private void createLoggerObject(final String loggerName) {
		try {
			if (getLogger != null) {
				this.logger =
					getLogger.invoke(null, new Object[] { loggerName });
			}
			
		} catch (IllegalArgumentException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		} catch (InvocationTargetException e) {
			// TODO 自動生成された catch ブロック
			e.printStackTrace();
		}
	}
	
	@Override
	public LoggerAdaptor getLogger(final String loggerName) {
		return new SLF4JLoggerAdaptor(loggerName);
	}
	
	@Override
	public LoggerAdaptor getLogger(final Class<?> targetClass) {
		String className = targetClass.getCanonicalName();
		return this.getLogger(className);
	}
	
	@Override
	public void trace(final String format, final Object... params) {
		
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				debug.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void trace(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				debugT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void debug(final String format, final Object... params) {
		
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				debug.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void debug(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				debugT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void info(final String format, final Object... params) {
		
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				info.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void info(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				infoT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void warn(final String format, final Object... params) {
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				warn.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void warn(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				warnT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void error(final String format, final Object... params) {
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				error.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void error(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				errorT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void fatal(final String format, final Object... params) {
		if (getLogger != null && this.logger != null) {
			String message = StringUtil.format(format, params);
			
			try {
				error.invoke(this.logger, new Object[] { message });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
	@Override
	public void fatal(final String message, final Throwable t) {
		if (getLogger != null && this.logger != null) {
			try {
				errorT.invoke(this.logger, new Object[] { message, t });
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (IllegalAccessException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			}
		}
	}
	
}
