//
//  KCBFOMainWindowController.swift
//  KanColleBrowserForOSX
//
//  Created by Hori,Masaki on 2015/07/08.
//  Copyright (c) 2015年 Hori,Masaki. All rights reserved.
//

import Cocoa
import WebKit

class KCBFOMainWindowController: NSWindowController {
	
	@IBOutlet var clipView: NSClipView!
	var webView: WKWebView!
	
	var flashTopLeft: NSPoint = NSPoint(x: 600, y: 77)
	
	let gamePageURL = "http://www.dmm.com/netgame/social/-/gadgets/=/app_id=854854/"
    
    class func makeInstance() -> KCBFOMainWindowController {
        
        return KCBFOMainWindowController(windowNibName: NSNib.Name(rawValue: "KCBFOMainWindowController"))
    }
    
    
    override func windowDidLoad() {
        
        super.windowDidLoad()
        
        let pref = WKPreferences()
        pref.plugInsEnabled = true
        let config = WKWebViewConfiguration()
        config.preferences = pref
        config.applicationNameForUserAgent = "Version/11.1 Safari/605.1.15"
        
        let js = """
        var style = document.createElement('style');
        style.innerHTML = 'html { overflow: hidden; }';
        document.head.appendChild(style);
"""
        let script = WKUserScript(source: js, injectionTime: .atDocumentEnd, forMainFrameOnly: false)
        config.userContentController.addUserScript(script)
        
        let frame = CGRect(x: 0, y: 0, width: 2_000, height: 2_000)
        webView = WKWebView(frame: frame, configuration: config)
        webView.navigationDelegate = self
		
		clipView.documentView = webView
		
		adjustFlash()
		
		webView.allowsBackForwardNavigationGestures = false
        webView.allowsMagnification = false
        webView.allowsLinkPreview = false
        
        loadURLString(urlString: gamePageURL)
    }
    
    func loadURLString(urlString: String) {
        
        guard let url = URL(string: urlString) else { return }
        let req = URLRequest(url: url)
        webView.load(req)
    }
    
	
    @IBAction func reloadContent(_ sender: AnyObject?) {
        
        guard let _ = webView.url else {
            
                loadURLString(urlString: gamePageURL)
            
                return
        }
        
        // ゲームページでない場合はゲームページを表示する
        if let url = webView?.url, url.absoluteString != gamePageURL {
            
            loadURLString(urlString: gamePageURL)
            
            return
        }
        
        adjustFlash()
        
        webView.reload(sender)
        
    }
	@IBAction func reloadAndRecache(_ sender: AnyObject?) {
        
		URLCache.shared.removeAllCachedResponses()
		reloadContent(sender)
	}
	
	func adjustFlash() {
        
		clipView.scroll(to: flashTopLeft)
	}
	
	// MARK: - WebUIDelegate
	let ignoreTags = [WebMenuItemTagOpenLinkInNewWindow,
		WebMenuItemTagDownloadLinkToDisk,
		WebMenuItemTagOpenImageInNewWindow,
		WebMenuItemTagOpenFrameInNewWindow,
		WebMenuItemTagGoBack,
		WebMenuItemTagGoForward,
		WebMenuItemTagStop,
		WebMenuItemTagReload]
	
	func webView(_ sender: WebView!, contextMenuItemsForElement element: [AnyHashable: Any]!, defaultMenuItems: [AnyObject]!) -> [Any]! {
        
		return defaultMenuItems.compactMap {
            
			if ignoreTags.contains($0.tag) {
                
				return []
			}
            
			return [$0]
		}
	}
}

extension KCBFOMainWindowController: WKNavigationDelegate {
    
    func webView(_ webView: WKWebView, didFinish navigation: WKNavigation!) {
        
        webView.evaluateJavaScript(
            ["var iframe = document.getElementById('game_frame');",
             "var validIframe = 0;",
             "var atop = 0;",
             "var aleft = 0;",
             "var aWidth = 0;",
             "if(iframe) {",
             "    validIframe = 1;",
             "    var rect = iframe.getBoundingClientRect();",
             "    atop = rect.top;",
             "    aleft = rect.left;",
             "    aWidth = rect.width;",
             "}",
             "var dict = {valid:validIframe, top:atop, left:aleft, width:aWidth};",
             "dict;"]
                .reduce("", +)
        ) { (dict, error) in
            
            error.map { print($0) }
            
            guard let param = dict as? [String: Any] else {
                
                print("can not get dict")
                return
            }
            guard let valid = param["valid"] as? Int else {
                
                print("can not get invalid")
                return
            }
            guard valid == 1 else {
                
                return
            }
            guard let top = param["top"] as? Int,
                let left = param["left"] as? Int,
                let width = param["width"] as? Int else {
                    
                    return
            }
            
            DispatchQueue.main.async { [weak self] in
                
                guard let `self` = self else { return }
                
                self.flashTopLeft = NSPoint(x: CGFloat(left + (width - 800) / 2),
                                            y: CGFloat(top + 16))
                self.adjustFlash()
            }
        }
    }
}
