//
//  KMBSLogViewController.h
//  BathyScaphe
//
//  Created by 堀 昌樹 on 11/12/24.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "KMLogViewController.h"
#import "KMDocument.h"

@class KMWorkerEmulator;
@class KMStatusLineViewController;

#if !__LP64__
@class KMHistoryStack;
@class KMReplyMessenger;
@class KMBSLogViewDelegate;
@class KMBSLogPopUp;
#endif

@interface KMBSLogViewController : KMLogViewController
{
	KMWorkerEmulator *worker;
	NSLock *updatingLock;
	
	NSMutableDictionary *ranges;
	
#if !__LP64__
	KMStatusLineViewController *_statusLine;
	NSScrollView *_documentScrollView;
	NSTextView *_documentView;
	NSInteger _numberOfMessage;
	NSLayoutManager *_layoutManager;
	NSTextContainer *_textContainer;
	BOOL _hasTitleRuler;
	
	KMReplyMessenger *_messenger;
	
	NSCountedSet *_countedSet;
	
@private
	NSTextStorage *_privateTextStorage;
	KMHistoryStack *_histories;
	KMBSLogViewDelegate *_logViewDelegate;
	KMBSLogPopUp *_popUp;
#endif
}
@property (nonatomic, retain) KMStatusLineViewController *statusLine;
@property (readonly) NSScrollView *documentScrollView;
@property (readonly) NSLayoutManager *layoutManager;
@property (readonly) NSTextContainer *textContainer;
@property (nonatomic, retain) NSTextView *documentView;

@property (nonatomic, retain, readonly) NSCountedSet *countedSet;

@property (readonly) KMDocument *doc;
@property NSInteger numberOfMessage;

@property BOOL hasTitleRuler;

- (void)scrollMessageAtIndex:(NSUInteger)index;
@end

@interface KMBSLogViewController (Actions)
- (IBAction)reply:(id)sender;
- (IBAction)historyMenuPerformForward:(id)sender;
- (IBAction)historyMenuPerformBack:(id)sender;
- (IBAction)showBoardInspectorPanel:(id)sender;
@end

@interface KMBSLogViewController (MoveAction)
- (IBAction)scrollFirstMessage:(id)sender;
- (IBAction)scrollLastMessage:(id)sender;
- (IBAction)scrollPreviousMessage:(id)sender;
- (IBAction)scrollPrevMessage:(id)sender;
- (IBAction)scrollNextMessage:(id)sender;
- (IBAction)scrollPreviousBookmark:(id)sender;
- (IBAction)scrollNextBookmark:(id)sender;
- (IBAction)scrollToLastReadedIndex:(id)sender;
- (IBAction)scrollToLastUpdatedIndex:(id)sender;
- (IBAction)scrollToFirstTodayMessage:(id)sender;
- (IBAction)scrollToLatest50FirstIndex:(id)sender;
- (IBAction)scrollPrevBookmarkOrFirst:(id)sender;
- (IBAction)scrollNextBookmarkOrLast:(id)sender;
- (IBAction)showIndexPanel:(id)sender;
- (IBAction)scrollFromNavigator:(id)sender;
@end
@interface KMBSLogViewController (MoveActionValidation)
- (BOOL)canScrollToMessage;
- (BOOL)canScrollFirstMessage;
- (BOOL)canScrollLastMessage;
- (BOOL)canScrollPrevMessage;
- (BOOL)canScrollNextMessage;
- (BOOL)canScrollToLastReadedMessage;
- (BOOL)canScrollToLastUpdatedMessage;
@end

@interface KMBSLogViewController (ScalingText)
@property NSInteger scaleCount;

- (IBAction)biggerText:(id)sender;
- (IBAction)smallerText:(id)sender;
- (IBAction)actualSizeText:(id)sender;
- (IBAction)scaleSegmentedControlPushed:(id)sender;
@end
