//
//  CMRFavoritesManager+KMAddition.m
//  BathyScaphe
//
//  Created by 堀 昌樹 on 12/04/18.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "CMRFavoritesManager+KMAddition.h"

#import "CMRThreadAttributes.h"
#import "CMRThreadSignature.h"

#import <SGAppKit/SGAppKit.h>
#import "CMRThreadAttributes+KMAddition.h"


#define kAddFavaritesItemKey			@"Add Favorites"
#define kRemoveFavaritesItemKey			@"Remove Favorites"
#define kAddFavaritesItemImageName		@"AddFavoritesTemplate"
#define kRemoveFavaritesItemImageName	@"RemoveFavoritesTemplate"

@implementation CMRFavoritesManager (CMRFavoritesManager_KMAddition)
+ (NSString *)localizableStringsTableName
{
#define APP_TVIEW_LOCALIZABLE_FILE			@"ThreadViewer"
	return APP_TVIEW_LOCALIZABLE_FILE;
}


- (CMRFavoritesOperation)favoritesOperationForThreads:(NSArray *)threadsArray
{
    if (!threadsArray) {
        return CMRFavoritesOperationNone;
    }
    NSUInteger noneCount = 0;
    NSUInteger removeCount = 0;
    for (NSDictionary *thread in threadsArray) {
        CMRFavoritesOperation op = [self availableOperationWithPath:[thread path]];
        if (op == CMRFavoritesOperationRemove) {
            removeCount++;
        } else if (op == CMRFavoritesOperationNone) {
            noneCount++;
        }
    }
    NSUInteger threadsCount = [threadsArray count];
    if (threadsCount == noneCount) {
        return CMRFavoritesOperationNone;
    }
    if ((threadsCount - noneCount) == removeCount) {
        return CMRFavoritesOperationRemove;
    }
    return CMRFavoritesOperationLink;
}
- (BOOL)validateItem:(id)theItem withThreadAttributes:(NSArray *)attrs
{
	NSString *titleKey;
	
	CMRFavoritesOperation	operation;
	operation = [self favoritesOperationForThreads:attrs];
	if (CMRFavoritesOperationNone == operation) {
		return NO;
	}
	
    titleKey = (CMRFavoritesOperationLink == operation) ? kAddFavaritesItemKey : kRemoveFavaritesItemKey;
	[theItem setTitle:[self localizedString:titleKey]];
	
	if ([theItem image]) {
        NSString *imageName;
        imageName = (CMRFavoritesOperationLink == operation) ? kAddFavaritesItemImageName : kRemoveFavaritesItemImageName;
        NSImage *image_ =[NSImage imageAppNamed:imageName];
        [theItem setImage:image_];
	}
	return YES;
}
- (void)doActionWithThreadAttributes:(NSArray *)attrs
{
	CMRFavoritesOperation op = [self favoritesOperationForThreads:attrs];
    if (op == CMRFavoritesOperationNone) {
        return;
    }
	
	SEL operationSelector;
    operationSelector = (op == CMRFavoritesOperationLink) ? @selector(addFavoriteWithSignature:)
	: @selector(removeFromFavoritesWithSignature:);
    NSString *path;
    CMRThreadSignature *signature;
	
    for (NSDictionary *threadAttributes in attrs) {
		path = [threadAttributes path];
		UTILAssertNotNil(path);        
		signature = [CMRThreadSignature threadSignatureFromFilepath:path];
		UTILAssertNotNil(signature);
        [self performSelector:operationSelector withObject:signature];
    }
}
@end
