//
//  KMBSLogViewController.m
//  BathyScaphe
//
//  Created by 堀 昌樹 on 11/12/24.
//  Copyright (c) 2011年 __MyCompanyName__. All rights reserved.
//

#import "KMBSLogViewController.h"
#import "KMDocument.h"

#import "CMRThreadView.h"

#import <SGAppKit/BSLayoutManager.h>
#import "CMRMainMenuManager.h"
#import "AppDefaults.h"
#import "CMRMessageAttributesTemplate.h"

#import <SGAppKit/BSTitleRulerAppearance.h>
#import <SGAppKit/BSTitleRulerView.h>
#import <SGAppKit/NSTextView-SGExtensions.h>
#import <SGAppKit/NSWorkspace-SGExtensions.h>

#import "CMRThreadMessageBufferReader.h"
#import "CMRThreadComposingTask.h"

#import "KMWorkerEmulator.h"

@interface KMBSLogViewController() <NSTextViewDelegate>
@property (assign, readwrite) NSLayoutManager *layoutManager;
@property (assign, readwrite) NSTextContainer *textContainer;

@property (retain) NSTextStorage *privateTextStorage;

- (void)composeDocumentMessage:(id)sender;

@end

@interface KMBSLogViewController(BuildViews)
- (void)setupScrollView;
- (void)setupTextView;
@end

@interface KMBSLogViewController(CMRThreadLayout_Dummy)
- (void)scrollMessageWithRange:(NSRange)aRange;
- (NSDate *)lastUpdatedDateFromFirstHeaderAttachmentEffectiveRange:(NSRangePointer)effectiveRange;
- (NSRange)firstLastUpdatedHeaderAttachmentRange;
- (void)clearLastUpdatedHeader;
- (void)insertLastUpdatedHeader;
@end

@interface KMBSLogViewController (PopUpSupport)
- (BOOL)isMessageLink:(id)aLink messageIndexes:(NSIndexSet **)indexesPtr;
@end

@implementation KMBSLogViewController
@synthesize documentView = _documentView;
@synthesize layoutManager = _layoutManager;
@synthesize textContainer = _textContainer;
@synthesize privateTextStorage = _privateTextStorage;

@synthesize numberOfMessage = _numberOfMessage;

- (id)init
{
	self = [super initWithNibName:@"KMBSLogView" bundle:nil];
	if(self) {
		worker = [[KMWorkerEmulator alloc] init];
		updatingLock = [[NSLock alloc] init];
	}
	
	return self;
}
- (void)dealloc
{
	[_documentView release];
	[_privateTextStorage release];
	[updatingLock release];
	
	[super dealloc];
}
- (void)loadView
{
	[super loadView];
	
	[self setupScrollView];
	[self setupTextView];
}

- (KMDocument *)doc
{
	return (KMDocument *)self.representedObject;
}
- (NSWindow *)window
{
	return self.view.window;
}
- (NSScrollView *)documentScrollView
{
	return (NSScrollView *)self.view;
}

- (void)setRepresentedObject:(id)representedObject
{
	if(self.representedObject == representedObject) return;
	
	// clear text
	@synchronized(self) {
		[self.privateTextStorage setAttributedString:[[[NSAttributedString alloc] initWithString:@""] autorelease]];
	}
	self.numberOfMessage = 0;
	
	[[NSNotificationCenter defaultCenter] removeObserver:self
													name:KMDocumentDidChangeNotification
												  object:self.representedObject];
	[[NSNotificationCenter defaultCenter] removeObserver:self
													name:KMDocumentDidChangeMessageNotification
												  object:self.representedObject];
	[super setRepresentedObject:representedObject];
	
	if(!representedObject) return;
	
	[[NSNotificationCenter defaultCenter] addObserver:self
											 selector:@selector(documentDidChangeNotification:)
												 name:KMDocumentDidChangeNotification
											   object:representedObject];
	[[NSNotificationCenter defaultCenter] addObserver:self
											 selector:@selector(messageDidChangeNotification:)
												 name:KMDocumentDidChangeMessageNotification
											   object:representedObject];
	
	if([self.doc.messageBuffer count] != 0) {
		[self composeDocumentMessage:self];
	} else {
		[representedObject reload:self];
	}
}

// Composing sequence
/*
 -[KMBSLogViewController composeDcumentMessage:]
 
 on other thread
 -[KMBSLogViewController addMessagesFromBuffer:]
 -[KMBSLogViewController threadComposingDidFinish:]
 
 on main thread
 -[KMBSLogViewController appendMessageAttributeString:]
*/
- (void)composeDocumentMessage:(id)sender
{
	// unlock in -apppendMessageAttributeString: method.
	[updatingLock lock];
	
	KMDocument *doc = self.representedObject;
	NSString *boardName = doc.boardName;
	NSString *threadTitle = doc.threadTitle;
	NSString *datIdentifier = doc.datIdentifier;
	
	CMRThreadMessageBufferReader *reader = [CMRThreadMessageBufferReader readerWithContents:doc.messageBuffer];
	[reader setNextMessageIndex:self.numberOfMessage];
	CMRThreadComposingTask *task = [CMRThreadComposingTask taskWithThreadReader:reader];
	[task setThreadTitle:threadTitle];
	[task setIdentifier:datIdentifier];
	[task setDelegate:self];
	worker.layoutDummy = self;
	[worker push:task];
	
	if(boardName && threadTitle) {
		NSString *rulerTitle = [NSString stringWithFormat:@"%@ %C %@", threadTitle, 0x2014, boardName];
		BSTitleRulerView *view_ = (BSTitleRulerView *)[self.documentScrollView horizontalRulerView];
		[view_ setTitleStr:rulerTitle];
		[view_ setPathStr:doc.path];
	}
	
	if(sender == self) {
		[self.doc reload:self];
	}
}

- (void)apppendMessageAttributeString:(NSMutableAttributedString *)aTextBuffer
{
	if(!aTextBuffer) goto finish;
	
	if ([aTextBuffer length]) {
		[aTextBuffer fixAttributesInRange:[aTextBuffer range]];
		@synchronized(self) {
			if(self.privateTextStorage.length != 0) {
				[self insertLastUpdatedHeader];
			}
			[self.privateTextStorage appendAttributedString:aTextBuffer];
		}
	}
	
	if ([CMRPref scrollToLastUpdated]) {
		NSRange range = [self firstLastUpdatedHeaderAttachmentRange];
		if(range.location != NSNotFound) {
			[self scrollMessageWithRange:range];
		}
	}
finish:
	[updatingLock unlock];
}
- (void)threadComposingDidFinish:(NSMutableAttributedString *)aTextBuffer
{
	[self performSelectorOnMainThread:@selector(apppendMessageAttributeString:)
						   withObject:aTextBuffer
						waitUntilDone:NO];
}
- (void)addMessagesFromBuffer:(CMRThreadMessageBuffer *)buf
{
	// NSLog(@"buf class is %@.", NSStringFromClass([buf class]));
	self.numberOfMessage += [buf count];
}
- (void)addMessageRange:(NSRange)range
{
	// repeat by adding messange
}


- (void)documentDidChangeNotification:(id)no
{
	[self composeDocumentMessage:nil];
}
@end


#import "CMRThreadMessage.h"
#import "CMRThreadMessageBuffer.h"
#import "CMRAttributedMessageComposer.h"

@implementation KMBSLogViewController(CMRThreadLayout_Dummy)
#pragma mark CMRThreadLayout ?
- (CMRThreadLayout *)threadLayout
{
	return (CMRThreadLayout *)self;
}

// レスアンカーポップアップ用
- (NSAttributedString *)contentsForIndexes:(NSIndexSet *)indexSet
{
	// compose text storage
	CMRAttributedMessageComposer *composer_ = [[[CMRAttributedMessageComposer alloc] init] autorelease];
	NSMutableAttributedString *textBuffer_ = [[NSMutableAttributedString alloc] init];
	[composer_ setAttributesMask:CMRLocalAbonedMask|CMRSpamMask];
	[composer_ setComposingMask:CMRInvisibleAbonedMask compose:NO];
	[composer_ setContentsStorage:textBuffer_];
	
	NSRange inRange = NSMakeRange(0, [indexSet lastIndex] + 1);
	NSUInteger index = NSNotFound;
	while ([indexSet getIndexes:&index maxCount:1 inIndexRange:&inRange] > 0) {
		CMRThreadMessage *message = [self.doc.messageBuffer messageAtIndex:index];
		if(!message) break;
		[message setIndex:index];
		
		[composer_ composeThreadMessage:message];
	}
	
	return [textBuffer_ autorelease];
}

// 逆参照ポップアップ用
- (NSAttributedString *)contentsForTargetIndex:(NSUInteger)messageIndex
								 composingMask:(UInt32)composingMask
									   compose:(BOOL)doCompose
								attributesMask:(UInt32)attributesMask
{
	CMRThreadMessage	*m;
	NSUInteger	limit = [self.doc.messageBuffer count];
	NSUInteger	i;
	NSMutableAttributedString		*textBuffer_;
	CMRAttributedMessageComposer	*composer_;
	
	if (limit == 0) return nil;
	
	composer_ = [[CMRAttributedMessageComposer alloc] init];
	textBuffer_ = [[NSMutableAttributedString alloc] init];
	
	[composer_ setAttributesMask:attributesMask];
	[composer_ setComposingMask:composingMask compose:doCompose];
	[composer_ setComposingTargetIndex:messageIndex];
	[composer_ setContentsStorage:textBuffer_];
	
	for (i = 0; i < limit; i++) {
		m = [[self.doc messageBuffer] messageAtIndex:i];
		[composer_ composeThreadMessage:m];
	}
	[composer_ release];
	return [textBuffer_ autorelease];
}

- (NSRange)rangeAtMessageIndex:(NSUInteger)anIndex
{
	NSNumber *indexValue = [NSNumber numberWithInteger:anIndex];
	__block NSRange targetRange = {NSNotFound,0};
	__block BOOL lastMessage = YES;
	
	@synchronized(self) {
		NSRange range = NSMakeRange(0, [self.privateTextStorage length]);
		[self.privateTextStorage enumerateAttribute:CMRMessageIndexAttributeName
											inRange:range
											options:NSAttributedStringEnumerationLongestEffectiveRangeNotRequired
										 usingBlock:^(id value, NSRange range, BOOL *stop) {
											 if([value integerValue] > anIndex) {
												 *stop = YES;
												 targetRange.length = range.location - targetRange.location;
												 lastMessage = NO;
											 }
											 if([value isEqual:indexValue]) {
												 targetRange = range;
											 }
										 }];
		if(targetRange.location == NSNotFound) return targetRange;
		if(lastMessage) {
			targetRange.length = self.privateTextStorage.length - targetRange.location;
		}
	}
	return targetRange;
}
- (void)scrollMessageWithRange:(NSRange)aRange
{
	CMRThreadView	*textView = (CMRThreadView *)[self documentView];
    BOOL needsAdjust = ![CMRPref oldMessageScrollingBehavior];
	
    if (needsAdjust) {
        // 2010-08-15 tsawada2
        // non-contiguous layout でこのおまじないが効く
        [textView scrollRangeToVisible:aRange];
    }
	NSRect			characterBoundingRect;
	NSRect			newVisibleRect;
    NSRect          currentVisibleRect;
	NSPoint			newOrigin;
	NSClipView		*clipView;
	
	if (NSNotFound == aRange.location || 0 == aRange.length) {
		NSBeep();
		return;
	}
	
	characterBoundingRect = [textView boundingRectForCharacterInRange:aRange];
	if (NSEqualRects(NSZeroRect, characterBoundingRect)) {
        return;
	}
	
	clipView = [self.documentScrollView contentView];
	currentVisibleRect = [clipView documentVisibleRect];
	
	newOrigin = [textView bounds].origin;
	newOrigin.y = characterBoundingRect.origin.y;	
	
    newVisibleRect = currentVisibleRect;
	newVisibleRect.origin = newOrigin;
	
	if (!NSEqualRects(newVisibleRect, currentVisibleRect)) {
		// 表示予定領域(newVisibleRect)のGlyphがレイアウトされていることを保証する
        [self.layoutManager ensureLayoutForBoundingRect:newVisibleRect inTextContainer:self.textContainer];
		// ----------------------------------------
		// Simulate user scroll
		// ----------------------------------------
        if (needsAdjust) {
            newVisibleRect.origin = [clipView constrainScrollPoint:newOrigin];
        }
		newVisibleRect = [[clipView documentView] adjustScroll:newVisibleRect];
		[clipView scrollToPoint:newVisibleRect.origin];
		[self.documentScrollView reflectScrolledClipView:clipView];
	}
}
- (void)scrollMessageAtIndex:(NSUInteger)anIndex
{
	NSRange range = [self rangeAtMessageIndex:anIndex];
	if(range.location == NSNotFound) return;
	
	[self scrollMessageWithRange:range];
}

- (void)messageDidChangeNotification:(NSNotification *)notification
{
	id info = [notification userInfo];
	NSNumber *indexValue = [info objectForKey:KMDocumentChangedMessageIndexKey];
	NSUInteger anIndex = [indexValue integerValue];
	
	
	NSMutableAttributedString		*textBuffer_;
	CMRAttributedMessageComposer	*composer_;
	CMRThreadMessage				*m;
	NSRange							mesRange_;
	
	if (NSNotFound == anIndex || [self.doc.messageBuffer count] <= anIndex) {
		return;
    }
	
	
	do {
		m = [[self.doc messageBuffer] messageAtIndex:anIndex];
		mesRange_ = [self rangeAtMessageIndex:anIndex];
		// 非表示のレスは生成しない
		if (![m isVisible]) {
			if (mesRange_.length != 0) {
				@synchronized(self) {
					[self.privateTextStorage deleteCharactersInRange:mesRange_];
				}
			}
			break;
		}
		
		composer_ = [[CMRAttributedMessageComposer alloc] init];
		textBuffer_ = [[NSMutableAttributedString alloc] init];
		
		[composer_ setComposingMask:CMRInvisibleMask compose:NO];
		[composer_ setContentsStorage:textBuffer_];
		
		[composer_ composeThreadMessage:m];
		
		@synchronized(self) {
			[self.privateTextStorage replaceCharactersInRange:mesRange_
										 withAttributedString:textBuffer_];
		}
		
		[textBuffer_ release];
		[composer_ release];
		textBuffer_ = nil;
		composer_ = nil;
	} while (0);
	
    [[self layoutManager] invalidateDisplayForCharacterRange:mesRange_];
    [[self layoutManager] ensureLayoutForCharacterRange:mesRange_];
}

- (NSDate *)lastUpdatedDateFromHeaderAttachment
{
	return [self lastUpdatedDateFromFirstHeaderAttachmentEffectiveRange:NULL];
}

- (NSRange)firstLastUpdatedHeaderAttachmentRange
{
	NSRange effectiveRange_;
	
	[self lastUpdatedDateFromFirstHeaderAttachmentEffectiveRange:&effectiveRange_];
	return effectiveRange_;
}

- (NSDate *)lastUpdatedDateFromFirstHeaderAttachmentEffectiveRange:(NSRangePointer)effectiveRange
{
	@synchronized(self) {
		NSTextStorage	*content_ = self.privateTextStorage;
		NSUInteger		charIndex_;
		NSUInteger		toIndex_;
		NSRange			charRng_;
		NSRange			range_;
		id				value_ = nil;
		
		charRng_ = NSMakeRange(0, [content_ length]);
		charIndex_ = charRng_.location;
		toIndex_   = NSMaxRange(charRng_);
		
		while (charIndex_ < toIndex_) {
			value_ = [content_ attribute:CMRMessageLastUpdatedHeaderAttributeName
								 atIndex:charIndex_
				   longestEffectiveRange:&range_
								 inRange:charRng_];
			if (value_) {
				if (effectiveRange != NULL) {
					*effectiveRange = range_;
				}
				if (![value_ isKindOfClass:[NSDate class]]) {
					return nil;
				}
				return (NSDate *)value_;
			}
			charIndex_ = NSMaxRange(range_);
		}
		if (effectiveRange != NULL) {
			*effectiveRange = NSMakeRange(NSNotFound, 0);
		}
	}
	return nil;
}

- (void)appendLastUpdatedHeader:(BOOL)flag
{
	NSAttributedString	*header_;
	NSRange				range_;
	id					templateMgr = [CMRMessageAttributesTemplate sharedTemplate];
	
	header_ = [templateMgr lastUpdatedHeaderAttachment];
	if (!header_) { 
		return;
    }
	@synchronized(self) {
		NSTextStorage		*tS_ = self.privateTextStorage;
		[tS_ beginEditing];
		range_.location = [tS_ length];
		[tS_ appendAttributedString:header_];
		range_.length = [tS_ length] - range_.location;
		// 現在の日付を属性として追加
		[tS_ addAttribute:CMRMessageLastUpdatedHeaderAttributeName value:[NSDate date] range:range_];
		[tS_ endEditing];
	}
}

- (void)appendLastUpdatedHeader
{
    [self appendLastUpdatedHeader:YES];
}

- (void)clearLastUpdatedHeader:(BOOL)flag
{
	NSRange headerRange_;
	
	headerRange_ = [self firstLastUpdatedHeaderAttachmentRange];
	if (NSNotFound == headerRange_.location) {
        return;
    }
	
	@synchronized(self) {
		[self.privateTextStorage deleteCharactersInRange:headerRange_];
	}
}

- (void)clearLastUpdatedHeader
{
    [self clearLastUpdatedHeader:YES];
}

- (void)insertLastUpdatedHeader
{
    [self clearLastUpdatedHeader:NO];
    [self appendLastUpdatedHeader:NO];
}


// KMDocument
- (NSArray *)messagesAtIndexes:(NSIndexSet *)indexes
{
	return [self.doc messagesAtIndexes:indexes];
}
- (NSUInteger)numberOfReadedMessages
{
	return [self.doc numberOfReadedMessages];
}
@end



@implementation KMBSLogViewController(BuildViews)
#pragma mark Title Ruler
- (BOOL)shouldShowTitleRulerView
{
	return YES;
}

+ (BSTitleRulerModeType)rulerModeForInformDatOchi
{
	return BSTitleRulerShowTitleOnlyMode;
}

+ (NSString *)titleRulerAppearanceFilePath
{
	NSString *path;
	NSBundle *appSupport = [NSBundle applicationSpecificBundle];
	
	path = [appSupport pathForResource:@"BSTitleRulerAppearance" ofType:@"plist"];
	if (!path) {
		path = [[NSBundle mainBundle] pathForResource:@"BSTitleRulerAppearance" ofType:@"plist"];
	}
	return path;
}

- (void)setupTitleRulerWithScrollView:(NSScrollView *)scrollView_
{
	id ruler;
	NSString *path = [[self class] titleRulerAppearanceFilePath];
	UTILAssertNotNil(path);
	BSTitleRulerAppearance *foo = [NSKeyedUnarchiver unarchiveObjectWithFile:path];
	
	[[scrollView_ class] setRulerViewClass:[BSTitleRulerView class]];
	ruler = [[BSTitleRulerView alloc] initWithScrollView:scrollView_ appearance:foo];
	[ruler setTitleStr:NSLocalizedString(@"titleRuler default title", @"Startup Message")];
	
	[scrollView_ setHorizontalRulerView:ruler];
    [ruler release];
	[scrollView_ setHasHorizontalRuler:YES];
	[scrollView_ setRulersVisible:[self shouldShowTitleRulerView]];
}

- (void)cleanUpTitleRuler:(NSTimer *)aTimer
{
	BSTitleRulerView *view_ = (BSTitleRulerView *)[self.documentScrollView horizontalRulerView];
	
	[self.documentScrollView setRulersVisible:[self shouldShowTitleRulerView]];
	[view_ setCurrentMode:BSTitleRulerShowTitleOnlyMode];
}



//- (void)validateIndexingNavigator
//{
//    NSNotification *notification = [NSNotification notificationWithName:BSShouldValidateIdxNavNotification object:self];
//    [[NSNotificationQueue defaultQueue] enqueueNotification:notification
//                                               postingStyle:NSPostWhenIdle
//                                               coalesceMask:(NSNotificationCoalescingOnName|NSNotificationCoalescingOnSender)
//                                                   forModes:nil];
//}
- (void)contentViewBoundsDidChange:(NSNotification *)notification
{
	UTILAssertNotificationName(
							   notification,
							   NSViewBoundsDidChangeNotification);
	UTILAssertNotificationObject(
								 notification,
								 [self.documentScrollView contentView]);
	
//	[self validateIndexingNavigator];
}
- (void)setupScrollView
{
	NSClipView		*contentView_;
	
	contentView_ = [self.documentScrollView contentView];
	[contentView_ setPostsBoundsChangedNotifications:YES];
	
	[[NSNotificationCenter defaultCenter] addObserver:self
											 selector:@selector(contentViewBoundsDidChange:)
												 name:NSViewBoundsDidChangeNotification
											   object:contentView_];
	
	[self.documentScrollView setBorderType:NSNoBorder];
	[self.documentScrollView setHasHorizontalScroller:NO];
	[self.documentScrollView setHasVerticalScroller:YES];
	
	[self setupTitleRulerWithScrollView:self.documentScrollView];
}

- (NSMenu *)loadContextualMenuForTextView
{
	NSMenu	*menu_;
	
	NSMenu	*textViewMenu_;
	NSEnumerator *iter_;
	NSMenuItem	*item_;
	
	menu_ = [[CMRMainMenuManager defaultManager] threadContexualMenuTemplate];
	textViewMenu_ = [CMRThreadView messageMenu];
	
	[menu_ addItem:[NSMenuItem separatorItem]];
	
	iter_ = [[textViewMenu_ itemArray] objectEnumerator];
	while (item_ = [iter_ nextObject]) {
		item_ = [item_ copy];
		[menu_ addItem:item_];
		[item_ release];
	}
	
	return menu_;
}
- (void)setupTextViewBackground
{
	NSColor		*color = [[CMRPref threadViewTheme] backgroundColor];
	
	// textView
	[self.documentView setDrawsBackground:YES];
	[self.documentView setBackgroundColor:color];
	// scrollView
	[self.documentScrollView setDrawsBackground:YES];
	[self.documentScrollView setBackgroundColor:color];
}
- (void)updateLayoutSettings
{
//	[(BSLayoutManager *)[documentView layoutManager] setShouldAntialias:[CMRPref shouldThreadAntialias]];
	[self.documentView setLinkTextAttributes:[[CMRMessageAttributesTemplate sharedTemplate] attributesForAnchor]];
}

- (void)setupTextView
{
	NSLayoutManager		*layout;
	NSTextContainer		*container;
	NSTextView			*view;
	NSRect				cFrame;
	
	cFrame.origin = NSZeroPoint; 
	cFrame.size = [self.documentScrollView contentSize];
	
	/* LayoutManager */
	layout = [[BSLayoutManager alloc] init];
	[layout setAllowsNonContiguousLayout:YES];
	self.layoutManager = layout;
	
	self.privateTextStorage = [[[NSTextStorage alloc] init] autorelease];
	[self.privateTextStorage addLayoutManager:layout];
	[layout release];
	
	/* TextContainer */
	container = [[NSTextContainer alloc] initWithContainerSize:NSMakeSize(NSWidth(cFrame), 1e7)];
	[layout addTextContainer:container];
	self.textContainer = container;
	[container release];
	
	/* TextView */
	view = [[CMRThreadView alloc] initWithFrame:cFrame textContainer:container];
	
	[view setMinSize:NSMakeSize(0.0, NSHeight(cFrame))];
	[view setMaxSize:NSMakeSize(1e7, 1e7)];
	[view setVerticallyResizable:YES];
	[view setHorizontallyResizable:NO];
	[view setAutoresizingMask:NSViewWidthSizable];
	
	[container setWidthTracksTextView:YES];
	
	[view setEditable:NO];
	[view setSelectable:YES];
	[view setAllowsUndo:NO];
	[view setImportsGraphics:NO];
	[view setFieldEditor:NO];
	
	[view setMenu:[self loadContextualMenuForTextView]];
	[view setDelegate:self];
	
    [view setDisplaysLinkToolTips:NO];
	
	self.documentView = view;
	
	[self setupTextViewBackground];
	[self updateLayoutSettings];
	
	[self.documentScrollView setDocumentView:view];
	
	[view release];
}


@end


#pragma mark-
#pragma mark#### Popup and HTML ####

#import "CMRThreadLinkProcessor.h"
#import "CMXPopUpWindowManager.h"
#import "CMRHostHandler.h"
#import "SGDownloadLinkCommand.h"
#import "CMRDocumentFileManager.h"
#import "CMRReplyMessenger.h"
#import "BSSpamJudge.h"
#import "BSMessageSampleRegistrant.h"
#import "BSAsciiArtDetector.h"
#import "CMRThreadAttributes.h"


#import "DatabaseManager.h"


#define kBeProfileLinkTemplateKey	@"System - be2ch Profile URL"



@implementation KMBSLogViewController (PopUpSupport)
- (NSAttributedString *)attributedStringWithLinkContext:(id)aLink
{
	static NSMutableAttributedString *kBuffer = nil;
	
	NSString		*address_;
	NSString		*logPath_ = nil;
	NSString		*boardName_ = nil;	// added in PrincessBride and later.
	
	if (!aLink) {
        return nil;
    }
	if (!kBuffer) {
		kBuffer = [[NSMutableAttributedString alloc] init];
    }
	[kBuffer deleteCharactersInRange:[kBuffer range]];
	
	address_ = [[aLink stringValue] stringByDeletingURLScheme:@"mailto"];
	if (address_) {
		NSDictionary *attributes_;
		
		attributes_ = [[CMRMessageAttributesTemplate sharedTemplate] attributesForText];
		[[kBuffer mutableString] appendString:address_];
		[kBuffer setAttributes:attributes_ range:[kBuffer range]]; 
	} else if ([CMRThreadLinkProcessor parseThreadLink:aLink boardName:&boardName_ boardURL:NULL filepath:&logPath_]) {
		NSDictionary			*dict_;
		NSAttributedString		*template_;
		NSString				*title_;
		
		dict_ = [[[NSDictionary alloc] initWithContentsOfFile:logPath_] autorelease];
		if (!dict_) {
			// データベース上にあるか
			NSString *threadID = [[logPath_ stringByDeletingPathExtension] lastPathComponent];
			NSString *threadTitle = [[DatabaseManager defaultManager] threadTitleFromBoardName:boardName_ threadIdentifier:threadID];
			if (threadTitle) {
				title_ = [NSString stringWithFormat:@"%@ %C %@", threadTitle, 0x2014, boardName_];
			} else {
				title_ = boardName_;
			}
			//
			//			template_ = [[[NSAttributedString alloc] initWithString:title_] autorelease];
			//			if (!template_) {
			//                goto ErrInvalidLink;
			//            }
			//			[kBuffer setAttributedString:template_];
		} else {
			//            CMRThreadAttributes *attr_ = [[[CMRThreadAttributes alloc] initWithDictionary:dict_] autorelease];
			title_ = [NSString stringWithFormat:@"%@ %C %@", [dict_ objectForKey:CMRThreadTitleKey], 0x2014, boardName_];
        }
        template_ = [[[NSAttributedString alloc] initWithString:title_] autorelease];
        if (!template_) {
            goto ErrInvalidLink;
        }
        [kBuffer setAttributedString:template_];
	} else if ([CMRThreadLinkProcessor parseBoardLink:aLink boardName:&boardName_ boardURL:NULL]) {
		[kBuffer setAttributedString:[[[NSAttributedString alloc] initWithString:boardName_] autorelease]];
	} else {
		NSIndexSet	*indexes;
		NSAttributedString *message_;
		
		if (![self isMessageLink:aLink messageIndexes:&indexes]) {
            goto ErrInvalidLink;
        }
		message_ = [[self threadLayout] contentsForIndexes:indexes];
		if (message_) {
            [kBuffer appendAttributedString:message_];
        }
	}
	
	return kBuffer;
	
ErrInvalidLink:
	return nil;
}

- (BOOL) tryShowPopUpWindowWithLink : (id     ) aLink
                       locationHint : (NSPoint) loc
{
	NSPoint					location_ = loc;
	NSAttributedString		*context_;
	
	context_ = [self attributedStringWithLinkContext : aLink];
	if (nil == context_ || 0 == [context_ length])
		return NO;
	
	
	[CMRPopUpMgr showPopUpWindowWithContext : context_
								  forObject : aLink
									  owner : self
							   locationHint : location_];
	
	return YES;
}
- (BOOL) tryShowPopUpWindowSubstringWithRange : (NSRange		) subrange
								inTextStorage : (NSTextStorage *) storage
								 locationHint : (NSPoint		) loc
{
	NSString			*linkstr_;
	
	if (0 == subrange.length) return NO;
	if (nil == storage) return NO;
	if (NSMaxRange(subrange) >= [storage length]) return NO;
	
	linkstr_ = [storage string];
	linkstr_ = [linkstr_ substringWithRange : subrange];
	linkstr_ = CMRLocalResLinkWithString(linkstr_);
	
	return [self tryShowPopUpWindowWithLink : linkstr_
							   locationHint : loc];
}

- (NSIndexSet *)isStandardMessageLink:(id)aLink
{
	NSURL			*link_;
	CMRHostHandler	*handler_;
	NSString		*bbs_;
	NSString		*key_;
	
	NSUInteger	stIndex_;
	NSUInteger	endIndex_;
	NSRange			moveRange_;
	
	link_ = [NSURL URLWithLink:aLink];
	handler_ = [CMRHostHandler hostHandlerForURL:link_];
	if (!handler_) return nil;
	
	if (![handler_ parseParametersWithReadURL:link_
										  bbs:&bbs_
										  key:&key_
										start:&stIndex_
										   to:&endIndex_
									showFirst:NULL]) {
		return nil;
	}
	
	if (NSNotFound != stIndex_) {
		moveRange_.location = stIndex_ -1;
		moveRange_.length = (endIndex_ - stIndex_) +1;
	} else {
		return nil;		
	}
	
	// 同じ掲示板の同じスレッドならメッセージ移動処理
	if ([self.doc.bbsIdentifier isEqualToString:bbs_] && [self.doc.datIdentifier isEqualToString:key_]) {
		return [NSIndexSet indexSetWithIndexesInRange:moveRange_];
	}
	
	return nil;
}

- (BOOL)isMessageLink:(id)aLink messageIndexes:(NSIndexSet **)indexesPtr
{
	NSIndexSet		*indexes;
	if (!aLink) return NO;
	
	if ([CMRThreadLinkProcessor isMessageLinkUsingLocalScheme:aLink messageIndexes:indexesPtr]) {
		return YES;
	} else if ((indexes = [self isStandardMessageLink:aLink])) {
		if (indexesPtr != NULL) *indexesPtr = indexes;
		return YES;
	}
	
	return NO;
}
#pragma mark ID Popup Support
- (void)extractMessagesWithIDString:(NSString *) IDString
					  popUpLocation:(NSPoint) location
{
	NSMutableAttributedString		*textBuffer_;
	CMRAttributedMessageComposer	*composer_;
	CMXPopUpWindowController		*popUp_;
	NSUInteger						nFound = 0;
	//	UInt32							attributesMask_ = CMRAnyAttributesMask;
	
	if (!IDString || [IDString length] == 0) return;
	
	composer_ = [[CMRAttributedMessageComposer alloc] init];
	textBuffer_ = [[NSMutableAttributedString alloc] init];
	/*	
	 attributesMask_ &= ~CMRAsciiArtMask;
	 attributesMask_ &= ~CMRBookmarkMask;
	 
	 [composer_ setAttributesMask : attributesMask_];*/
	// 「迷惑レス」で「表示しない」の場合は CMRAttributedMessageComposer 側が判断して生成しないのでこれで良い
	[composer_ setComposingMask: (CMRLocalAbonedMask|CMRInvisibleAbonedMask) compose : NO];	
	[composer_ setContentsStorage:textBuffer_];
	
	for(CMRThreadMessage *message in [self.doc.messageBuffer messages]) {
		NSString *IDValue = [message valueForKey: @"IDString"];
		if (!IDValue || [IDValue length] == 0) continue;
		
		if ([IDValue isEqualToString: IDString]) {
			nFound++;
			[composer_ composeThreadMessage:message];
		}
	}
	
	if (0 == nFound) {
		// #warning 64BIT: Check formatting arguments
		// 2010-03-28 tsawada2 検証済
		NSString *notFoundString = [NSString stringWithFormat: [self localizedString: @"Such ID Not Found"], IDString];
		NSAttributedString *notFoundAttrStr = [[NSAttributedString alloc] initWithString:notFoundString];
		[textBuffer_ appendAttributedString:notFoundAttrStr];
		[notFoundAttrStr release];
	}
	
	popUp_ = [CMRPopUpMgr showPopUpWindowWithContext:textBuffer_
										   forObject:self.doc.datIdentifier
											   owner:self
										locationHint:location];
	
	[composer_ release];
	[textBuffer_ release];
	composer_ = nil;
	textBuffer_ = nil;
}

@end

@implementation KMBSLogViewController (NSTextViewDelegate)
- (void)openMessagesWithIndexes:(NSIndexSet *)indexes
{
	if (!indexes || [indexes count] == 0) {
        return;
    }
	
    NSURL *boardURL = self.doc.boardURL;
    CMRHostHandler *handler = [CMRHostHandler hostHandlerForURL:self.doc.boardURL];
	NSURL *url = [handler readURLWithBoard:boardURL datName:self.doc.datIdentifier start:[indexes firstIndex]+1 end:[indexes lastIndex]+1 nofirst:YES];
	
    if (url) {
        [[NSWorkspace sharedWorkspace] openURL:url inBackground:[CMRPref openInBg]];
	}
}

#pragma mark Previewing (or Downloading) Link
static inline NSString *urlPathExtension(NSURL *url)
{
	CFStringRef extensionRef = CFURLCopyPathExtension((CFURLRef)url);
	if (!extensionRef) {
		return nil;
	}
	NSString *extension = [(NSString *)extensionRef lowercaseString];
	CFRelease(extensionRef);
	return extension;
}

- (NSDictionary *)refererThreadInfoForLinkDownloader
{
    return [NSDictionary dictionaryWithObjectsAndKeys:[self title], kRefererTitleKey, [self.doc.threadURL absoluteString], kRefererURLKey, NULL];
}

- (BOOL)previewOrDownloadURL:(NSURL *)url
{
    if (!url || [[url scheme] isEqualToString:@"mailto"]) {
        return NO;
    }
	
	NSArray		*extensions = [CMRPref linkDownloaderExtensionTypes];
	NSString	*linkExtension = urlPathExtension(url);
	
	if (linkExtension && [extensions containsObject:linkExtension]) {
		SGDownloadLinkCommand *dlCmd = [SGDownloadLinkCommand functorWithObject:[url absoluteString]];
		[dlCmd setRefererThreadInfo:[self refererThreadInfoForLinkDownloader]];
		[dlCmd execute:self];
		return YES;
	}
	
	
    id<BSLinkPreviewing> previewer = [CMRPref sharedLinkPreviewer];
    if (previewer) {
        return [previewer validateLink:url] ? [previewer previewLink:url] : NO;
    } else {
        id<BSImagePreviewerProtocol> oldPreviewer = [CMRPref sharedImagePreviewer];
        if (oldPreviewer) {
            return [oldPreviewer validateLink:url] ? [oldPreviewer showImageWithURL:url] : NO;
        }
    }
    return NO;
}

- (void)openURLsWithAppStore:(NSArray *)array
{
    [[NSWorkspace sharedWorkspace] openURLs:array
                    withAppBundleIdentifier:@"com.apple.appstore"
                                    options:NSWorkspaceLaunchDefault
             additionalEventParamDescriptor:nil
                          launchIdentifiers:NULL];
}

- (BOOL)handleExternalLink:(id)aLink forView:(NSView *)aView
{
	BOOL			shouldPreviewWithNoModifierKey = [CMRPref previewLinkWithNoModifierKey];
	BOOL			isOptionKeyPressed;
	BOOL			isFileURL;
	NSURL			*url = [NSURL URLWithLink:aLink];
	NSEvent			*theEvent;
	
	theEvent = [[aView window] currentEvent];
	UTILAssertNotNil(theEvent);
	
	isOptionKeyPressed = (([theEvent modifierFlags] & NSAlternateKeyMask) == NSAlternateKeyMask);
	isFileURL = [url isFileURL];
	
    if ([CMRPref convertsHttpToItmsIfNeeded] && [[url host] isEqualToString:@"itunes.apple.com"]) {
        NSMutableString *tmp = [[url absoluteString] mutableCopy];
        if ([tmp hasSuffix:@"?mt=12"]) { // Mac App Store URL ?
            [tmp replaceCharactersInRange:NSMakeRange(0,4) withString:@"macappstore"];
            NSURL *newURL2 = [NSURL URLWithString:tmp];
            [tmp release];
			
            // App Store.app が既に起動しているかどうか？
            NSArray *apps = [[NSWorkspace sharedWorkspace] launchedApplications];
            id hoge = [apps valueForKey:@"NSApplicationBundleIdentifier"];
            if ([hoge containsObject:@"com.apple.appstore"]) {
                // 既に起動しているなら直ちに開かせる
                [self openURLsWithAppStore:[NSArray arrayWithObject:newURL2]];
                return YES;
            } else {
                // App Store.app の起動を試みる
                BOOL launched = [[NSWorkspace sharedWorkspace] launchAppWithBundleIdentifier:@"com.apple.appstore"
                                                                                     options:NSWorkspaceLaunchWithoutActivation
                                                              additionalEventParamDescriptor:nil
                                                                            launchIdentifier:NULL];
                if (launched) {
                    // 起動できたら、遅延実行で当該アプリのページを開かせる（遅延させないとうまくいかない）
                    NSAlert *alert = [[[NSAlert alloc] init] autorelease];
                    [alert setAlertStyle:NSInformationalAlertStyle];
                    [alert setMessageText:[self localizedString:@"App Store Waiting Msg"]];
                    [alert setInformativeText:[self localizedString:@"App Store Waiting Info"]];
                    [alert addButtonWithTitle:[self localizedString:@"App Store Continue"]];
                    [alert addButtonWithTitle:[self localizedString:@"App Store Cancel"]];
                    if ([alert runModal] == NSAlertFirstButtonReturn) {
                        [self openURLsWithAppStore:[NSArray arrayWithObject:newURL2]];
                    }
                    return YES;
                } else {
                    // App Store.app が存在しない環境か、他の何らかの理由で起動に失敗。URL を通常通り Web ブラウザで開かせる。
                    return [[NSWorkspace sharedWorkspace] openURL:url inBackground:[CMRPref openInBg]];
                }
            }
        } else {
            [tmp replaceCharactersInRange:NSMakeRange(0,4) withString:@"itms"];
            NSURL *newURL = [NSURL URLWithString:tmp];
            [tmp release];
            [[NSWorkspace sharedWorkspace] openURLs:[NSArray arrayWithObject:newURL]
							withAppBundleIdentifier:@"com.apple.iTunes"
											options:NSWorkspaceLaunchDefault
					 additionalEventParamDescriptor:nil launchIdentifiers:NULL];
            return YES;
        }
    }
	
	if (shouldPreviewWithNoModifierKey) {
		if (!isOptionKeyPressed && !isFileURL) {
			if ([self previewOrDownloadURL:url]) return YES;
		}
	} else {
		if (isOptionKeyPressed && !isFileURL) {
			if ([self previewOrDownloadURL:url]) return YES;
		}
	}
	return [[NSWorkspace sharedWorkspace] openURL:url inBackground:[CMRPref openInBg]];
}

#pragma mark NSTextView Delegate
- (void)textView:(NSTextView *)aTextView clickedOnCell:(id <NSTextAttachmentCell>)cell inRect:(NSRect)cellFrame atIndex:(NSUInteger)charIndex
{
	if ([[self threadLayout] respondsToSelector:_cmd]) {
		[[self threadLayout] textView:aTextView clickedOnCell:cell inRect:cellFrame atIndex:charIndex];
	}
}

- (BOOL)textView:(NSTextView *)textView clickedOnLink:(id)aLink atIndex:(NSUInteger)charIndex
{
	NSString		*boardName_;
	NSURL			*boardURL_;
	NSString		*filepath_;
    NSString *host_;
	NSString		*beParam_;
	NSIndexSet		*indexes;
	
	// 同じスレッドのレスへのアンカー
    if ([self isMessageLink:aLink messageIndexes:&indexes]) {
		NSInteger action = [CMRPref threadViewerLinkType];
		if ([indexes firstIndex] != NSNotFound) {
			switch (action) {
				case ThreadViewerMoveToIndexLinkType:
					[self scrollMessageAtIndex:[indexes firstIndex]];
					break;
				case ThreadViewerOpenBrowserLinkType:
					[self openMessagesWithIndexes:indexes];
					break;
				case ThreadViewerResPopUpLinkType:
					break;
				default:
					break;
            }
        }
        
        return YES;
	}
	
	// be Profile
	if ([CMRThreadLinkProcessor isBeProfileLinkUsingLocalScheme:aLink linkParam:&beParam_]) {
		NSString	*template_ = SGTemplateResource(kBeProfileLinkTemplateKey);
		NSString	*thURL_ = [self.doc.threadURL absoluteString];
		// #warning 64BIT: Check formatting arguments
		// 2010-03-28 tsawada2 検証済
		NSString	*tmpURL_ = [NSString stringWithFormat:template_, beParam_, thURL_];
		
		NSURL	*accessURL_ = [NSURL URLWithString:tmpURL_];
		
		return [[NSWorkspace sharedWorkspace] openURL:accessURL_ inBackground:[CMRPref openInBg]];
	}
	
	// 2ch thread
	if ([CMRThreadLinkProcessor parseThreadLink:aLink boardName:&boardName_ boardURL:&boardURL_ filepath:&filepath_ parsedHost:&host_]) {
		CMRDocumentFileManager	*dm;
		NSDictionary			*contentInfo_;
		NSString				*datIdentifier_;
		
		dm = [CMRDocumentFileManager defaultManager];
		datIdentifier_ = [dm datIdentifierWithLogPath:filepath_];
		contentInfo_ = [NSDictionary dictionaryWithObjectsAndKeys:
						[boardURL_ absoluteString], BoardPlistURLKey,
						boardName_, ThreadPlistBoardNameKey,
						datIdentifier_, ThreadPlistIdentifierKey,
						host_, @"candidateHost",
						nil];
		
		[dm ensureDirectoryExistsWithBoardName:boardName_];
//		return [[CMRDocumentController sharedDocumentController] showDocumentWithContentOfFile:[NSURL fileURLWithPath:filepath_] boardInfo:contentInfo_];
		NSError *error = nil;
		KMDocument *document = [[NSDocumentController sharedDocumentController] openDocumentWithContentsOfURL:[NSURL fileURLWithPath:filepath_]
																							 display:NO
																							   error:&error];
		if(!document) {
			NSLog(@"2ch Link open Error.\n%@", error);
			return NO;
		}
#warning THIS IS TEST IMPLEMENTATION
		NSLog(@"########   THIS IS TEST IMPLEMENTATION.   #######");
		[document addWindowController:self.view.window.windowController];
		document.threadAttr = [[[CMRThreadAttributes alloc] initWithDictionary:contentInfo_] autorelease];
		[document showWindows];
		
		return YES;
	}
	
	// 2ch (or other) BBS
	if ([CMRThreadLinkProcessor parseBoardLink:aLink boardName:&boardName_ boardURL:&boardURL_]) {
		[[NSApp delegate] showThreadsListForBoard:boardName_ selectThread:nil addToListIfNeeded:YES];
		return YES;
	}
	
	// 外部リンクと判断
	return [self handleExternalLink:aLink forView:textView];
}

#pragma mark CMRThreadView delegate
- (CMRThreadSignature *)threadSignatureForView:(CMRThreadView *)aView
{
	return [self.doc.threadAttr threadSignature];
}

- (CMRThreadLayout *)threadLayoutForView:(CMRThreadView *)aView
{
	return [self threadLayout];
}

- (void)threadView:(CMRThreadView *)aView replyTo:(NSIndexSet *)messageIndexes
{
    CMRReplyMessenger *document = [self plainReply:aView];
    if (!document) {
        return;
    }
    // 選択テキストがある場合は、すでに -reply: 内で（アンカー付きで）引用されているはずなので
    // アンカーを付与しない
    BOOL shouldAppendAnchor = YES;
    NSRange selectedRange = [aView selectedRange];
    if (selectedRange.location != NSNotFound) {
        NSUInteger index = [[self threadLayout] messageIndexForRange:selectedRange];
        if (index != NSNotFound) {
            if ([messageIndexes containsIndex:index]) {
                [self quoteWithMessenger:document];
                shouldAppendAnchor = NO;
            }
        }
    }
    if (shouldAppendAnchor) {
        [document append:@"" quote:NO replyTo:[messageIndexes firstIndex]];
    }
}

// Available in Starlight Breaker.
- (void)threadView:(CMRThreadView *)aView reverseAnchorPopUp:(NSUInteger)targetIndex locationHint:(NSPoint)location_
{
	NSAttributedString *contents_;
	contents_ = [[self threadLayout] contentsForTargetIndex:targetIndex
											  composingMask:CMRInvisibleAbonedMask
													compose:NO
											 attributesMask:(CMRLocalAbonedMask|CMRSpamMask)];
	if (!contents_ || [contents_ length] == 0) {
		// #warning 64BIT: Check formatting arguments
		// 2010-03-28 tsawada2 修正済
		NSString *notFoundString = [NSString stringWithFormat:[self localizedString: @"GyakuSansyou Not Found"], (unsigned long)(targetIndex+1)];
		contents_ = [[[NSAttributedString alloc] initWithString:notFoundString] autorelease];
	}
	
	[CMRPopUpMgr showPopUpWindowWithContext:contents_
								  forObject:self.doc.datIdentifier
									  owner:self
							   locationHint:location_];
}

// AA Filter
- (IBAction)runAsciiArtDetector:(id)sender
{
	CMRThreadLayout			*layout;
	CMRThreadSignature		*threadID;
	
	layout = [self threadLayout];
	threadID = [self.doc.threadAttr threadSignature];
	if (!layout || !threadID) {
		return;
	}
	[[BSAsciiArtDetector sharedInstance] runDetectorWithMessages:[layout messageBuffer] with:threadID];
}

// Spam Filter
- (IBAction)runSpamFilter:(id)sender
{
	CMRThreadLayout			*layout;
	CMRThreadSignature		*threadID;
	
	layout = [self threadLayout];
	threadID = [self.doc.threadAttr threadSignature];
	if (!layout || !threadID) {
		return;
	}
	
    BSSpamJudge *judge = [[[BSSpamJudge alloc] initWithThreadSignature:threadID] autorelease];
    [judge judgeMessages:[layout messageBuffer]];
}

/* CMRThreadViewerRunSpamFilterNotification */
- (void)threadViewerRunSpamFilter:(NSNotification *)theNotification
{
#warning THIS MUST BE IMPLEMENT
//	UTILAssertNotificationName(theNotification, CMRThreadViewerRunSpamFilterNotification);
//	
//    id object = [theNotification object];
//    if ((object == self) || (m_addNGExWindowController && (object == m_addNGExWindowController))) {
//        if ([CMRPref spamFilterEnabled]) {
//            [self runSpamFilter:nil];
//        }        
//    }
}

- (void)postRunSpamFilterNotification
{
#warning THIS MUST BE IMPLEMENT
//	NSNotification *notification;
//    NSNotificationQueue *queue = [NSNotificationQueue defaultQueue];
//	
//	notification = [NSNotification notificationWithName:CMRThreadViewerRunSpamFilterNotification object:self];
//	[queue enqueueNotification:notification
//                  postingStyle:NSPostWhenIdle
//                  coalesceMask:NSNotificationCoalescingOnSender
//                      forModes:nil];
}

- (void)threadView:(CMRThreadView *)aView spam:(CMRThreadMessage *)aMessage messageRegister:(BOOL)registerFlag
{
#warning THIS MUST BE IMPLEMENT
//    BSMessageSampleRegistrant *registrant = [[self document] registrant];
//	CMRThreadSignature		*threadID = [self threadSignatureForView:aView];
//	
//	if (!registrant || !aMessage || !threadID) {
//        return;
//    }
//	if (registerFlag) {
//        [registrant setDelegate:self];
//        [registrant registerMessage:aMessage];
//		[self postRunSpamFilterNotification];	// 新しいサンプルを追加した場合のみ自動的に起動
//	} else {
//        [registrant unregisterMessage:aMessage];
//	}
}

- (NSUInteger)registrant:(BSMessageSampleRegistrant *)aRegistrant numberOfMessagesWithIDString:(NSString *)idString
{
    NSEnumerator *iter = [[self threadLayout] messageEnumerator];
    CMRThreadMessage *message;
    NSUInteger count = 0;
    while (message = [iter nextObject]) {
        NSString *idOfMessage = [message IDString];
        if (idOfMessage && [idOfMessage isEqualToString:idString]) {
            count++;
        }
    }
    return count;
}

- (BOOL)threadView:(CMRThreadView *)aView
	  mouseClicked:(NSEvent *)theEvent
		   atIndex:(NSUInteger)charIndex
	  messageIndex:(NSUInteger)aMessageIndex
{
	if ([theEvent modifierFlags] & NSAlternateKeyMask) {
		NSPoint	winLocation = [theEvent locationInWindow];
		NSPoint	screenLocation = [[aView window] convertBaseToScreen: winLocation]; 
		[self threadView:aView reverseAnchorPopUp:aMessageIndex locationHint:screenLocation];
	} else {
		NSMenu	*menu_ = [aView messageMenuWithMessageIndex:aMessageIndex];
		[NSMenu popUpContextMenu:menu_ withEvent:theEvent forView:aView];
	}
	return YES;
}

#pragma mark Gesuture Support
- (BOOL)threadView:(CMRThreadView *)aView swipeWithEvent:(NSEvent *)theEvent
{
	CGFloat dX = [theEvent deltaX];
    CGFloat dY = [theEvent deltaY];
	
	if (dX > 0) { // 右から左へスワイプ
        [self historyMenuPerformBack:aView];
	} else if (dX < 0) { // 左から右へスワイプ
        [self historyMenuPerformForward:aView];
	}
	
    if (dY != 0) { // 上下いずれかにスワイプ
        [self reply:aView];
    }
	
    return YES;
}

- (void)threadView:(CMRThreadView *)aView magnifyEnough:(CGFloat)additionalScaleFactor
{
    if (additionalScaleFactor > 0.5) {
        [self biggerText:self];
    } else if (additionalScaleFactor < -0.5) {
        [self smallerText:self];
    }
}

- (void)threadView:(CMRThreadView *)aView rotateEnough:(CGFloat)rotatedDegree
{
    BSTitleRulerView *ruler = (BSTitleRulerView *)[self.documentScrollView horizontalRulerView];
    
    [ruler setCurrentMode:[[self class] rulerModeForInformDatOchi]];
    [ruler setInfoStr:[self localizedString:@"titleRuler info rotate gesture title"]];
    [self.documentScrollView setRulersVisible:YES];
    [NSTimer scheduledTimerWithTimeInterval:1.0 target:self selector:@selector(cleanUpTitleRuler:) userInfo:nil repeats:NO];
}

- (void)threadView:(CMRThreadView *)aView didFinishRotating:(CGFloat)rotatedDegree
{
    [self.doc reloadThread:self];
}

- (BOOL)acceptsFirstResponderForView:(CMRThreadView *)aView
{
#warning MUST TEST THIS METHOD.
    return YES;//[self shouldShowContents];
}

#pragma mark SGHTMLView delegate
- (NSArray *)HTMLViewFilteringLinkSchemes:(SGHTMLView *)aView
{
	// "cmonar:", "mailto:", "cmbe:" をフィルタ
	static NSArray *cachedLinkSchemes = nil;
	if (!cachedLinkSchemes) {
		cachedLinkSchemes = [[NSArray alloc] initWithObjects:CMRAttributeInnerLinkScheme, CMRAttributesBeProfileLinkScheme, @"mailto", @"sssp", nil];
	}
	return cachedLinkSchemes;
}

- (void)HTMLView:(SGHTMLView *)aView mouseEnteredInLink:(id)aLink inTrackingRect:(NSRect)aRect withEvent:(NSEvent *)anEvent
{
	NSPoint			location_;
	
	location_ = NSEqualRects(aRect, NSZeroRect) ? [anEvent locationInWindow] : aRect.origin;
	location_ = [aView convertPoint:location_ toView:nil];
	location_ = [[aView window] convertBaseToScreen:location_];
	location_.y -= 1.0f;
	
	[self tryShowPopUpWindowWithLink:aLink locationHint:location_];
}

- (void)HTMLView:(SGHTMLView *)aView mouseExitedFromLink:(id)aLink inTrackingRect:(NSRect)aRect withEvent:(NSEvent *)anEvent
{
	[CMRPopUpMgr performClosePopUpWindowForObject:aLink];
}

// continuous mouseDown
- (BOOL)HTMLView:(SGHTMLView *)aView shouldHandleContinuousMouseDown:(NSEvent *)theEvent
{
	NSRange		selectedRange_;
	id			v;
	unichar		c;
	NSPoint		mouseLocation_;
	
	// ID ポップアップ
	mouseLocation_ = [aView convertPoint:[theEvent locationInWindow] fromView:nil];
	
	v = [aView attribute:BSMessageIDAttributeName atPoint:mouseLocation_ effectiveRange:NULL];
	
	if (v) return YES;
	
	selectedRange_ = [aView selectedRange];
	if (0 == selectedRange_.length) return NO;
	
	// レス番号ではポップアップしない
	v = [[aView textStorage] attribute:CMRMessageIndexAttributeName 
							   atIndex:selectedRange_.location
						effectiveRange:NULL];
	if (v) return NO;
	
	c = [[aView string] characterAtIndex:selectedRange_.location];
	return [[NSCharacterSet numberCharacterSet_JP] characterIsMember:c];
}

- (BOOL)HTMLView:(SGHTMLView *)aView continuousMouseDown:(NSEvent *)theEvent
{
	NSPoint	mouseLoc_;
	BOOL	isInside_;
	id		value;
	
	UTILRequireCondition((aView && theEvent), default_implementation);
	
	mouseLoc_ = (NSPeriodic == [theEvent type])
	? [[aView window] convertScreenToBase:[theEvent locationInWindow]]
	: [theEvent locationInWindow];
	mouseLoc_ = [aView convertPoint:mouseLoc_ fromView:nil];
	//	isInside_ = [aView mouse:mouseLoc_ inRect:[aView visibleRect]];
	
	value = [aView attribute:BSMessageIDAttributeName atPoint:mouseLoc_ effectiveRange:NULL];
	
	if (value) {
		// ID PopUp
		[self extractMessagesWithIDString:(NSString *)value popUpLocation:[theEvent locationInWindow]];
	} else {
		NSRange				selectedRange_;
		NSLayoutManager		*layoutManager_;
		NSRange				selectedGlyphRange_;
		NSRect				selection_;
		
		selectedRange_ = [aView selectedRange];
		UTILRequireCondition(selectedRange_.length, default_implementation);
		
		layoutManager_ = [aView layoutManager];
		UTILRequireCondition(layoutManager_, default_implementation);
		
		selectedGlyphRange_ = 
		[layoutManager_ glyphRangeForCharacterRange:selectedRange_
							   actualCharacterRange:NULL];
		UTILRequireCondition(selectedGlyphRange_.length, default_implementation);
		selection_ = 
		[layoutManager_ boundingRectForGlyphRange:selectedGlyphRange_
								  inTextContainer:[aView textContainer]];
		isInside_ = [aView mouse:mouseLoc_ inRect:selection_];
		//		UTILRequireCondition(isInside_, default_implementation);
        // 暫定
        if (!isInside_) {
            return ([CMRPref mouseDownTrackingTime] > 0);
        }
		
		mouseLoc_.y = [aView isFlipped] 
		? NSMinY(selection_)
		: NSMaxY(selection_);
		mouseLoc_ = [aView convertPoint:mouseLoc_ toView:nil];
		mouseLoc_ = [[aView window] convertBaseToScreen:mouseLoc_];
		
		// テキストのドラッグを許すように、ここでは常にNOを返す。
		[self tryShowPopUpWindowSubstringWithRange:selectedRange_
									 inTextStorage:[aView textStorage]
									  locationHint:mouseLoc_];
	}
	return NO;
	
default_implementation:
	return YES;
}
@end
