//
//  BSInlinePreviewer.h
//  BSInlinePreviewer
//
//  Created by Hori,Masaki on 08/08/14.
//  Copyright 2008 masakih. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "BSImagePreviewerInterface.h"

#import "BSPreviewPluginInterface.h"

@class BSIPreferenceWindowController;
@class BSIPReferenceViewController;

@interface BSInlinePreviewer : NSObject <BSImagePreviewerProtocol, BSLinkPreviewing>
{
	AppDefaults *preference;
	
	id threadView;
	NSTextStorage *textStrage;
	unsigned actionIndex;
	
	id previewAttributes;
	
	IBOutlet NSWindow *progressPanel;
	IBOutlet NSProgressIndicator *progress;
	
	NSUInteger totalDownloads;
	NSUInteger remainder;
	
	NSCache *cache;
	
	BSIPreferenceWindowController *pref;
	NSSize _previewSize;
	
	BSIPReferenceViewController *_prefViewCon;
}

@property (nonatomic) NSUInteger totalDownloads;
@property (nonatomic) NSUInteger remainder;
@property (assign, nonatomic) NSSize previewSize;

- (void)setTargetThreadView:(id)view;
- (id)targetThreadView;
- (void)setTargetTextStorage:(NSTextStorage *)ts;
- (NSTextStorage *)targetTextStorage;
- (void)setActionIndex:(unsigned)p;
- (unsigned)actionIndex;
- (BOOL)prepareTarget;

- (id)previewAttributes;
	
@end

extern NSString *const BSInlinePreviewerPreviewed;
