<?php
header('Content-Type: text/css'); 

//read config
if( file_exists( dirname( __FILE__ ) . '/theme_config.php' ) ) {
	include_once( dirname( __FILE__ ) . '/theme_config.php' ) ;
}else{
	include_once( dirname( __FILE__ ) . '/theme_config.dist.php' ) ;
}

?>/*============================================================================*/

/******************************************************************************/
/* colors.css */
/******************************************************************************/

.div_shadow {
  -moz-box-shadow: 0 1px 2px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>; /* ボックスシャドウ */
  -webkit-box-shadow: 0 1px 2px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>;
  box-shadow: 0 1px 2px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>;
}

/* Link color */
a , li a ,dt a ,dd a ,p a , .outer a , .xpress-post h2 a{
	color:<?php echo _THEME_CONFIG_LINK_COLOR ?>;
}
#ModuleContents .d3f_comment_head a ,
#ModuleContents .d3f_comment_head a:visited ,
a:visited ,li a:visited , dt a:visited , dd a:visited , p a:visited , .outer a:visited , .xpress-post h2 a:visited , 
#xpress_content .xpress-post .xpress-more-link a {
	color:<?php echo _THEME_CONFIG_VISITED_COLOR ?>;
}
#ModuleContents .d3f_comment_head a:hover ,
a:hover ,li a:hover , dt a:hover , dd a:hover , p a:hover , .outer a:hover , .xpress-post h2 a:hover , 
#xpress_content .xpress-post .xpress-more-link a:hover {
	color:<?php echo _THEME_CONFIG_HOVER_COLOR ?>;
}

em {
  color: <?php echo _THEME_CONFIG_TEXTEM_COLOR ?>;
}

/* Layout */
body {
  color: <?php echo _THEME_CONFIG_TEXT_COLOR ?>;
	background:<?php echo _THEME_CONFIG_BASE_COLOR ?>;
}
#outerwrapper {
	background:<?php echo _THEME_CONFIG_BASE_COLOR ?>;
}

/* Header and Footer */
#Header {
	background: <?php echo _THEME_CONFIG_HEADER_COLOR ?>;
}
#Footer {
	background: <?php echo _THEME_CONFIG_HEADER_COLOR ?>;
	-moz-box-shadow: 0px -2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* Firefox用 */
	-webkit-box-shadow: 0px -2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* Safari,Chrome用 */
	box-shadow: 0px -2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* CSS3 */
}
#Header a {
	color: <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}

#Sitename {
	color: <?php echo _THEME_CONFIG_BASE_COLOR ?>;
	background:transparent;
}
#Sitename a:link ,
#Sitename a:visited {
	color: <?php echo _THEME_CONFIG_BASE_COLOR ?>;
	text-shadow:
		-1px -1px 1px rgba(0, 0, 0, 0.4),
		1px 1px 1px rgba(255, 255, 255, 0.5);
}
#Sitename .Slogan {
	color: <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}

/* Header Menu */
#menu_m {
	background:<?php echo _THEME_CONFIG_HEADERMENU_COLOR ?>;
}

#menu_m .selected {
	background:<?php echo _THEME_CONFIG_HEADER_COLOR ?>;
	border-radius: 0 0 15px 15px ;
	-webkit-border-radius: 0 0 15px 15px;
	-moz-border-radius: 0 0 15px 15px;
	-moz-box-shadow: 1px 2px 5px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>;
	-webkit-box-shadow: 1px 2px 5px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>;
	box-shadow: 1px 2px 5px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>;
}

#menu_m ul.mm li a , #menu_m ul.mm li a:visited{
	color:<?php echo _THEME_CONFIG_HEADERMENU_LINK_COLOR ?>;
}
#menu_m ul.mm li a:hover ,
#menu_m ul.mm li a.mm_home:hover ,
#menu_m ul.mm li a.mm_a:hover ,
#menu_m ul.mm li a.mm_b:hover ,
#menu_m ul.mm li a.mm_c:hover ,
#menu_m ul.mm li a.mm_d:hover ,
#menu_m ul.mm li a.mm_e:hover ,
#menu_m ul.mm li a.mm_f:hover ,
#menu_m ul.mm li a.mm_g:hover ,
#menu_m ul.mm li a.mm_h:hover ,
#menu_m ul.mm li a.mm_i:hover ,
#menu_m ul.mm li a.mm_j:hover {
	color:<?php echo _THEME_CONFIG_HEADERMENU_HOVER_COLOR ?>;
  background:<?php echo _THEME_CONFIG_HEADER_COLOR ?>;  
}

/* SUB MENU */
#menu_sub {
	background:<?php echo _THEME_CONFIG_HEADERMENUSUB_COLOR ?>;
	-moz-box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* Firefox用 */
	-webkit-box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* Safari,Chrome用 */
	box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* CSS3 */
}
#menu_sub a:link , #menu_sub a:visited {
	color:<?php echo _THEME_CONFIG_HEADERMENUSUB_LINK_COLOR ?>;
}
#menu_sub a:hover {
	color:<?php echo _THEME_CONFIG_HEADERMENUSUB_HOVER_COLOR ?>;
}

#outerwrapper {
	<?php echo _THEME_CONFIG_BG_OUTERWRAPPER_COLOR ?>;
}

#Container {
	background:transparent;
}


/* GRID CONTENT */

#grid-content div.small , 
#grid-content div.large , 
#grid-content div.top_block ,
#grid-content #ModuleContents , 
#leftcolumn div {
	background:<?php echo _THEME_CONFIG_BOX_COLOR ?>;
	color: <?php echo _THEME_CONFIG_HEADER_COLOR ?>;
	border:1px solid <?php echo _THEME_CONFIG_BORDERLIGHT_COLOR ?>;
	border-radius: 5px;        /* CSS3草案 */  
	-webkit-border-radius: 5px;    /* Safari,Google Chrome用 */  
	-moz-border-radius: 5px;   /* Firefox用 */
}
#grid-content div div , 
#grid-content div.small div, 
#leftcolumn div div {
	background:transparent;
}

/* タイトルの設定 */
.BlockTitle_a, .BlockTitle_b, .BlockTitle_c, .BlockTitle_d, .BlockTitle_e {
  border-top:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?> ;
  border-bottom:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?> ;
  background : <?php echo _THEME_CONFIG_BORDERLIGHT_COLOR ?>;
	color:<?php echo _THEME_CONFIG_TEXTLIGHT_COLOR ?>;
	text-shadow: 1px 1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>;

	background : -webkit-gradient(linear, left top, left bottom,
		from(#F0F0F0),
		color-stop(0.45, #FDFDFD),
		color-stop(0.5, #CCCCCC),
		to(#F3F3F3));
	background : -moz-linear-gradient(top,
		#F0F0F0,
		#FDFDFD 45%,
		#CCCCCC 50%,
		#F3F3F3);
}


/* Breadcrumb */
#theme_breadcrumbs {
	text-align:left;
	font-weight:normal;
	margin:10px 0 5px 5px ;
	padding:2px;
	background: <?php echo _THEME_CONFIG_BREADCRUMBS_BASECOLOR ?>;
	background: hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,95%,.3);
	border:1px solid hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,95%,1);
	-moz-border-radius: 5px;
	-webkit-border-radius: 5px;
	border-radius: 5px;
}

#theme_breadcrumbs ul {
  list-style: none;
  overflow: hidden;
	font-weight:normal;
	font: 12px Helvetica, Arial, Sans-Serif;
	background: <?php echo _THEME_CONFIG_BREADCRUMBS_BASECOLOR ?>;
	background: hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,95%,.3);
}
#theme_breadcrumbs ul li {
	float:left;
}
#theme_breadcrumbs ul li a {
    color: <?php echo _THEME_CONFIG_BREADCRUMBS_A_COLOR ?>;
    text-decoration: none;
    padding: 5px 0 5px 30px;
    background: <?php echo _THEME_CONFIG_BREADCRUMBS_BASECOLOR ?>;
    background: hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,35%,1);
    position: relative;
    display: block;
    float: left;
}
#theme_breadcrumbs ul li a:after {
    content: " ";
    display: block;
    width: 0;
    height: 0;
    border-top: 25px solid transparent;
    border-bottom: 25px solid transparent;
    border-left: 15px solid hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,35%,1);
    position: absolute;
    top: 50%;
    margin-top: -25px;
    left: 100%;
    z-index: 2;
}
#theme_breadcrumbs ul li a:before {
    content: " ";
    display: block;
    width: 0;
    height: 0;
    border-top: 25px solid transparent;
    border-bottom: 25px solid transparent;
    border-left: 15px solid <?php echo _THEME_CONFIG_BREADCRUMBS_BORDER_COLOR ?>;
    position: absolute;
    top: 50%;
    margin-top: -25px;
    margin-left: 1px;
    left: 100%;
    z-index: 1;
}
#theme_breadcrumbs ul li:first-child a {
    padding-left: 10px;
}
#theme_breadcrumbs ul li:nth-child(2) a       { background:hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,45%,1); }
#theme_breadcrumbs ul li:nth-child(2) a:after { border-left-color: hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,45%,1); }
#theme_breadcrumbs ul li:nth-child(3) a       { background:hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,55%,1); }
#theme_breadcrumbs ul li:nth-child(3) a:after { border-left-color: hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,55%,1); }
#theme_breadcrumbs ul li:nth-child(4) a       { background:hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,65%,1); }
#theme_breadcrumbs ul li:nth-child(4) a:after { border-left-color: hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,65%,1); }
#theme_breadcrumbs ul li:nth-child(5) a       { background:hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,75%,1); }
#theme_breadcrumbs ul li:nth-child(5) a:after { border-left-color: hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,75%,1); }
#theme_breadcrumbs ul li:last-child a {
  background: transparent !important;
  color: <?php echo _THEME_CONFIG_BREADCRUMBS_TEXT_COLOR ?>;
	font-weight:bold;
	pointer-events: none;
  cursor: default;
}
#theme_breadcrumbs ul li:last-child a:after { border: 0; }
#theme_breadcrumbs ul li:last-child a:before { border: 0; }
#theme_breadcrumbs ul li a:hover { background: hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,25%,1); }
#theme_breadcrumbs ul li a:hover:after { border-left-color: hsla(<?php echo _THEME_CONFIG_BREADCRUMBS_COLOR ?>,85%,25%,1) !important; }

/* ModuleCongtents ul */
#ModuleCongtents ,
#ModuleCongtents a:link , a:visited ,
#ModuleCongtents ul ,
#ModuleCongtents ul li a:link , #ModuleCongtents ul li a:visited{
	color:<?php echo _THEME_CONFIG_HEADER_COLOR ?>;
}

/* footer menu */

#user_menu_block ul li a ,#user_menu_block ul li a:visited {
	color:<?php echo _THEME_CONFIG_BASE_COLOR ?>;
}
#user_menu_block a:hover{
	color:green;
	background:orange;
}


/* XOOPS Main Menu */
#mainmenu a ,#mainmenu a:visited {
  border-bottom: #DDD solid 1px;
}
#mainmenu a:hover {
  background-color: orange;
  border-bottom: #a0522d solid 1px;
}
#usermenu a {
  border-bottom: #DDD solid 1px;
}
#usermenu a:hover {
  background-color: #EEE
}
#usermenu a.highlight {
  background-color: #FCC;
}

/* XOOPS table */
.d3downloads_even ,
.head ,
.odd ,
tr.odd td {
  background-color: <?php echo _THEME_CONFIG_ODD_COLOR ?>;
}
.d3downloads_odd ,
.even ,
tr.even td {
	background:<?php echo _THEME_CONFIG_EVEN_COLOR ?>;
}
.outer {
	background:<?php echo _THEME_CONFIG_OUTER_COLOR ?>;
}
.inner {
    background: <?php echo _THEME_CONFIG_INNER_COLOR ?>;
}


/* XOOPS item */
.itemHead {
  background-color: <?php echo _THEME_CONFIG_TEXTLIGHT_COLOR ?>;
  color: <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}
.itemInfo ,
.itemFoot {
  background-color: <?php echo _THEME_CONFIG_BGSSLIGHT_COLOR ?>;
}
.itemTitle a {
  color: <?php echo _THEME_CONFIG_HEADER_COLOR ?>;
  background-color: transparent;
}


/* XOOPS Error Msg */
div.errorMsg {
  background-color: #FFCCCC;
}
div.confirmMsg {
  background-color: #DDFFDF;
  color: #136C99;
}
div.errorMsg ,
div.confirmMsg {
  border-top: 1px solid #DDDDFF;
  border-left: 1px solid #DDDDFF;
  border-right: 1px solid #AAAAAA;
  border-bottom: 1px solid #AAAAAA;
}
div.resultMsg {
  background-color : <?php echo _THEME_CONFIG_BORDERLIGHT_COLOR ?>;
  color: <?php echo _THEME_CONFIG_TEXT_COLOR ?>;
  border-top: 1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
  border-left: 1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
  border-right: 1px solid <?php echo _THEME_CONFIG_TEXTLIGHT_COLOR ?>;
  border-bottom: 1px solid <?php echo _THEME_CONFIG_TEXTLIGHT_COLOR ?>;
}


/* XOOPS com */
.comUserStat {
  color: #2F5376;
  border: 1px solid <?php echo _THEME_CONFIG_BORDERLIGHT_COLOR ?>;
  background-color: <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}
.comUserStatus {
  color: #2F5376;
}

#redirect_message {
	border:<?php echo _THEME_CONFIG_TEXTLIGHT_COLOR ?> 1px solid;
	border-right:pink 30px solid;
	border-bottom:3px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
	background:#f8f4e6;
}

#ModuleContents .xpress-post-entry img ,
#ModuleContents .weblinks_link_image ,
#ModuleContents .weblinks_list_image ,
.PhotoFrame {
   -webkit-box-shadow: 1px 8px 48px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>;
   -moz-box-shadow: 1px 8px 48px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>;
   box-shadow: 1px 4px 8px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>;
}
#ModuleContents .weblinks_link_single_frame_hits {
	border-top :<?php echo _THEME_CONFIG_BORDERLIGHT_COLOR ?> 1px solid;
	border-bottom :<?php echo _THEME_CONFIG_BORDER_COLOR ?> 1px solid;
  background: <?php echo _THEME_CONFIG_ODD_COLOR ?>;
}

/* for xugj_date */
.new1 {
	color:<?php echo _THEME_CONFIG_TEXTEM_COLOR ?>;
}
.new2 {
	color:<?php echo _THEME_CONFIG_TEXTB_COLOR ?>;
}

/* headerSearch */
#headerSearch-searchform {
	background: transparent;
}
#headerSearch-keywords	{
	background-image:-moz-linear-gradient(top, #D7D7D7, #E7E7E7);
	background-image: -webkit-gradient(linear, 0% 0%, 0% 100%, from(#D7D7D7), to(#E7E7E7), color-stop(1,#E7E7E7));
	border:1px solid #AFAFAF;
	-moz-border-radius: 10px;
	-webkit-border-radius: 10px;
	border-radius: 10px;
	box-shadow: inset 1px 1px 1px rgba(0,0,0,0.25);
	-moz-box-shadow: inset 1px 1px 1px rgba(0,0,0,0.25);
	-webkit-box-shadow: inset 1px 1px 1px rgba(0,0,0,0.25);
}


/* for d3forum  and more */
#ModuleContents .pico_breadcrumbs ,
#ModuleContents .d3f_comment_head ,
body.weblinks #ModuleContents .weblinks_subtitle ,
#ModuleContents .d3downloads_head ,
body.d3forum table.outer thead tr ,
#main_listcategories .d3f_top_message ,
#ModuleContents #main_listtopics ,
#ModuleContents .d3f_head,
#ModuleContents .d3f_form_table .d3f_head,
#ModuleContents #main_listtopics .d3f_head ,
#ModuleContents #main_listposts ,
#ModuleContents #main_post_form ,
#ModuleContents .d3f_main_viewpost_head ,
#ModuleContents #main_listforums,
#ModuleContents #main_listtopics_over_categories {
  background: <?php echo _THEME_CONFIG_MHEAD_IMG ?>;
}
#ModuleContents .d3f_comment_head {
	text-shadow: 1px 1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}
#ModuleContents .d3f_info_sub ,
#ModuleContents .d3f_info {
  background-color: <?php echo _THEME_CONFIG_ODD_COLOR ?>;
}
#ModuleContents .d3f_top_message h2 ,
#ModuleContents .d3f_title {
  background: <?php echo _THEME_CONFIG_d3f_ICON_IMG ?>;
	color:<?php echo _THEME_CONFIG_TEXT_COLOR ?>;
	text-shadow: 1px 1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}
#ModuleContents .d3f_comment_head span.d3f_comment_head_1 {
  background: <?php echo _THEME_CONFIG_d3f_ICONMINI_IMG ?>;
}
#ModuleContents .d3f_comment_add ,
#ModuleContents .d3f_comment_head span.d3f_comment_head_2 {
  background: <?php echo _THEME_CONFIG_d3f_ICONMINI2_IMG ?>;
}

.d3f_ctrl {
	border:1px solid <?php echo _THEME_CONFIG_BORDERLIGHT_COLOR ?>;
	border-radius: 5px;        /* CSS3草案 */  
	-webkit-border-radius: 5px;    /* Safari,Google Chrome用 */  
	-moz-border-radius: 5px;   /* Firefox用 */
}

#ModuleContents #d3f_cat_wrap {
	border:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
}

.d3f_block_list_topics table{
	color:<?php echo _THEME_CONFIG_TEXTLIGHT_COLOR ?>;
}
.d3f_block_list_topics table th.th01 ,
.d3f_block_list_topics table th.th02 ,
.d3f_block_list_topics table th.th03 ,
.d3f_block_list_topics table th.th04 ,
.d3f_block_list_topics table th.th05{
  background: <?php echo _THEME_CONFIG_MHEAD_IMG ?>;
	color:<?php echo _THEME_CONFIG_HEADERMENUSUB_LINK_COLOR ?>;
	text-shadow: 1px 1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}
.d3f_block_list_topics table tr.even td {
/*  background: <?php echo _THEME_CONFIG_BORDERSLIGHT_COLOR ?>; */
}
.d3f_block_list_topics ,
.d3f_block_list_topics table tr.odd td {
/*	background:<?php echo _THEME_CONFIG_BASE_COLOR ?>; */
}
#ModuleContents .webphoto_description {
	background:<?php echo _THEME_CONFIG_BGNOTE_COLOR ?> repeat 0px 0px;
}
body.bulletin #ModuleContents .itemBody ,
#ModuleContents #pico_body {
	background:<?php echo _THEME_CONFIG_BGNOTE_COLOR ?> repeat 0px -10px;
}
#ModuleContents #pico_body div div {
	background:transparent;
}
#ModuleContents .xpress-post-entry ,
#ModuleContents .d3downloads_single_frame_description ,
#ModuleContents .d3f_body{
	background:<?php echo _THEME_CONFIG_BGNOTE_COLOR ?> repeat 0px -10px;
}
body.d3forum table.outer thead tr th {
	color:<?php echo _THEME_CONFIG_TEXT_COLOR ?>;
	text-shadow: 1px 1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}

#d3f_wrap_open ,#goback{
	background:#dcdcdc;
	padding:5px 10px;
	border:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
	border-radius: 10px;
	-webkit-border-radius: 10px;
	-moz-border-radius: 10px;
	background : -webkit-gradient(linear, left top, left bottom,
		from(#F0F0F0),
		color-stop(0.45, #FDFDFD),
		color-stop(0.5, #CCCCCC),
		to(#F3F3F3));
	background : -moz-linear-gradient(top,
		#F0F0F0,
		#FDFDFD 45%,
		#CCCCCC 50%,
		#F3F3F3);
}

a#d3f_wrap_open , a#d3f_wrap_open:visited ,
a#goback , a#goback:visited {
	color:<?php echo _THEME_CONFIG_TEXTLIGHT_COLOR ?>;
	text-shadow: 1px 1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}
.d3f_block_list_posts li {
	color:<?php echo _THEME_CONFIG_BORDER_COLOR ?>;
}

#Container #d3f_wrap_oc {
	background:<?php echo _THEME_CONFIG_BASE_COLOR ?>;
	border:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
	background:rgba(200, 200, 200, .9);
	background: -webkit-gradient(linear, left top, left bottom, from(<?php echo _THEME_CONFIG_BASE_COLOR ?>), to(<?php echo _THEME_CONFIG_BORDERSLIGHT_COLOR ?>)); /* for webkit browsers */
	background: -moz-linear-gradient(top,  <?php echo _THEME_CONFIG_BASE_COLOR ?>,  <?php echo _THEME_CONFIG_BORDERSLIGHT_COLOR ?>); /* for firefox 3.6+ */
	-webkit-box-shadow: 3px 3px 5px 0px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>; /* Safari, Chrome用 */
	-moz-box-shadow: 3px 3px 5px 0px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>; /* Firefox用 */
	box-shadow: 3px 3px 5px 0px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>; /* CSS3 */
}

#ModuleContents .d3f_postform td.head {
	text-shadow: 0px 1px 0px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
	color:<?php echo _THEME_CONFIG_TEXTSLIGHT_COLOR ?>;
}

#ModuleContents .d3f_head h2 ,
#ModuleContents .d3f_head h2 a,
.d3f_msgnum {
	color:<?php echo _THEME_CONFIG_TEXT_COLOR ?>;
	text-shadow: 1px 1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}

/* for d3pipes */
div.d3pipes_clipping dt {
	background-color: <?php echo _THEME_CONFIG_BORDERLIGHT_COLOR ?>;
}

ul.d3pipes_block_sync_aggregated li dl dt {
	border-left: 5px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
}
ul.d3pipes_block_sync_aggregated li dl dd {
	color:<?php echo _THEME_CONFIG_TEXTSLIGHT_COLOR ?>;
}

#ModuleContents #d3f_post_form_quick {
	border: 1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
	-moz-border-radius: 5px;
	-webkit-border-radius: 5px;
	border-radius: 5px;
	-moz-box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* Firefox用 */
	-webkit-box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* Safari,Chrome用 */
	box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* CSS3 */
}

/* for bulletin and pico */

body.pico #ModuleContents .head ,
body.bulletin #ModuleContents .head {
	background:<?php echo _THEME_CONFIG_BASE_COLOR ?>;
}

body.pico h2.head ,
body.bulletin h2.head {
	background:<?php echo _THEME_CONFIG_BASE_COLOR ?>;
	color:<?php echo _THEME_CONFIG_TEXTLIGHT_COLOR ?>;
	text-shadow: 0px 1px 0px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}

body.pico #postform .d3f_postform .head ,
body.bulletin .d3f_postform .head {
	background:<?php echo _THEME_CONFIG_BASE_COLOR ?>;
	color:<?php echo _THEME_CONFIG_TEXTB_COLOR ?>;
}

body.bulletin #ModuleContents .itemInfo ,
body.bulletin #ModuleContents .itemFoot {
	background:transparent;
}

body.bulletin #ModuleContents .item_xgj_Date div p {
	color:<?php echo _THEME_CONFIG_TEXTSLIGHT_COLOR ?>;
	text-shadow: 0px 1px 0px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}


#ModuleContents #xpress-comments-block h2 ,
#ModuleContents .weblinks_link_single_title_left ,
#ModuleContents .weblinks_link_single_title_right ,
#ModuleContents .weblinks_links_list_title_left ,
#ModuleContents .weblinks_links_list_title_right ,
#ModuleContents .evform h2 ,
table.d3downloads_outer td.d3downloads_single_frame_title ,
.d3f_table tr.head th ,
body.bulletin #ModuleContents .itemHead ,
body.pico #ModuleContents .d3f_wrap .d3f_head {
	border-top:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
	border-bottom:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;

		/* add style */
    color: <?php echo _THEME_CONFIG_TEXT_COLOR ?>;
 
    border-top: 1px solid #9c9c9c; /* Fallback style */
    border-top: 1px solid rgba(0, 0, 0, 0.3);            
    border-bottom: 1px solid #9c9c9c; /* Fallback style */
    border-bottom: 1px solid rgba(0, 0, 0, 0.3);            
 
    text-shadow: 0 1px 0 rgba(255,255,255,0.8);
 
    box-shadow: 0 0 .05em rgba(0,0,0,0.4);
    -moz-box-shadow: 0 0 .05em rgba(0,0,0,0.4);
    -webkit-box-shadow: 0 0 .05em rgba(0,0,0,0.4);

		/* Pattern settings */
    -moz-background-size: 3px 3px;
    -webkit-background-size: 3px 3px;

		/*  gradation   */
		background:<?php echo _THEME_CONFIG_GRADIENT1_COLOR ?>;
		background-image: -moz-linear-gradient(<?php echo _THEME_CONFIG_GRADIENT1_COLOR ?>, <?php echo _THEME_CONFIG_GRADIENT2_COLOR ?>);
		background-image: -webkit-linear-gradient(<?php echo _THEME_CONFIG_GRADIENT1_COLOR ?>, <?php echo _THEME_CONFIG_GRADIENT2_COLOR ?>);		/* Webkit */
}

body.bulletin #ModuleContents .item .itemTitle,
body.bulletin #ModuleContents .item .itemTitle a:link , 
body.bulletin #ModuleContents .item .itemTitle a:visited {
	color:<?php echo _THEME_CONFIG_HEADER_COLOR ?>;
}


/* for webphoto  */
#ModuleContents .webphoto_description ,
#ModuleContents div .webphoto_description {
	border:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
}

#ModuleContents .webphoto_photo_type ,
#ModuleContents .webphoto_index_photo_header , 
#ModuleContents .webphoto_index_photo_body , 
#ModuleContents .webphoto_index_photo_footer{
	border-top:1px solid <?php echo _THEME_CONFIG_BORDERSLIGHT_COLOR ?>;
	background:transparent;
}

.webphoto_photo_div .webphoto_table_sub a {
  background-color: rgba(255, 255, 200, 0.7); /* 透明度70%で指定 */
  -moz-box-shadow: 0 2px 4px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>; /* ボックスシャドウ */
  -webkit-box-shadow: 0 2px 4px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>;
  box-shadow: 0 2px 4px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>;
}

.webphoto_single_photo {
	background-color: transparent;
}
.webphoto_single_photo img {
    -moz-box-shadow: 0 5px 20px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>; /* ボックスシャドウ */
    -webkit-box-shadow: 0 5px 20px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>;
    box-shadow: 0 5px 20px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>;
}

#ModuleContents table td.webphoto_list_td_image .webphoto_list_image img ,
#ModuleContents .webphoto_table_image img {
	background: #fff;
	border: 1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
	-moz-box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* Firefox用 */
	-webkit-box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* Safari,Chrome用 */
	box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* CSS3 */
	-moz-border-radius: 5px;
	-webkit-border-radius: 5px;
	border-radius: 5px;
}

/* athers  */

#ModuleContents #d3dWrap #d3dMainNoside #d3dMainBodyNoside div.boxdate_base {
	border: 1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
	-moz-border-radius: 12px;
	-webkit-border-radius: 12px;
	border-radius: 12px;
	background:url(images/wht14.jpg);
	-moz-box-shadow: 5px 5px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>;
	-webkit-box-shadow: 5px 5px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>;
	box-shadow: 5px 5px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>;
}

#ModuleContents #d3dWrap #d3dMainNoside #d3dMainBodyNoside .itemList {
	border:1px solid <?php echo _THEME_CONFIG_BORDERSLIGHT_COLOR ?>;
	-moz-box-shadow: 5px 5px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>;
	-webkit-box-shadow: 5px 5px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>;
	box-shadow: 5px 5px 10px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>;
}
#ModuleContents .weblinks_link_single_frame_time_update {
  background-color: <?php echo _THEME_CONFIG_ODD_COLOR ?>;
}
#ModuleContents .weblinks_link_single_frame_category {
	border-bottom:1px solid <?php echo _THEME_CONFIG_BORDERLIGHT_COLOR ?>;
}


/* ------------ for wordpress (xpress) -------------------- */
/* Wordpress (XpressME) */
#ModuleContents #xpress-comments-block {
	background:<?php echo _THEME_CONFIG_BASE_COLOR ?>;
	border:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
	-webkit-box-shadow: 3px 3px 5px 1px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* Safari, Chrome用 */
	-moz-box-shadow: 3px 3px 5px 1px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* Firefox用 */
	box-shadow: 3px 3px 5px 1px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; /* CSS3 */
}

#xpress_content .xpress-post .xpress-post-header {
	border:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
    background-color: <?php echo _THEME_CONFIG_BASE_COLOR ?>;
    -webkit-box-shadow: 0 0 4px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>, inset 0 0 50px <?php echo _THEME_CONFIG_BOXSHADOWSLIGHT_COLOR ?>;
    -moz-box-shadow: 0 0 4px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>, inset 0 0 50px <?php echo _THEME_CONFIG_BOXSHADOWSLIGHT_COLOR ?>;
    box-shadow: 0 0 5px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>, inset 0 0 50px <?php echo _THEME_CONFIG_BOXSHADOWSLIGHT_COLOR ?>;
}

#xpress_wrap #xpress_content .xpress-post-ymdl .xpress-post-year ,
#xpress_wrap #xpress_content .xpress-post-ymdl .xpress-post-md {
	color:<?php echo _THEME_CONFIG_LINK_COLOR ?>;
	text-shadow:
		-1px -1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>,
		1px 1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}
#xpress_wrap #xpress_content .xpress-post .large_thumbnail img ,
#xpress_wrap #xpress_content .xpress-post .eyecatch-image img {
	-moz-border-radius: 10px;
	-webkit-border-radius: 10px;
  -moz-box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>; /* Firefox用 */
  -webkit-box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>; /* Safari,Chrome用 */
  box-shadow: 0px 2px 10px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>; /* CSS3 */
}

#xpress_wrap #xpress_content .xpress-post .xpress-post-header .xpress-post-excerpt {
	color:<?php echo _THEME_CONFIG_TEXTLIGHT_COLOR ?>;
}
#xpress_wrap #xpress_content .xpress-post .xpress-eyecatch-post-md {
	color:<?php echo _THEME_CONFIG_HEADER_COLOR ?>;
	text-shadow:
		-1px -1px 0px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>,
		1px -1px 0px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>,
		1px 1px 0px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>,
		-1px 1px 0px <?php echo _THEME_CONFIG_BOXSHADOW_COLOR ?>;
}
#xpress_wrap #xpress_content .xpress-post h2 {
	text-shadow: 1px 1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}
.xpress-post h2 a{
	border-bottom:3px dotted <?php echo _THEME_CONFIG_TEXTCL_COLOR ?>;
}

.noteline ,
#xpress_wrap #xpress_content .xpress-post .noteline {
	border-bottom:1px solid <?php echo _THEME_CONFIG_NOTELINE_COLOR ?>;
}

#ModuleContents .xpress-post-entry h3 {
	color: <?php echo _THEME_CONFIG_TEXTB_COLOR ?>;
}

#ModuleContents .xpress-pings-block h3 {
	color: <?php echo _THEME_CONFIG_TEXTB_COLOR ?>;
	text-shadow: 1px 1px 1px <?php echo _THEME_CONFIG_BASE_COLOR ?>;
}



/* End Wordpress (XpressME) */

#ModuleContents .weblinks_guidance {
	border:1px solid <?php echo _THEME_CONFIG_BORDERSLIGHT_COLOR ?>;
	background:<?php echo _THEME_CONFIG_ODD_COLOR ?>;
}

#ModuleContents table.weblinks_frame_category {
	border:1px solid <?php echo _THEME_CONFIG_BORDERSLIGHT_COLOR ?>;
}

/* extra  */
#ModuleContents .phpsource {
	background:<?php echo _THEME_CONFIG_BASE_COLOR ?>;
	border:1px solid <?php echo _THEME_CONFIG_BORDER_COLOR ?>;
	box-shadow:	1px 1px 1px 1px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; 
	-moz-box-shadow: 1px 1px 1px 1px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; 
	-webkit-box-shadow: 1px 1px 1px 1px <?php echo _THEME_CONFIG_BOXSHADOWLIGHT_COLOR ?>; 
}

/* XOOPS Code & Quote */
#ModuleContents #pico_body .xoopsCode ,
#ModuleContents .xoopsCode ,
.xoopsCode {
  background: <?php echo _THEME_CONFIG_BGCODE_COLOR ?>;
  border: 1px inset <?php echo _THEME_CONFIG_BORDERSLIGHT_COLOR ?>;
}
#ModuleContents #pico_body .xoopsQuote ,
#ModuleContents .xoopsQuote ,
.xoopsQuote {
  background-color:<?php echo _THEME_CONFIG_BGQUOTE_COLOR ?>;
  border: 1px solid <?php echo _THEME_CONFIG_BORDERSLIGHT_COLOR ?>;
}
body.wordpress #ModuleContents blockquote {
  background-color:<?php echo _THEME_CONFIG_BGQUOTE_COLOR ?>;
  border-left: 10px solid <?php echo _THEME_CONFIG_GRADIENT1_COLOR ?>;
}

#ModuleContents .xoopsQuote blockquote:before ,
#ModuleContents blockquote:before ,
blockquote:before {
    color: <?php echo _THEME_CONFIG_GRADIENT1_COLOR ?>;
}

/* for pico */
#ModuleContents #pico_body h1 {
	border-left:6px solid <?php echo _THEME_CONFIG_H1_BORDER_COLOR ?>;
}
#ModuleContents #pico_body h2 {
	border-left:6px solid <?php echo _THEME_CONFIG_H2_BORDER_COLOR ?>;
}
#ModuleContents #pico_body h3 {
	border-left:6px solid <?php echo _THEME_CONFIG_H3_BORDER_COLOR ?>;
}
#ModuleContents #pico_body h4 {
	border-left:6px solid <?php echo _THEME_CONFIG_H4_BORDER_COLOR ?>;
}
#ModuleContents #pico_body h5 {
	border-left:6px solid <?php echo _THEME_CONFIG_H5_BORDER_COLOR ?>;
}
#ModuleContents #pico_body h6 {
	border-left:6px solid <?php echo _THEME_CONFIG_H6_BORDER_COLOR ?>;
}

dl.pico_block_menu dt {
	background:<?php echo _THEME_CONFIG_BGSSLIGHT_COLOR ?>;
}
dl.pico_block_menu dd li {
	color:<?php echo _THEME_CONFIG_TEXTCL_COLOR ?>;
}
.pico_block_menu span {
	color:<?php echo _THEME_CONFIG_TEXTSLIGHT_COLOR ?>;
}
.pico_block_menu div {
	background: <?php echo _THEME_CONFIG_ODD_COLOR ?>;
}


#ModuleContents .webphoto_description {
    position: relative;
    -webkit-box-shadow: 0 0 4px rgba(0, 0, 0, 0.2), inset 0 0 50px rgba(0, 0, 0, 0.1);
    -moz-box-shadow: 0 0 4px rgba(0, 0, 0, 0.2), inset 0 0 50px rgba(0, 0, 0, 0.1);
    box-shadow: 0 0 5px rgba(0, 0, 0, 0.2), inset 0 0 50px rgba(0, 0, 0, 0.1);
}
