package errorReachableAnalyzer;

import java.util.*;
import java.util.concurrent.LinkedBlockingQueue;

import multiConcurrentModel.*;

public class MultiRequirementParser {
	private MultiConcurrentModel mcm;
	private int checker[];
	private Queue<MultiConcurrentTransition> deadStack;

	public MultiRequirementParser(MultiConcurrentModel mcm,int[] checker){
		this.mcm=mcm;
		this.checker=checker;
		deadStack=new LinkedBlockingQueue<MultiConcurrentTransition>();
	}

	
	public MultiRequirementParser() {
		//eXgpɍRXgN^
	}

	
	public List<int[]> checkSimulate(ModelInterface controller){
		pasteDead();
		pasteController(controller);
		return checkCanSimulateM(this.mcm);
	}
	public List<int[]> checkUpdatedSimulate(ModelInterface controller) {
		pasteUpdatedDead();
		this.pasteController(controller);
		return checkCanSimulateM((MultiConcurrentModel)mcm);
	}
	List<int[]> checkCanSimulateM(MultiConcurrentModel rs){
		List<int[]>result=new ArrayList<int[]>();
		boolean isDead=false;
		for(int i=0;i<rs.getSize();i++){
			MultiConcurrentState s=rs.getState(i);
			if(s.isController()&&s.isDead()){
				isDead=true;
				result=integratingResult(result, s.getDeadList());
			}
		}
		for(int i=0;i<result.size();i++)
			System.out.println("Degradation candidate:"+result.get(i)[0]);
		
		for(int i=0;i<rs.getErrorSize();i++){
			if(rs.getErrorState(i).isController()){
				isDead=true;
				System.out.println("controller cannot be generated: "+rs.getErrorState(i));
				System.out.println("  "+rs.getErrorState(i));
//				break;
			}
		}
		if(!isDead){
			System.out.println("controller can be generated");	
		}else{
			System.out.println("controller cannot be generated:");
		}
		return result;
	}
	public List<int[]> integratingResult(List<int[]> oldResult,List<int[]> current ){
		List<int[]> newResult=new ArrayList<int[]>();
		if(oldResult==null||oldResult.size()==0)return current;
		for(int j=0;j<current.size();j++){
			boolean isTarget=true;
			for(int k=0;k<checker.length;k++){
				if((current.get(j)[k]|checker[k])!=checker[k]){
					isTarget=false;break;
				}
			}
			if(isTarget)
				for(int i=0;i<oldResult.size();i++){
					int[] newR=new int[current.get(j).length];
					for(int k=0;k<current.get(j).length;k++){
						newR[k]=oldResult.get(i)[k]|current.get(j)[k];
					}
					newResult.add(newR);
				}
		}
		
		return minimizeList(newResult);
	}

	public void pasteDead(){
		deadStack=mcm.getErrorTransition();
		pasteMultiDeadWithStack();
	}
	
	
	public void pasteMultiDeadWithStack(){
		while(!deadStack.isEmpty()){
			if(deadStack.size()<50) {
			}
			MultiConcurrentTransition tmp=deadStack.remove();
			MultiConcurrentState s=(MultiConcurrentState)tmp.getFrom();
			
			if(stateDeadCheckForAllReq(s)){
				for(int i=0;i<s.getFromTransitionNum();i++){
					MultiConcurrentTransition t=(MultiConcurrentTransition)s.getFromTransition(i);
					if(!deadStack.contains(t))
						deadStack.add(t);
				}
			}
		}
	}	
	
	boolean stateDeadCheckForAllReq(MultiConcurrentState m){
		
		/*m[hLosing regionɑ邩ۂ𔻒肵Aꍇ͂Losing region肷B
		 * 肵Losing region͈m[hɕێB
		 * mȉ̂ǂ炩̏𖞂ꍇALosing regionɑB
		 * ܂ALosing region̓@͖ɉĈقȂ̂łLB
		 * Aȉ"AND""OR"͉L"Losing region"̊Ǘ@̋Lڂɉ̂Ƃ
		 * 1iȉANDj:
		 * Jڐ̃m[hLosing regionɑ悤UncontrollableȑJڂPȏ㑶݂ꍇ
		 * 	@F
		 * 		moĂUncontrollableȑJڂ̐̃m[hLosing regionSĒo
		 * 		ANDɂČqmLosing regionƂȂ
		 * 2iȉORjF
		 * 	AND𖞂ASĂ̑JڂɂāAJڐ̃m[hLosing regionɑ悤ȏꍇ
		 * 	@F
		 * 		moĂSđJڂ̐̃m[hLosing region𒊏o
		 * 		ORɂČqmLosing regionƂȂ
		 * 
		 * L̏1,2ɍvȂ̂͂Losing regionɂ܂܂ȂB
		 * ̏ꍇAʂmɕێB
		 * 
		 */
		
		/*Losing region̊Ǘ@
		 * a.Losing regionANDORp_ɂĕ\\łB
		 * 	a-0._\_vfp1̗͂vfɑΉ邠safety propertyۏ؏oȂȂƂ\B
		 * 	a-1.ANDi&&j͂2safety property p1p2ɕۏ؏oȂȂ悤Losing region\̂ɗp
		 * 		"p1 && p2" ƕ\ȂALosing regionp1p2̂ǂۏؕs\ł
		 * 	a-2.OR(||)͂2safety property p1p2̂ǂ炩ۏ؏oȂ悤Losing region\̂ɗp
		 * 		"p1 || p2"ƕ\ȂALosing region͈̕ۏ؂߂ȂΑ̕ۏ؂oȂԂłB
		 * b.ʓIȘ_̕ό`\Ȃ߁AGLosing region̎
		 * 	̗̂悤AND݂̂ō\ORŌq`ɕό`
		 * 	1: (p1 || p2)&&(p3 || p4)=(p1 && p3)||(p1 && p4)||(p2 && p3)||(p2 && p4)
		 *  2: p1 &&(p2 || p3)=(p1 && p2)||(p1 || p3)
		 *  3:@(p1 || p2) && p3 &&(p3 || p2)
		 *  	= (p1 && p3 && p3)||(p1 && p2 && p3)||(p2 && p3 && p3)||(p2 && p2&& p3)
		 * 		=(p1 && p3)||(p2 && p3)
		 * 	vZʂ팸邽߁AKvɉė3̂悤Ɏ̊ȒP}
		 *c.La.b.ɓĂint^zvfɎXgŕ\ 
		 *	c-0.ǂsafety propertyۏ؏oȂȂ̂bitɂĕ\B
		 *		"int"ƂĂ邪AԂbitłBbitɑ΂čsBint^ł鎖̂ɈӖ͂ȂB
		 *		zɂ̂int^32bitł邽߁A33ȏsafety property߂̑[ułB
		 * 	c-1.int^zAND݂̂ō\\ĂB
		 * 		Ⴆp1-p6܂ł6safety propertyVXeɂ
		 * 		p1p3ۏ؏oȂ(Ȃ킿Ap1 && p3ł)悤Losing region"000101"ƕ\B
		 * 		iint^ƂĈĂ̂ŐlƂĂ"5"ƕ\j
		 * 	c-2.int^z̗vfXgƂĊi[鎖ł̗vfԂORŌqĂ邱ƂӖĂB
		 * 		Ⴆp1-p6܂ł6safety propertyVXeɂ
		 * 		(p1 && p3)||(p2 && p5 && p6)ƂLosing region
		 * 		"000101""110010"Ƃ2̗vfXgɂĕ\B
		 * 		̂悤ɂ邱ƂŁALosing regionǂ̂悤safety propertyɋNč\zĂ邩
		 * 		iLosing regionł͂ǂ̑gݍ킹safety property̕ۏ؂߂Ηǂ̂j
		 * 		eՂɂ킩B̏ꍇp1,p32߂邩Ap2,p5,p63߂邩̓ƂȂB
		 */

		//ANDꍇɁALosing region̓ɗpLosing regionێ邽߂̃Xg
		List<List<int[]>> andDeadLists=new ArrayList<List<int[]>>();

		//ORꍇɁALosing region̓ɗpLosing regionێ邽߂̃Xg		
		List<int[]>orDeadExp=new ArrayList<int[]>();
		
		//m[hAND𖞂AOR𖞂𔻒f邽߂boolϐ
		boolean andDead=false,orDead=true;
		//m[hJڂ擪珈邽߂̑O
		m.reset();

		//m[hJڂɃ`FbNAANDA܂OR𖞂`FbN
		while(m.hasNext()){
			//`FbNJڂmctƂB
			MultiConcurrentTransition mct=(MultiConcurrentTransition) m.next();

			//mAND𖞂mctpĔf
			//ifxłtrueɂȂmAND𖞂Ƃm肷B
			if((((MultiConcurrentState)mct.getTo()).isDead()||mct.isDead())&&!mct.isControllable()){
				/*ȉAmLosing region肷邽߂Losing regionۑ邽߂̍
				 *fł̓m[hƂ͓ƗđJڂLosing regionɑꍇ݂
				 *mct̑Jڐ悪Losing regionɑĂ邩mct̂Losing regionɑĂ邩
				 *邢͂̂ǂɂāAɏ𕪂Ă邪A܂ŉłB
				 *܂Aɑ̑Jڐœ肵Losing regionƏdȂ肪悤Losing region͂̎_ŏȂ
				 *iLosing region̊Ǘ@ b.ŐGꂽÅȒPsĂj
				 */
				List<int[]> l=((MultiConcurrentState)mct.getTo()).getDeadList();
				if(l!=null&&!l.isEmpty()){					
					if(mct.getDead()!=null){
						List<int[]> ll=new ArrayList<int[]>();
						for(int i=0;i<l.size();i++){
							int[] tmp=new int[l.get(i).length];
							for(int j=0;j<tmp.length;j++)tmp[j]=l.get(i)[j]|mct.getDead()[j];
							boolean contains=true;
							for(int j=0;j<ll.size();j++){
								if(!checkContains(ll.get(j),tmp))contains=false;
							}
							if(!contains||ll.isEmpty())ll.add(tmp);
						}
						andDeadLists.add(ll);
						
					}else{
						List<int[]> ll=new ArrayList<int[]>();
						for(int i=0;i<l.size();i++){
							int[] tmp=new int[l.get(i).length];
							for(int j=0;j<tmp.length;j++){
								tmp[j]=l.get(i)[j];
							}
							ll.add(tmp);
						}
						andDeadLists.add(ll);
					}
				}else{
					List<int[]> in=new ArrayList<int[]>();
					int[] tmp=new int[mct.getDead().length];
					for(int i=0;i<tmp.length;i++)tmp[i]=mct.getDead()[i];
					in.add(tmp);
					andDeadLists.add(in);
				}
				andDead=true;orDead=false;
			//mOR𖞂mctpĔf
			//{whilȇSẴ[vɂĂiftrueƂȂꍇ̂݁AORB
			//tɌ΁AxłȂOR邱Ƃ͂Ȃ
			}else if(orDead&&(((MultiConcurrentState)mct.getTo()).isDead()||mct.isDead())&&mct.isControllable()){
				/*ȉAmLosing region肷邽߂Losing regionۑ邽߂̍
				 * AND̏ꍇƐ͓łB
				 */
				List<int[]> l=((MultiConcurrentState)mct.getTo()).getDeadList();
				List<int[]> newl=new ArrayList<int[]>();
				if(mct.getDead()!=null){
					if(l==null||l.isEmpty()){
						int[]tmp=new int[mct.getDead().length];
						for(int j=0;j<tmp.length;j++){
							tmp[j]=mct.getDead()[j];
						}
						newl.add(tmp);
					}else
						for(int i=0;i<l.size();i++){
							int[]tmp=new int[l.get(i).length];
							for(int j=0;j<tmp.length;j++){
								tmp[j]=mct.getDead()[j]|l.get(i)[j];
							}
							newl.add(tmp);
						}
				}else{
					for(int i=0;i<l.size();i++){
						int[] tmp=new int[l.get(i).length];
						for(int j=0;j<l.get(i).length;j++){
							tmp[j]=l.get(i)[j];
						}
						newl.add(tmp);
					}
				}
				orDeadExp.addAll(newl);
				orDeadExp=minimizeList(orDeadExp);
			//mANDORȂmctpĔf
			//elsexłʂOR𖞂͂Ȃ
			//AND𔻒f镪xłʂĂ܂ꍇAANDꂽ̂ƂȂ
			}else{
				orDead=false;
			}
		}
		m.reset();
		
		//ȉAORꂽꍇAANDꂽꍇȀȂꍇ
		//Losing region̍XVsB
		/*OȐꍇ́AŏW߂Losing regionORŌqA
		 * Ȃ킿AXg̗vfɓ邾Ȃ̂ŁÂ܂ܓւ`ƂȂB
		 */
		if(orDead){
			return m.replaceDeadList(orDeadExp);
		}
		/*AND̏ꍇ́AŏW߂Losing regionANDŌqA
		 *PANDŌqꍇAǗ@̕jƈقȂĂ܂̂
		 *ό`ɑ鏈ōsAORŌqꂽ`ŕ\ȂB
		 */
		else if(andDead){
			List<int[]>newl=new ArrayList<int[]>();
			for(int i=0;i<andDeadLists.size();i++){
				newl=composeList(newl,andDeadLists.get(i));
			}		
			return m.replaceDeadList(newl);
		}			
		/*ORANDȂꍇ
		 *Losing regionB 
		 */
		else {
			return m.replaceDeadList(new ArrayList<int[]>());
		}
	}
	
	List<int[]> composeList(List<int[]> a,List<int[]>b){
		if(a==null||a.isEmpty()){
			b=minimizeList(b);
				
			return b;
		}else if(b==null||b.isEmpty()){
			a=minimizeList(a);
			return a;
		}
		List<int[]> ab=new ArrayList<int[]>();
		for(int i=0;i<a.size();i++)
			for(int j=0;j<b.size();j++){
				int[] tmpa=new int[a.get(i).length];
				for(int k=0;k<tmpa.length;k++){
					tmpa[k]=a.get(i)[k]|b.get(j)[k];
				}
				ab.add(tmpa);
			}
		ab=minimizeList(ab);
		
		return ab;
	}
	
	

	
	void pasteController(ModelInterface controller){
		for(int i=0;i<controller.getSize();i++)controller.getState(i).reset();
		pasteCToStateWithHash(controller.getInitialState(),mcm.getInitialState());
	}

	
	//nbV}bvpRg[̃V~[V
	//Rg[̃f̑SԂƑSJڂɑΉ񍇐f̏ԂƑJڂ肵AɃ}[NĂ\bh
	//Rg[̏ԑJڂɂĕ񍇐fERRORɓBꍇ͂̎_Ōxēł؂
	void pasteCToStateWithHash(State c,State m){
		HashMap<State,ContSet> map =new HashMap<State,ContSet>();
		ContSet cu=new ContSet(c,m),next;
		cu.getController().setIsController();
		cu.getModel().setIsController();
		while(cu.getController().hasNext()){
			Transition t =(Transition)cu.getController().next();
			if(cu.getModel().getToTransition(t.toString())==null){
				cu.getModel().setIsController();
			}else{
				if(cu.getController().hasNext()&&!map.containsValue(cu)){
					map.put(cu.getController(),cu);
				}
				next=new ContSet(t.getTo(),cu.getModel().getToStateByTransition(t.toString()));
				next.getController().setIsController();
				next.getModel().setIsController();
				if(!next.getController().hasNext()&&!map.isEmpty()){
					next=map.remove(map.keySet().toArray()[0]);
				}else if(map.containsKey(next.getController())){
					map.remove(next.getController());
				}
				cu=next;
			}				
		}
		
	}
	//Rg[̃V~[V`FbN̂߂̏ێ邽߂̃NX
	class ContSet{
		State controller,model;
		ContSet(State c,State m){
			this.controller=c;
			this.model=m;
		}
		State getController(){
			return this.controller;
		}
		State getModel(){
			return this.model;
		}
	}
	void pasteUpdatedDead(){
		List<Transition> l=mcm.getUpdatedPart();
		if(l.size()==0){
			return;
		}
		for(int i=0;i<l.size();i++){
			if(((MultiConcurrentState)l.get(i).getTo()).isDead()||((MultiConcurrentTransition)l.get(i)).getDead()!=null||(!((MultiConcurrentState)l.get(i).getTo()).isDead()&&((MultiConcurrentState)l.get(i).getFrom()).isDead())){
				deadStack.add((MultiConcurrentTransition)l.get(i));
			}else{
//				System.out.println("This updated part is not need to be analyzed");
			}
		}
		pasteMultiDeadWithStack();
	}
	
	boolean checkContains(int[] container,int[] containee){
		for(int i=0;i<container.length;i++){
			if((container[i]|containee[i])!=containee[i]){
				return false;
			}
		}
		return true;
	}
	List<int[]> minimizeList(List<int[]> a){
		List<int[]> ab=new ArrayList<int[]>();
		for(int i=0;i<a.size();i++){
			int[]tmp=new int[a.get(i).length];
			for(int j=0;j<tmp.length;j++)
				tmp[j]=a.get(i)[j];
			ab.add(tmp);
		}
		for(int i=0;i<ab.size();i++){
			for(int j=i+1;j<ab.size();j++)
				if(checkContains(ab.get(i),ab.get(j))){
					ab.remove(j);
					j--;
				}
				else if(checkContains(ab.get(j),ab.get(i))){
					ab.remove(i);
					j=i;
				}
		}
		return ab;

	}	
}