/*
 *  tcpan
 *       
 *  Input File:   
 *    [File]=>[Export]=>[File]
 *       Export Option
 *       [v]Packet summary line
 *       [v]Packet details: [As displayed]
 *       [v]Packet Bytes
 *       [ ]Each packet on a new page
 *
 *  10/02/06 V0.10 by oga.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#ifdef _WIN32
#include <windows.h>
#include <sys/utime.h>
#endif  /* _WIN32 */

#define	dprintf   if (vf) printf
#define	dprintf2  if (vf >= 2) printf
#define	dprintf3  if (vf >= 3) printf

#define MAX_NTCPDATA 200000
#define MAX_NPORTID  50000

#define KEY_TCP     "Transmission"
#define KEY_PKTDATA "0030"

typedef struct _tcpdata {
    int   frmno;
    char  date[11];        /* yyyy-mm-dd      */
    char  time[16];        /* hh:mm:ss.nnnnnn */
    char  srcip[16];       /* xxx.xxx.xxx.xxx */
    char  dstip[16];       /* xxx.xxx.xxx.xxx */
    char  proto[16];       /* protocol        */
    char  info[100];
    char  portid[12];      /* <port1>-<port2> , port1 < port2 */
    int   srcport;
    int   dstport;
    int   seq;
    int   ack;
    char  *pktdata;        /* packet bytes    */
} tcpdata_t;

int vf      = 0;           /* -v verbose mode */
int portf   = 0;           /* -port           */
int cnt     = 0;           /* frm data count  */
int nportid = 0;           /* num of portid   */
tcpdata_t *tcpdatas = NULL;
char      **portids = NULL;
char      *start_time = "00:00:00.000000";
char      *end_time   = "99:99:99.999999";

/*
 *   s蒷̃f[^Rs[Ãf[^ڂɈʒuÂ  
 *
 */
void CopyWord(char *obuf, int obufsiz, char **ibufp, char delm)
{
	int len = 0;
    while(**ibufp != delm) {
		*obuf = **ibufp;
		++obuf;
		++len;
		++(*ibufp);
		if (len >= obufsiz - 1) {
			*obuf = '\0';
			break;
		}
	}
	while(**ibufp == delm) ++(*ibufp);    /* skip space     */
	*obuf = '\0';
}

void GetSummary(char *buf, tcpdata_t *tcpdatp)
{
	char *pt = buf;

	while(*pt == ' ') ++pt;                /* skip space     */
	tcpdatp->frmno = atoi(pt);
	while(*pt != ' ') ++pt;                /* skip not space */
	while(*pt == ' ') ++pt;                /* skip space     */
	strncpy(tcpdatp->date, pt, 10);        /* copy date      */
	while(*pt != ' ') ++pt;                /* skip not space */
	while(*pt == ' ') ++pt;                /* skip space     */
	strncpy(tcpdatp->time, pt, 15);        /* copy time      */
	while(*pt != ' ') ++pt;                /* skip not space */
	while(*pt == ' ') ++pt;                /* skip space     */
	CopyWord(tcpdatp->srcip, sizeof(tcpdatp->srcip), &pt, ' '); /* copy source ip */
	CopyWord(tcpdatp->dstip, sizeof(tcpdatp->dstip), &pt, ' '); /* copy dest   ip */
	CopyWord(tcpdatp->proto, sizeof(tcpdatp->proto), &pt, ' '); /* copy protocol  */
	CopyWord(tcpdatp->info,  sizeof(tcpdatp->info), &pt, '\n'); /* copy info      */
}

/*
 *  Get Port Number and Seq/Ack Number
 *
 */
void GetPortNo(char *buf, tcpdata_t *tcpdatp)
{
	char *pt = buf;

	/* search source port */
	pt = strchr(pt, '(');
	if (pt) {
		tcpdatp->srcport = atoi(++pt);
	}
	/* search dest port */
	pt = strchr(pt, '(');
	if (pt) {
		tcpdatp->dstport = atoi(++pt);
	}

	/* search Seq number */
	pt = strstr(pt, "Seq:");
	if (pt) {
		pt += 5;
		tcpdatp->seq = atoi(pt);
	}
	/* search Ack number */
	pt = strstr(pt, "Ack:");
	if (pt) {
		pt += 5;
		tcpdatp->ack = atoi(pt);
	}
}

/*
 *   hexasciiɕϊ
 *
 *   "48656c6c6f" => "Hello"
 *   "48 65 6c 6c 6f" => "Hello"  Ԃ̃Xy[X
 *
 *   ret : length
 */
int hex2str(char *in, char *out)
{
    int  i = 0;
    int  j = 0;
    char wk[16];
    char cc;
	unsigned char *out2 = (unsigned char *)out;

    while (isspace(in[i])) i++;

    while (isdigit(in[i]) || (in[i] >= 'a' && in[i] <= 'f')) {
        strcpy(wk, "0x");
        memcpy(&wk[2], &in[i], 2);
        wk[4] = '\0';
        out[j] = (char)strtoul(wk, (char **)NULL, 0);
        i += 2;
        while (isspace(in[i])) i++;

		/* 0x20̏ꍇ͖(As͗L) */
		//if (out2[j] >= 0x20 || out2[j] == 0x0a || out2[j] == 0x0d) 
		/* 0x20̏ꍇ͖(s\) */
		if (out2[j] >= 0x20)
		{
        	++j;
		}
    }
    out[j] = '\0';
    return j;       // ϊʂoCȉꍇ̂߂ɒԂ
}

void GetPktData(char *ibuf, tcpdata_t *tcpdatp, FILE *fp)
{
	char wkstr[4096];
	char buf[4096];
	char ostr[32*1024];

	dprintf2("### start GetPktData\n");
	strcpy(wkstr, "");
	strcpy(ostr, "");
	strcpy(buf, ibuf);
	do {
		if (strlen(buf) >= 8) {
			/* 0000  00 01 02 03... */
			hex2str(&buf[6], wkstr);
			if (vf) printf("buf:[%s]=>wkstr:[%s]\n", buf, wkstr);
			strcat(ostr, wkstr);
			//if (strlen(ostr) > 512) break;
		} else {
			break;
		}
	} while(fgets(buf, sizeof(buf), fp));
	tcpdatp->pktdata = strdup(ostr);
	dprintf2("### end GetPktData\n");
}

void AddPortId(char *portid)
{
	int i;
	int found = 0;

	/* 납猟AȂΒǉ(ɓ̂m) */
	for (i = nportid-1; i>=0; i--) {
		if (!strcmp(portid, portids[i])) {
			found = 1;
			break;  /* ݂ */
		}
	}
	if (!found) {
		if (nportid < MAX_NPORTID) {
			//strcpy(portids[nportid], portid);
			portids[nportid] = strdup(portid);
			++nportid;
		} else {
			printf("Error: num of portid(%d) overflow\n", nportid);
		}
	}
}

void PrintTcpDat(tcpdata_t *tcpdatp)
{
	//if (tcpdatp->frmno == 7809) return;
	if (vf > 2) {
		printf("@@@@@ start\n"); fflush(stdout);
		printf("@@@@@ [%s]\n", tcpdatp->pktdata); fflush(stdout);
		printf("@@@@@ end\n"); fflush(stdout);
	}
	/* No date time portid src(port) dst(port) protocol Seq Ack info pktdat */
	printf("%7d %s %s %11s %15s(%5d) %15s(%5d) Seq:%5u Ack:%5u %8s %s",
		   tcpdatp->frmno,
		   tcpdatp->date,
		   tcpdatp->time,
		   tcpdatp->portid,
		   tcpdatp->srcip,
		   tcpdatp->srcport,
		   tcpdatp->dstip,
		   tcpdatp->dstport,
		   tcpdatp->seq,             /* option */
		   tcpdatp->ack,             /* option */
		   tcpdatp->proto,
		   tcpdatp->info);
	if (tcpdatp->pktdata) {
		printf(" [%s]\n", tcpdatp->pktdata);
	} else {
		printf("\n");
	}
	if (vf) fflush(stdout);
}

void ReadTcpFile(char *fname)
{
	FILE *fp = NULL;
	char buf[4096];
	int  newdata;
	tcpdata_t tcpdat;
	
	memset(&tcpdat, 0, sizeof(tcpdat));

	if ((fp = fopen(fname, "r")) == NULL) {
	    perror(fname);
		exit(1);
	}

	newdata = 0;
    while(fgets(buf, sizeof(buf), fp)) {
		if (!strncmp(buf, "No.", 3)) {
			newdata = 1;
			if (tcpdat.frmno > 0) {      /* 1ڂ͏o͂Ȃ悤ɂ */
				/* Of[^̓o^ */
				memcpy(&tcpdatas[cnt++], &tcpdat, sizeof(tcpdat));
				/* Of[^̕\ */
				if (!portf) PrintTcpDat(&tcpdat);
				memset(&tcpdat, 0, sizeof(tcpdat));
				if (cnt >= MAX_NTCPDATA - 2) {
					printf("Error: too many tcpdata %d\n", cnt);
					break;
				}
			}
			continue;
		}
		if (newdata) {
			GetSummary(buf, &tcpdat);
			newdata = 0;
			continue;
		}
		if (!strncmp(buf, KEY_TCP, strlen(KEY_TCP))) {
			GetPortNo(buf, &tcpdat);
			if (tcpdat.srcport < tcpdat.dstport) {
				sprintf(tcpdat.portid, "%d-%d", tcpdat.srcport, tcpdat.dstport);
			} else {
				sprintf(tcpdat.portid, "%d-%d", tcpdat.dstport, tcpdat.srcport);
			}
			AddPortId(tcpdat.portid);
		}
		if (!strncmp(buf, KEY_PKTDATA, strlen(KEY_PKTDATA)) && tcpdat.pktdata == NULL) {
			GetPktData(buf, &tcpdat, fp);
		}
	}
	memcpy(&tcpdatas[cnt++], &tcpdat, sizeof(tcpdat));

	if (fp) fclose(fp);
}

void DispByEachPortid()
{
	int i, j;
	printf("### Num of Portid: %d\n", nportid);
	for (i = 0; i<nportid; i++) {
		printf("{### Portid[%d] %s\n", i, portids[i]);
		for (j = 0; j<cnt; j++) {
			if (!strcmp(portids[i], tcpdatas[j].portid) &&
			    strcmp(tcpdatas[j].time, start_time) >= 0 &&
			    strcmp(tcpdatas[j].time, end_time)   <= 0 ) {
				PrintTcpDat(&tcpdatas[j]);
			}
		}
	}
}

void usage()
{
    printf("usage: tcpan [-port] <wireshark_exp_file.txt>\n");
    printf("  -port: disp each communication port\n");
    printf("  Wireshark Export Option\n");
    printf("    [File]=>[Export]=>[File]\n");
    printf("       [v]Packet summary line\n");
    printf("       [v]Packet details: [As displayed]\n");
    printf("       [v]Packet Bytes\n");
    printf("       [ ]Each packet on a new page\n");
    exit(1);
}

int main(int a, char *b[])
{
    int  i;
    char *fname = NULL;

    for (i = 1; i<a; i++) {
        if (!strcmp(b[i], "-v")) {
            ++vf;
            continue;
        }
        if (!strcmp(b[i], "-port")) {
            portf = 1;
            continue;
        }
        if (!strcmp(b[i], "-s") && a > i+1) {
            start_time = b[++i];
            continue;
        }
        if (!strcmp(b[i], "-e") && a > i+1) {
            end_time = b[++i];
            continue;
        }
        if (!strcmp(b[i], "-h")) {
            usage();
        }
		fname = b[i];
    } 

	if (fname == NULL) {
		usage();
	}

	tcpdatas = (tcpdata_t *)malloc(MAX_NTCPDATA * sizeof(tcpdata_t));
	portids  = (char **)malloc(MAX_NPORTID);

	ReadTcpFile(fname);

	if (portf) {
		DispByEachPortid();
	}

    return 0;
}


/* vim:ts=4:sw=4:
 */
