/*
 *     cal       J_[o̓vO
 *
 *                                     V1.0  Initial Version. by hyper halx.f
 *                         1994.01.03  V1.1  get current date. 
 *                         1994.11.02  V1.2  holiday support. 
 *                         1994.11.11  V1.3  3050 Series support. 
 *                         1994.11.17  V1.4  HOLIDAY_PATH support. 
 *                         1994.11.22  V1.5  code clean up, and NOCOLOR support.
 *                         1996.04.25  V1.6  workingday on sat or sun support.
 *                         1996.05.02  V1.7  DOS support
 *                         1996.05.18  V1.8  auto shunbun
 *                         1996.09.22  V1.81 bug fix V1.6
 *                         1996.12.12  V1.82 color for 3050RX
 *                         1996.12.20  V1.83 append uminohi (7/20)
 *                         1997.01.24  V1.84 port to FreeBSD
 *                         2000.12.22  V1.85 fix holiday cancel bug
 *                         2014.02.11  V1.86 support NT cmmand prompt
 *
 *  X68000 : default
 *  HI-UX  : -DX_H3050R -D_HIUX_SOURCE
 *  FreeBSD: -DX_H3050R -DFREEBSD
 *  Linux  : -DLINUX
 *  DOS    : -DDOS
 *
 *
 *     usage: cal [[month] year]
 */

#ifdef _WIN32
#define DOS	1
#endif /* _WIN32 */

#ifdef DOS
#include <windows.h>
#endif /* DOS */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef FREEBSD
#include <sys/param.h>
#include <sys/mount.h>
#endif /* FREEBSD */

#include <sys/stat.h>

#if defined(X_H3050R) || defined(DOS) || defined(LINUX)
#include <time.h>
#endif

#define VER 	"1.86"
#define MAX_ENT 1000

#ifdef DOS
#define BLUE   (FOREGROUND_BLUE | FOREGROUND_GREEN | FOREGROUND_INTENSITY)  /* skyblue */
#define YELLOW (FOREGROUND_RED  | FOREGROUND_GREEN | FOREGROUND_INTENSITY)  /* yellow  */
#define WHITE  (FOREGROUND_BLUE | FOREGROUND_GREEN | FOREGROUND_RED | FOREGROUND_INTENSITY)  /* red */
#define NORMAL (FOREGROUND_BLUE | FOREGROUND_GREEN | FOREGROUND_RED)        /* normal  */
#endif /* DOS */


void cal_month();
void cal_year();
void set_data();
void get_holiday();
void read_holiday();
void print_usage();
void printf_nt();

#if defined(X_H3050R) || defined(DOS) || defined(LINUX)
int _iocs_bindateget();
#endif

int            nocolor = 0; 
int            vf      = 0; 
unsigned short colorbk = 0xffff; 

char  msg[512];
short holi[MAX_ENT*3] = { 0, 1, 1,  0, 1,15,  0, 2,11,  0, 4,29,  0, 3,21, 
		  	  0, 5, 3,  0, 5, 4,  0, 5, 5,  0, 7,20,  0, 9,15,
			  0, 9,23,  0,10,10,  0,11, 3,  0,11,23,  0,12,23 };

#ifdef X_H3050R
char *blue   = "[7m";
char *yellow = "[7m";
char *white  = "[0m";
char *normal = "[0m";
#else
#  if defined(DOS) || defined(LINUX)
char *blue   = "[36m";
char *yellow = "[33m";
char *white  = "[37m";
char *normal = "[0m";
#  else  /* X68K */
char *blue   = "[35m";
char *yellow = "[36m";
char *white  = "[37m";
char *normal = "[33m";
#  endif
#endif

#ifdef DOS
typedef struct _coltbl {
    char           *escsec;
    unsigned short color;
} coltbl_t;

coltbl_t col_tbl[] = {
    { "[36m",   BLUE },
    { "[33m", YELLOW },
    { "[37m",  WHITE },
    { "[0m" , NORMAL }
};
#endif /* DOS */


main(a,b)
int a;
char *b[];
{
	int  year = 0, month = 0, cur_flg = 0;
	int  xdate;
	char *dt=(char *)&xdate;

	if (a > 1 && strcmp(b[1],"-h") == 0) {
		print_usage();
		exit(1);
	}

#ifdef X_H3050R
	if (getenv("COLORCAL") != 0) {	/* for 3050RX */
		blue   = "[36m";
		yellow = "[33m";
		white  = "[37m";
		normal = "[0m";
	}
#endif

	if (getenv("NOCOLOR") != 0) {
		blue = yellow = white = normal = "\0";
		nocolor = 1;
	}

	get_holiday();
    	xdate = _iocs_bindateget();                   /* get date             */
	switch (a) {
		case 1: 
			year    = bcd2bin(dt[1])+1980;        /* day:year:month:date  */
			month   = bcd2bin(dt[2]);
			cur_flg = 1;                          /* today's year & month */
			break;
		case 2: 
			year  = atoi(b[1]);
			break;
		case 3: 
			month = atoi(b[1]);
			year  = atoi(b[2]);
	 		break;
	}
	if (year < 1) {
		printf("Invalid Year value. ( year > 0 )\n");
		print_usage();
		exit(1);
	}
	if (month < 0 || month > 12) {
		printf("Invalid Month value.\n");
		print_usage();
		exit(1);
	}
		
#ifdef DOS
	{
		/* backup current color */
		CONSOLE_SCREEN_BUFFER_INFO scrinfo;
		if (GetConsoleScreenBufferInfo(
			GetStdHandle(STD_OUTPUT_HANDLE), 
			&scrinfo)) {
			colorbk = scrinfo.wAttributes;
			if (vf) printf("backup color: 0x%04x\n", colorbk);
		}
	}
#endif /* DOS */

	if (month == 0) {
	        cal_year(year);
	} else {
		cal_month(year,month,cur_flg,bcd2bin(dt[3]));
	}

#ifdef DOS
	/* restore color */
	if (colorbk != 0xffff) {
		if (vf) printf("restore color.\n");
		SetConsoleTextAttribute(
			GetStdHandle(STD_OUTPUT_HANDLE), 
			colorbk);
	}
#endif /* DOS */
}

void cal_year(year)
int year;
{
	char d[21][24];            /* [x = 7 X 3][y = 6 X 4] */
	int  j,i,k,l,wk;
	int  you, month, furikae=0;

	set_data(d,year);

	sprintf(msg, "\n%s                       =====  %d N  =====\n",white,year);
	printf_nt(msg);

	for (i=0; i<4; i++) {  /* i : 3P */
	    sprintf(msg, "\n       %2d                    %2d                    %2d \n",i*3+1,i*3+2,i*3+3);
	    printf_nt(msg);
	    sprintf(msg, "\n%s%s      %sy%s    ",yellow,white,blue,white);
	    printf_nt(msg);
	    sprintf(msg, "%s%s      %sy%s    ",yellow,white,blue,white);
	    printf_nt(msg);
	    sprintf(msg, "%s%s      %sy%s\n",yellow,white,blue,white);
	    printf_nt(msg);
	    for (k=0; k<6; k++) {				/* k : c/ */
		for(l=0; l<3; l++) {				/* l :     */
		    for(j=0; j<7; j++) {			/* j : j  */
			month = i*3+l+1;
			wk = d[l*7+j][i*6+k];
			you = j;
			if (chk_holiday(year,month,wk)>0 || furikae > 0) {
			    if (furikae > 0) {
				furikae--;
			    }
			    you = 0;				/* x   */
			    if (j == 0) {
				furikae = 1;
			    } 
			}
			if (chk_holiday(year,month,wk) < 0) {
				you = 1;			/* oΓ */
			}
			switch (you) {
			    case 0:				/* j   */
				sprintf(msg, "%s",yellow);	/* F   */
				printf_nt(msg);
				break;
			    case 1:				/* j   */
			    case 2:				/* Ηj   */
			    case 3:				/* j   */
			    case 4:				/* ؗj   */
			    case 5:				/* j   */
				sprintf(msg, "%s",white);	/* F   */
				printf_nt(msg);
				break;
			    case 6:				/* yj   */
				sprintf(msg, "%s",blue);	/* F   */
				printf_nt(msg);
				break;
			}
			if (wk) {
			    sprintf(msg, "%2d%s ",wk,white);
			    printf_nt(msg);
			} else {
			    sprintf(msg, "%s   ",white,wk);
			    printf_nt(msg);
			}
		    }
		    sprintf(msg, "%s   ",white,wk);
		    printf_nt(msg);
		}
		printf("\n");
	    }
	    sprintf(msg, "%s",white);
	    printf_nt(msg);
	}
	sprintf(msg, "%s",normal);
	printf_nt(msg);
}

void cal_month(year,month,cur_flg,day)
int year,month,cur_flg,day;
{
	char	d[21][24];            /* [x = 7 X 3][y = 6 X 4] */
	int		j,k,wk;
	int		you, furikae=0;

#if 0
	printf("enter cal_month(y=%d,m=%d,f=%d,d=%d)\n",year,month,cur_flg,day);
#endif 

	set_data(d,year);

	sprintf(msg, "\n%s =====  %d N  =====\n",white,year);
	printf_nt(msg);
	sprintf(msg, "\n         %2d   \n",month);
	printf_nt(msg);
	sprintf(msg, "\n %s%s      %sy%s\n ",yellow,white,blue,white);
	printf_nt(msg);
	for (k=0; k<6; k++) {
		for(j=0; j<7; j++) {
			wk = d[((month-1)%3)*7+j][((month-1)/3)*6+k];
			you = j;
			if (chk_holiday(year,month,wk) || furikae > 0) {
				if (furikae > 0)
					furikae--;
				you = 0;			/* x(F) */
				if (j == 0) {
					furikae = 1;
				} 
			}
			if (chk_holiday(year,month,wk) < 0) {
				you = 1;			/* oΓ */
			}
			switch (you) {
				case 0:				/* j   */
					sprintf(msg, "%s",yellow); /* F*/
					printf_nt(msg);
					break;
				case 1:				/* j   */
				case 2:				/* Ηj   */
				case 3:				/* j   */
				case 4:				/* ؗj   */
				case 5:				/* j   */
					sprintf(msg, "%s",white); /* F */
					printf_nt(msg);
					break;
				case 6:				/* yj   */
					sprintf(msg, "%s",blue); /*  F */
					printf_nt(msg);
					break;
			}
			if (wk) {
				if (cur_flg && wk == day) {
					printf("[%2d]",wk);
				} else {
					sprintf(msg, "%2d%s ",wk,white);
					printf_nt(msg);
				}
			} else {
				sprintf(msg, "%s   ",white);
				printf_nt(msg);
			}
		}
		printf("\n ");
	}
	sprintf(msg, "%s\r",normal);
	printf_nt(msg);
}

void set_data(d,year)
char d[21][24];
int year;
{
	int   m1[13] = {0,31,59,90,120,151,181,212,243,273,304,334,365};  /*     Np */
	int   m2[13] = {0,31,60,91,121,152,182,213,244,274,305,335,366};  /* 邤Np */
	int   cy,cx,month,m0,a,s,j,i,k,l,wk;
	int   r;
#ifdef DEBUG
	printf("enter cal_year()\n");
#endif 
	for (cy=0; cy<24; cy++) {
		for (cx=0; cx<21; cx++) {
			d[cx][cy]=0;
		}
	}
	
	for (cy=0; cy<=3; cy++) {
	    for (cx=0; cx<=2; cx++) {
		month=cy*3+cx+1;

		if (year % 4 == 0 && 
		   (year % 100 != 0 || year % 400 == 0) ) {
			r = 365*(year-1) + m2[month-1] ;  /* 邤N  */
			m0=m2[month]-m2[month-1];         /* ̍Ō̓ */
			holi[14] = 20;	  	/* V1.8   t̓:3/20 */
		} else {
			r = 365*(year-1) + m1[month-1];
			m0=m1[month]-m1[month-1];         /* ̍Ō̓ */
		}

		/* 1:jn */
		r = r + (year-1)/4 - (year-1)/100 + (year-1)/400 + 1; 
#ifdef DEBUG
		printf("r = %d\n",r);
#endif 	
#if 0
		if (r<694033 || r>747024) {
			printf("Invalid year value. (1900 - 2100)\n");
			printf("usage : cal [year] [month]\n");
			exit(1);
		}
#endif
		a = r % 7;                            /* ̍ŏ̗̓j */
		
		s=0;                                  /* JE^         */
		for (j=0; j<=5; j++) {
			if (j == 0) {
				for (i=a; i<=6; i++) d[cx*7+i][cy*6] = ++s;
			} else {
				for (i=0; i<=6; i++) 
					if (s < m0) d[cx*7+i][cy*6+j] = ++s;
			}
		}
	    } /* cx */
	} /* cy */
}	

bcd2bin(c)
char c;
{
	return ((c/16)*10 + (c & 0xf));
}

/*
 *   OUT 1:holiday  0:non holiday  -1:workingday on sat or sun
 */
int chk_holiday(yy,mm,dd)
int yy, mm, dd;
{

	int i, ret = 0;
	
	for (i=0; i<MAX_ENT*3; i+=3) {
		if (holi[i]) {
		    /* holiday file data */
		    /* printf("yy=%d/mm=%d/dd=%d\n",yy,mm,dd); /* DEBUG */
		    if (holi[i] == yy && holi[i+1] == mm && holi[i+2] == dd) {
			ret = 1;
			break;
		    }
		    if (holi[i] == yy && holi[i+1] == mm && holi[i+2] == -dd) {
			ret = -1;
			break;
		    }
		} else {
		    /* default holiday */
		    if (holi[i+1] == mm && holi[i+2] == dd) {
			ret = 1;
			/* break; V1.85 */  
		    }
		    if (holi[i+1] == mm && holi[i+2] == -dd) {
			ret = -1;
			/* break; V1.85 */
		    }
		}
	}
	return ret;
}

#if defined(X_H3050R) || defined(DOS) || defined(LINUX)
/*
 *		    +0 +1 +2 +3
 * 	return int |00|YY|MM|DD|
 *
 *		YY = year-1980 / MM = month / DD = date
 */
int _iocs_bindateget() 
{
	int 	i  = 0;
	char 	*c = (char *)&i;
	int yy,mm,dd;

	struct tm *tmp;
	time_t tt;

	tt = time(0);
	tmp = localtime(&tt);

	yy = tmp->tm_year - 80;
	mm = tmp->tm_mon   + 1;
	dd = tmp->tm_mday;

	c[1] = (yy/10)*16 + yy % 10;
	c[2] = (mm/10)*16 + mm % 10;
	c[3] = (dd/10)*16 + dd % 10;
#if 0
	printf("tm_mday=%d (c[3]=%d)\n",tmp->tm_mday,c[3]);
#endif

	return i;
}
#endif

void get_holiday()
{
	char buf[100];
	struct stat stbuf;

	if (getenv("HOLIDAY_PATH") != 0) {
		strcpy(buf,(char *)getenv("HOLIDAY_PATH"));
		strcat(buf,"/");
	} else {
		return;
	}

	strcat(buf,"holiday");
	if (stat(buf,&stbuf)== 0) {
		read_holiday(buf,holi);
	} 
}
void read_holiday(fname)
char *fname;
{
	FILE *fp;
	int ret=0, yy,mm,dd,i=0;
	
	while (holi[i+1]+holi[i+2]) {
		i+=3;
		if (i >= MAX_ENT*3) {
			printf("read_holiday() : entry overflow!\n");
			return;
		}
	}
	if ((fp = fopen(fname,"r")) == 0) {
		perror("read_holiday()");
		return;
	}

	while (ret != EOF) {
		yy = mm = dd = 0;
		ret = fscanf(fp,"%d %d %d",&yy,&mm,&dd);
		if (yy+mm+dd == 0) {
			continue;
		}
		holi[i  ] = yy;
		holi[i+1] = mm;
		holi[i+2] = dd;
		i += 3;
		if (i >= MAX_ENT*3) {
			printf("read_holiday() : entry overflow!\n");
			return;
		}
	}
}

void print_usage()
{
	printf("\ncal Ver %s    by oga.\n",VER);
#if defined(X_H3050R) || defined(LINUX)
	printf("usage : cal2 [-h] [[month] year]\n\n");
#else
	printf("\n%s usage : cal [-h] [[month] year] %s\n\n",yellow,normal);
#endif
	printf("Environment Variable\n");
#ifdef X_H3050R
	printf("   COLORCAL=1 : color cal\n");
#endif
	printf("   NOCOLOR=1  : plain text\n\n");
	printf("If you want to specify your own holiday, make $HOLIDAY_PATH/holiday file,\n");
	printf("and set environment variable HOLIDAY_PATH.\n");
	printf("File 'holiday' is following format. Describe your holiday!\n\n");
	printf("19YY MM DD     ... holiday\n");
	printf("19YY MM DD\n");
	printf("19YY MM -DD    ... working day on Sat or Sun\n");
	printf("   :\n\n");
}

void printf_nt(char *str)
{
	int i;
	int j;

	if (nocolor) {
		printf("%s", str);
		return ;
	}

#ifdef DOS
	for (i = 0; i < strlen(str); i++) {
		if (str[i] == 27) {  /* ESC */
			for (j = 0; j < sizeof(col_tbl)/sizeof(coltbl_t); j++) {
				if (!strncmp(&str[i], col_tbl[j].escsec, strlen(col_tbl[j].escsec))) {
					SetConsoleTextAttribute(
						GetStdHandle(STD_OUTPUT_HANDLE), 
						col_tbl[j].color);
					i += strlen(col_tbl[j].escsec);
					break;
				}
			}
		}
		if (str[i]) putchar((unsigned char)str[i]);

	}
#else
	printf("%s", str);
#endif
}

/*  vim:ts=8:sw=8:
 */

