#ifndef EFFECTENTRY_H_
#define EFFECTENTRY_H_
#include "jp/ggaf/lib/actor/DefaultMeshSetActor.h"

namespace VioletVreath {

/**
 * oGtFNg .
 * @version 1.00
 * @since 2013/06/28
 * @author Masatoshi Tsuge
 */
class EffectEntry : public GgafLib::DefaultMeshSetActor {

public:
    enum {
        PROG_INIT ,
        PROG_IN   ,
        PROG_STAY ,
        PROG_OUT  ,
        PROG_BANPEI,
    };

    /** [r]GtFNg`ő̑傫܂ŊgA܂ł̃t[ */
    frame scale_in_frames_;
    /** [r]GtFNgt[ */
    frame duration_frames_;
    /** [r]GtFNg`ł܂ł̃t[ */
    frame scale_out_frames_;
    /** [r]GtFNgΏۂ̃AN^[ */
    GgafDxCore::GgafDxGeometricActor* pTarget_;
    /** [r]gkxIuWFNg */
    GgafDxCore::GgafDxScaler* pScaler_;

public:
    /**
     * RXgN^ .
     * @param prm_name ʖ
     * @param prm_model fID
     */
    EffectEntry(const char* prm_name, const char* prm_model);

    virtual void onInactive() override;

    virtual void onActive() override;

    virtual void processBehavior() override;

    virtual void processJudgement() override;

    /**
     * GtFNg̍W̃AN^[ƓWɌp .
     * @param prm_pTarget GtFNg̍WɂȂAN^[
     */
    void positionFollow(GgafDxCore::GgafDxGeometricActor* prm_pTarget);

    /**
     * GtFNg̔AAł̎ԂݒB.
     * </PRE>
     *       QQQQ                Top XP[
     *      /:      :_
     *     / :      :  _
     *    /  :      :    _
     *   /   :      :      _
     *  /    :      :        _
     * /     :      :          _    Bottom XP[
     * ----------------------------------------------->ԁit[j
     * @|A| B |
     *
     * </PRE>
     * Top XP[,Bottom XP[ pScaler_->forceRange(TOP,BOTTOM) ŏ㏑ݒ\B
     * @param prm_scale_in_frames L@̃t[ (1`)
     * @param prm_duration_frames LÃt[ (0`)
     * @param prm_scale_out_frames LB̃t[ (1`)
     */
    void config(frame prm_scale_in_frames, frame prm_duration_frames, frame prm_scale_out_frames);

    virtual ~EffectEntry();
};

}
#endif /*EFFECTENTRY_H_*/

