#include "stdafx.h"
#include "jp/ggaf/lib/util/LinearOctreeForActor.h"

#include "jp/ggaf/core/actor/GgafActor.h"
#include "jp/ggaf/core/util/GgafLinearOctreeSpace.h"
#include "jp/ggaf/lib/util/LinearOctreeActorElem.h"

using namespace GgafCore;
using namespace GgafDxCore;
using namespace GgafLib;

LinearOctreeForActor::LinearOctreeForActor(int prm_level) : GgafLinearOctree(prm_level) {
    _num_space_minus_one = _num_space-1;
    _kind_groupA = 0;
    _kind_groupB = 0;
}

void LinearOctreeForActor::executeAllHitChk(actorkind prm_groupA, actorkind prm_groupB) {
    _kind_groupA = prm_groupA;
    _kind_groupB = prm_groupB;
    if ( (_paSpace[0]._kindinfobit & _kind_groupA) && (_paSpace[0]._kindinfobit & _kind_groupB) ) {
        //ł͔؂闷֍sĂႢ
        executeHitChk(0); //Ă܂
        //͂AȂB
        _stackParentSpaceActor_GroupA.clear();
        _stackParentSpaceActor_GroupB.clear();
    }
}

void LinearOctreeForActor::executeHitChk(uint32_t prm_index) {
    LinearOctreeActorElem* pElem = ((LinearOctreeActorElem*)(_paSpace[prm_index]._pElem_first));
    if (pElem) {
        GgafLinearOctreeElem* pElem_last = _paSpace[prm_index]._pElem_last;
        while (true) {
            if (pElem->_kindbit & _kind_groupA) {
                _stackCurrentSpaceActor_GroupA.push(pElem->_pActor);
            }
            if (pElem->_kindbit & _kind_groupB) {
                _stackCurrentSpaceActor_GroupB.push(pElem->_pActor);
            }
            if (pElem == pElem_last) {
                break;
            }
            pElem = (LinearOctreeActorElem*)(pElem->_pNext);
        }
        //݂̋Ԃ̃O[vAƃO[vB
        executeHitChk_RoundRobin(&_stackCurrentSpaceActor_GroupA, &_stackCurrentSpaceActor_GroupB);
        //݂̋Ԃ̃O[vAƐeԏ̃O[vB
        executeHitChk_RoundRobin(&_stackCurrentSpaceActor_GroupA, &_stackParentSpaceActor_GroupB );
        //eԏ̃O[vAƌ݂̋Ԃ̃O[vB
        executeHitChk_RoundRobin(&_stackParentSpaceActor_GroupA , &_stackCurrentSpaceActor_GroupB);
    }

    uint32_t next_level_index = prm_index*8 + 1; //_papSpace[prm_index] Ԃ̎qԂ̃[gʒu0Ԃ̔zvfԍ
    if ( next_level_index > _num_space_minus_one) {
        //vfI[o[A܂胊[t
        _stackCurrentSpaceActor_GroupA.clear();
        _stackCurrentSpaceActor_GroupB.clear();
        return; //eԂ֖߂
    } else {
        //BȂOɌԃAN^[eԃAN^[̃X^bN֒ǉB
        //Ԃ猩ꍇ̐eԃAN^[݌vĂĂB
        //(ԃX^bNJ)
        int stackParentSpaceActor_GroupA_p = _stackParentSpaceActor_GroupA._p; //X^bN|C^ۑ
        int stackParentSpaceActor_GroupB_p = _stackParentSpaceActor_GroupB._p;

        GgafActor* pActor;
        while (pActor = _stackCurrentSpaceActor_GroupA.pop()) { //  I know "=" , not "=="
            _stackParentSpaceActor_GroupA.push(pActor);
        }

        while (pActor = _stackCurrentSpaceActor_GroupB.pop()) { //  I know "=" , not "=="
            _stackParentSpaceActor_GroupB.push(pActor);
        }

        //qԂւ邪ǂ
        for(uint32_t i = next_level_index; i < next_level_index+8; i++) {
            if ((_paSpace[i]._kindinfobit & _kind_groupA) || (_paSpace[i]._kindinfobit & _kind_groupB) ) {
                executeHitChk(i);
            }
        }

        //AȂ
        //X^bN̉ipushAɖ߂j
        _stackParentSpaceActor_GroupA._p = stackParentSpaceActor_GroupA_p;
        _stackParentSpaceActor_GroupB._p = stackParentSpaceActor_GroupB_p;
        return; //eԂ֖߂
    }
}

void LinearOctreeForActor::executeHitChk_RoundRobin(CollisionStack* prm_pStackA, CollisionStack* prm_pStackB) {
    //ǂ炩ΏI
    uint32_t num_stackA = prm_pStackA->_p;
    uint32_t num_stackB = prm_pStackB->_p;
    GgafActor** papStackActor_A = prm_pStackA->_apActor;
    GgafActor** papStackActor_B = prm_pStackB->_apActor;
    GgafActor* pActor_A;
    for (uint32_t i = 0; i < num_stackA; i++) {
        pActor_A = papStackActor_A[i];
        for (uint32_t j = 0; j < num_stackB; j++) {
            pActor_A->executeHitChk_MeAnd(papStackActor_B[j]);
        }
    }
}

LinearOctreeForActor::~LinearOctreeForActor() {
}



