#ifndef GGAFDXCORE_GGAFDXBGMPERFORMER_H_
#define GGAFDXCORE_GGAFDXBGMPERFORMER_H_
#include "jp/ggaf/core/GgafObject.h"

namespace GgafDxCore {

/**
 * BGMtxNX .
 * @version 1.00
 * @since 2010/04/19
 * @author Masatoshi Tsuge
 */
class GgafDxBgmPerformer : public GgafCore::GgafObject {

public:
//    static int _active_bgm_bpm;
    /** [r]BGM`l */
    int _bgm_num;
    /** [r]BGM̃{[z(YBGM`lԍ) */
    double* _paDouble_volume;
    /** [r]Bgmڑ */
    GgafDxBgmConnection** _papBgmConnection;

public:
    GgafDxBgmPerformer();

    /**
     * BGMݒ肷B
     * @param prm_id BGM`lԍ(0 ` )
     * @param prm_bgm_name vpeBt@C_OGG, _BPM, _TITLE ̃vtBbNXƂȂĂkey
     */
    virtual void ready(int prm_id, const char* prm_bgm_name);

    /**
     * {[ݒ肷B
     * @param prm_id     BGM`lԍ(0 ` )
     * @param prm_volume {[l(0 ` 100)
     */
    virtual void setVolume(int prm_id, int prm_volume);

    /**
     * BGMĐB
     * @param prm_id       BGM`lԍ(0 ` )
     * @param prm_volume   {[l(0 ` 100)
     * @param prm_is_loop  [v邩ǂitrue:[vĐ^false:[vĐȂj
     */
    virtual void play(int prm_id, int prm_volume, bool prm_is_loop);

    /**
     * BGMĐ([vĐ)B
     * @param prm_id     BGM`lԍ(0 ` )
     * @param prm_volume {[l(0 ` 100)
     */
    virtual void play(int prm_id, int prm_volume) {
        play(prm_id, prm_volume, true);
    }

    /**
     * BGMĐ([vĐ, {[GGAF_MAX_VOLUME)B
     * @param prm_id BGM`lԍ(0 ` )
     */
    virtual void play(int prm_id) {
        play(prm_id, GGAF_MAX_VOLUME);
    }

    /**
     * BGM~ .
     * @param prm_id BGM`lԍ(0 ` )
     */
    virtual void stop(int prm_id);

    /**
     * BGMꎞ~ .
     * @param prm_id BGM`lԍ(0 ` )
     */
    virtual void pause(int prm_id);

    /**
     * BGM̈ꎞ~ .
     * @param prm_id  BGM`lԍ(0 ` )
     */
    virtual void unpause(int prm_id);

    /**
     * SBGM`lԍBGM~ .
     */
    virtual void stop();

    /**
     * SBGM`lԍBGMꎞ~ .
     */
    virtual void pause();

    /**
     * SBGM`lԍBGM̈ꎞ~ .
     */
    virtual void unpause();

    virtual ~GgafDxBgmPerformer();
};

}
#endif /*GGAFDXCORE_GGAFDXBGMPERFORMER_H_*/
