#include "stdafx.h"
#include "jp/ggaf/core/GgafFactory.h"

#include "jp/ggaf/core/GgafGod.h"
#include "jp/ggaf/core/GgafOrder.h"
#include "jp/ggaf/core/GgafGarbageBox.h"
#include "jp/ggaf/core/actor/GgafActor.h"
#include "jp/ggaf/core/scene/GgafScene.h"
#include "jp/ggaf/core/GgafProperties.h"


using namespace GgafCore;

//
GgafOrder* GgafFactory::ROOT_ORDER = nullptr;
GgafOrder* GgafFactory::CREATING_ORDER = nullptr;
volatile bool GgafFactory::_is_working_flg = true;
volatile bool GgafFactory::_have_to_rest_flg = false;
volatile bool GgafFactory::_is_resting_flg = false;
volatile bool GgafFactory::_was_finished_flg = false;

GgafMainActor* GgafFactory::obtainActor(uint64_t prm_order_id, GgafObject* prm_org) {
    return (GgafMainActor*)obtain(prm_order_id, prm_org);
}

GgafMainScene* GgafFactory::obtainScene(uint64_t prm_order_id, GgafObject* prm_org) {
    return (GgafMainScene*)obtain(prm_order_id, prm_org);
}

//
//̃\bh̓CXbhsB
void GgafFactory::order(uint64_t prm_order_id,
                        GgafObject* (*prm_pFunc)(void*, void*, void*),
                        GgafObject* prm_pOrderer,
                        void* prm_pArg1,
                        void* prm_pArg2,
                        void* prm_pArg3) {
    TRACE2("GgafFactory::order q ʃXbh̍HꂳA[" << prm_id << "]Ƃā`B");
    //ɒĂȂ`FbN
    GgafOrder* pOrder = ROOT_ORDER;
    while (pOrder) {
        if (pOrder->_order_id == prm_order_id) {
            _TRACE_("x GgafFactory::order [" << prm_order_id << "]́AɒĂ̂ŃX[܂BӐ}ĂȂ΃IJVCłI");
            return;
        }
        if (pOrder->_is_last_order_flg) {
            break;
        }
        pOrder = pOrder->_pOrder_next;
    }
    //͖ł悤Ȃ̂Ő擪ɃXgbN
    GgafOrder* pOrder_new;
    pOrder_new = NEW GgafOrder(prm_order_id);
    pOrder_new->_pObject_creation=nullptr;
    pOrder_new->_pFunc = prm_pFunc;
    pOrder_new->_pOrderer = prm_pOrderer;
    pOrder_new->_pArg1 = prm_pArg1;
    pOrder_new->_pArg2 = prm_pArg2;
    pOrder_new->_pArg3 = prm_pArg3;
    pOrder_new->_progress = 0;
    if (ROOT_ORDER == nullptr) {
        TRACE2("GgafFactory::order q AH͋łˁBAłˁHB");
        pOrder_new->_is_first_order_flg = true;
        pOrder_new->_is_last_order_flg = true;
        pOrder_new->_pOrder_next = pOrder_new;
        pOrder_new->_pOrder_prev = pOrder_new;
        ROOT_ORDER = pOrder_new;
        CREATING_ORDER = pOrder_new;
    } else {
        TRACE2("GgafFactory::order q ܂Ă܂ˁAX܂B");
        pOrder_new->_is_first_order_flg = false;
        pOrder_new->_is_last_order_flg = true;
        GgafOrder* pOrder_last;
        pOrder_last = ROOT_ORDER->_pOrder_prev;
        pOrder_last->_is_last_order_flg = false;
        pOrder_last->_pOrder_next = pOrder_new;
        pOrder_new->_pOrder_prev = pOrder_last;
        pOrder_new->_pOrder_next = ROOT_ORDER;
        ROOT_ORDER->_pOrder_prev = pOrder_new;
    }
}

int GgafFactory::chkProgress(uint64_t prm_order_id) {
    GgafOrder* pOrder;
    pOrder = ROOT_ORDER;
    if (pOrder == nullptr) {
        return -1;
    }
    while (_is_working_flg) {
        if (pOrder->_order_id == prm_order_id) {
            return pOrder->_progress;
        } else {
            if (pOrder->_is_last_order_flg) {
                return -1;
            } else {
                pOrder = pOrder->_pOrder_next;
            }
        }
    }
    return -2;
}

void* GgafFactory::obtain(uint64_t prm_order_id, GgafObject* prm_org) {
    GgafOrder* pOrder;
    GgafOrder* pOrder_MyNext;
    GgafOrder* pOrder_MyPrev;
    DWORD waittime = 0;
    pOrder = ROOT_ORDER;
    void* objectCreation;


    if (pOrder == nullptr) {
        //G[IAG[bZ[WB
        _TRACE_("GgafFactory::obtain G[I");
        debuginfo();
        std::string name_org;
        if (prm_org->instanceOf(Obj_GgafScene)) {
            name_org = ((GgafScene*)prm_org)->getName();
        } else if (prm_org->instanceOf(Obj_GgafActor)) {
            name_org = ((GgafActor*)prm_org)->getName();
        }
        throwGgafCriticalException("GgafFactory::obtain("<<prm_order_id<<") Error! XgnullptrőSĐς݂Ă܂B\n"<<
                                   "orederobtain̑ΉĂ܂B\n"<<
                                   "l(obtainĂь)="<<name_org<<"("<<prm_org<<")");
    }

    //obtainC[v
    while (_is_working_flg) {

        if (pOrder->_order_id == prm_order_id) {
            TRACE2("GgafFactory::obtain q ɂ́A["<<prm_order_id<<"]ɗ܂ƁB");
            while (_is_working_flg) {
                if (pOrder->_progress != 2) {
                    TRACE2("GgafFactory::obtain q ʃXbhHꂳA["<<prm_order_id<<"]̐܂`HA5~b҂悤BpOrder->_progress="<<(pOrder->_progress));
#ifdef _DEBUG
                    //fobO̓^CAEg
#else

                    if (waittime > 1000*600) { //10
                        _TRACE_("GgafFactory::obtain ^CAEgG[I");
                        debuginfo();
                        //^CAEgG[IAG[bZ[WB
                        std::string name_org;
                        if (prm_org->instanceOf(Obj_GgafScene)) {
                            name_org = ((GgafScene*)prm_org)->getName();
                        } else if (prm_org->instanceOf(Obj_GgafActor)) {
                            name_org = ((GgafActor*)prm_org)->getName();
                        }
                        throwGgafCriticalException("GgafFactory::obtain Error! ["<<prm_order_id<<"]̐҂ԃ^CAEgA擾ł܂B\n"<<
                                                   "炩̗RŃCXbh~Ă\傫łB"<<
                                                   "(orderĂь)=("<<pOrder->_pOrderer<<")^l(obtainĂь)="<<name_org<<"("<<prm_org<<")");
                    } else {
                    }
#endif
                    END_SYNCHRONIZED1; // <----- rI
                    Sleep(5);
                    BEGIN_SYNCHRONIZED1; // ----->rJn
                    waittime += 5;
                    if (pOrder->_progress == 1) {
                        //ς
                        _TEXT_("!");
                        continue; //҂
                    } else {
                        //H
                        pOrder = ROOT_ORDER; //xŏTB
                        _TEXT_(".");
                        break;
                    }
                } else {
                    TRACE2("GgafFactory::obtain q A["<<prm_id<<"]͐ς݂łˁAIB[I");
                    if (pOrder->_is_first_order_flg && pOrder->_is_last_order_flg) {
                        objectCreation = pOrder->_pObject_creation;
                        pOrder->_pObject_creation = nullptr;
                        GGAF_DELETE(pOrder);
                        pOrder = nullptr;
                        ROOT_ORDER = nullptr;
                        CREATING_ORDER = nullptr;
                        TRACE2("GgafFactory::obtain q i["<<prm_id<<"]܂BAH͋łˁBɂɂȂH˂H");
                        return (void*)objectCreation;
                    } else {
                        pOrder_MyNext = pOrder->_pOrder_next;
                        pOrder_MyPrev = pOrder->_pOrder_prev;
                        pOrder_MyPrev->_pOrder_next = pOrder_MyNext;
                        pOrder_MyNext->_pOrder_prev = pOrder_MyPrev;
                        if (pOrder->_is_first_order_flg == false && pOrder->_is_last_order_flg) {
                            pOrder_MyPrev->_is_last_order_flg = true;
//                            CREATING_ORDER = pOrder_MyPrev;
                        } else if (pOrder->_is_first_order_flg && pOrder->_is_last_order_flg == false) {
                            pOrder_MyNext->_is_first_order_flg = true;
                            ROOT_ORDER = pOrder_MyNext;
//                            CREATING_ORDER = pOrder_MyNext;
                        } else if (pOrder->_is_first_order_flg == false && pOrder->_is_last_order_flg == false) {

                            //CREATING_ORDER = pOrder_MyPrev;
                        }
                        if (CREATING_ORDER == pOrder) {
                            CREATING_ORDER = pOrder_MyPrev;
                        }
                        objectCreation = pOrder->_pObject_creation;
                        pOrder->_pObject_creation = nullptr;
                        GGAF_DELETE(pOrder);
                        pOrder = nullptr;

                        return (void*)objectCreation;
                    }
                }
            }
        } else {
            if (pOrder->_is_last_order_flg) {
                _TRACE_("GgafFactory::obtain ̌`ՂA擾oȂG[I");
                debuginfo();
                //̌`ՂA擾oȂG[IAG[bZ[WB
                std::string name_org;
                if (prm_org->instanceOf(Obj_GgafScene)) {
                    name_org = ((GgafScene*)prm_org)->getName();
                } else if (prm_org->instanceOf(Obj_GgafActor)) {
                    name_org = ((GgafActor*)prm_org)->getName();
                }
                throwGgafCriticalException("GgafFactory::obtain Error! H꒷ST܂ǁAȒ(prm_order_id="<<prm_order_id<<")́A܂B\n "<<
                                           "oreder()  obtain() ̑ΉĂ܂Boreder()RA͓ obtain() QȏサĂ܂񂩁HB\n"<<
                                           "Fl(obtainĂь)="<<name_org<<"("<<prm_org<<") łB\n" <<
                                           "iȂ݂ɁAݍH̍ŏII[_[́Aԍ(_order_id="<<pOrder->_order_id<<")ŁA(orderĂь)=("<<pOrder->_pOrderer<<") łj");
            } else {
                pOrder = pOrder->_pOrder_next;
            }
        }
    }
    if (GgafGod::_pException_Factory) {
        throw *(GgafGod::_pException_Factory);
    }
    return nullptr;
}

void GgafFactory::beginRest() {
    _TRACE_("GgafFactory::beginRest() _HAxeȂ");
    _have_to_rest_flg = true;
}

bool GgafFactory::isResting() {
    if (_is_resting_flg) {
        _TRACE_("GgafFactory::isResting() Hx~");
    } else {
        _TRACE_("GgafFactory::isResting() Hғ");
    }
    return _is_resting_flg;
}

void GgafFactory::finishRest() {
    _TRACE_("GgafFactory::beginRest() _HAxe͂܂BI");
    _have_to_rest_flg = false;
}

//HɂߍłSẴCX^Xj
//_(GgafGod)AvIɎs\B
void GgafFactory::clean() {
    TRACE2("GgafFactory::clean _ H|Jn");
    GgafOrder* pOrder = ROOT_ORDER;
    if (pOrder == nullptr) {
        TRACE2("GgafFactory::clean _ HɉII");
        return;
    }
    while (_is_working_flg || _was_finished_flg == false) {
        Sleep(10);
        _TRACE_("GgafFactory::clean _ Hꂪ܂Ă܂EEE");
    }

    debuginfo();

    while (true) {
        if (pOrder->_is_last_order_flg) {
            TRACE2("GgafFactory::clean _ i폜["<<pOrder->_id<<"]AŌ̃XgbN");
            GGAF_DELETE(pOrder);
            pOrder = nullptr;
            ROOT_ORDER = nullptr;
            CREATING_ORDER = nullptr;
            break;
        } else {
            TRACE2("GgafFactory::clean _ i폜["<<pOrder->_id<<"]");
            GgafOrder* pOrder_MyNext = pOrder->_pOrder_next;
            GGAF_DELETE(pOrder);
            pOrder = pOrder_MyNext;
        }
    }
    TRACE2("GgafFactory::clean _ H|");
    return;
}

void GgafFactory::debuginfo() {
    _TRACE_("GgafFactory::debuginfo fobO ݂̍H̏");
    try {
        GgafOrder* p = ROOT_ORDER;
        if (p) {
            while(p) {

                if (p->_pObject_creation) {

                    std::string name_creation;
                    if (p->_pObject_creation->instanceOf(Obj_GgafScene)) {
                        name_creation = ((GgafScene*)p->_pObject_creation)->getName();
                    } else if (p->_pObject_creation->instanceOf(Obj_GgafActor)) {
                        name_creation = ((GgafActor*)p->_pObject_creation)->getName();
                    }


                    _TRACE_("EID="<<p->_order_id<<", "<<
                            "i="<<p->_progress<<", "<<
                            "i="<<name_creation<<"("<<p->_pObject_creation<<")"<<", "<<
                            "=("<<p->_pOrderer<<")"
                    );
                } else {
                    _TRACE_("EID="<<p->_order_id<<", "<<
                            "i="<<p->_progress<<", "<<
                            "i=nullptr,"<<
                            "=("<<p->_pOrderer<<")"
                    );
                }
                p = p->_pOrder_next;
                if (p == ROOT_ORDER) {
                    break;
                }
            }
        } else {
            _TRACE_("EI[_[܂I");
        }
    } catch (...) {
        _TRACE_("GgafFactory::debuginfo ȂƂƂł傤B݂̍H̏Ԃ̕\s\łB");
    }
    _TRACE_("GgafFactory::debuginfo ȏ");
}





unsigned __stdcall GgafFactory::work(void* prm_arg) {
    //_CrtSetBreakAlloc(95299);
    //_CrtSetBreakAlloc(65854);

    try {
        GgafObject* (*func)(void*, void*, void*) = nullptr;
        GgafObject* pObject = nullptr;
        GgafOrder* pOrder_InManufacturing_save = nullptr;
        Sleep(1000); //god ̃CX^X܂łق̂Ƒ҂Kv邩Ȃ
        while (_is_working_flg) {
            if (_have_to_rest_flg) {
                _is_resting_flg = true;
                Sleep(100);
                continue;
            } else {
                _is_resting_flg = false;
            }

            BEGIN_SYNCHRONIZED1; // ----->rJn
            if (CREATING_ORDER) {
                if (CREATING_ORDER->_progress == 0) { //Ȃ܂
                    TRACE2("GgafFactory::work H꒷ 悵A["<<CREATING_ORDER->_id<<"]͖(_progress == "<<CREATING_ORDER->_progress<<")ȁB䂦ɍ܂I");
                    CREATING_ORDER->_progress = 1; //Xe[^X𐻑
                    func = CREATING_ORDER->_pFunc;
                    pOrder_InManufacturing_save = CREATING_ORDER; //|C^ꎞޔ
                    void* arg1 = CREATING_ORDER->_pArg1;
                    void* arg2 = CREATING_ORDER->_pArg2;
                    void* arg3 = CREATING_ORDER->_pArg3;
                    TRACE2("GgafFactory::work H꒷ JnI["<<CREATING_ORDER->_id<<"] ( MEցEL) ");
                    Sleep(2);
                    END_SYNCHRONIZED1; // <----- rI
//#ifdef MY_DEBUG
//try {
//#endif
                    pObject = (*func)(arg1, arg2, arg3); //i̐I
//#ifdef MY_DEBUG
//} catch (GgafCriticalException& e) {
//    _TRACE_("HO G[G"<<e.getMsg());
//    std::string message = "\nE"+e.getMsg()+"  \n\nS肪bZ[W̏ꍇÃoỎ\܂B\nɐ\󂲂܂B\n";
//    std::string message_dialog = message + "(uShift + Ctrl + CvŃbZ[W̓Rs[ł܂B)";
//    MessageBox(nullptr, message_dialog.c_str(),"L̃G[Ă܂܂", MB_OK|MB_ICONSTOP | MB_SETFOREGROUND);
//    _is_working_flg = false;
//    _was_finished_flg = true;
//    GgafGod::_pException_Factory = NEW GgafCriticalException(e.getMsg());
//    return 0;
//}
//#endif

                    BEGIN_SYNCHRONIZED1; // ----->rJn
                    Sleep(2);
                    TRACE2("GgafFactory::work H꒷ Ii["<<CREATING_ORDER->_id<<"] (^_^)v");
                    if (CREATING_ORDER == nullptr) {
                        TRACE2("GgafFactory::work H꒷ K[IB̂ɃLZEEEBj܂BpObjectdelete!");
                        GGAF_DELETE(pObject);
                        END_SYNCHRONIZED1; // <----- rI
                        continue;
                    } else {
                        CREATING_ORDER = pOrder_InManufacturing_save; //|C^A
                        CREATING_ORDER->_pObject_creation = pObject; //io^
                        CREATING_ORDER->_progress = 2; //Xe[^X𐻑ς݂
                        TRACE2("GgafFactory::work H꒷ ̕i["<<(CREATING_ORDER->_id)<<"]AIɒuƂ܂B");
                    }
                } else {
                    TRACE2("GgafFactory::work H꒷ ["<<CREATING_ORDER->_id<<"]͊ɒIɒuĂ(_progress == "<<CREATING_ORDER->_progress<<")B䂦ɔ΂");
                }
            }
            if (ROOT_ORDER == nullptr) {
                //ҋ@
                TRACE2("GgafFactory::work H꒷ Hɂ͉`܂BȂłIIEEEȂ̂HBiҋ@j");
                END_SYNCHRONIZED1; // <----- rI
                if (GgafGod::_pGod->_fps >= PROPERTY::FPS_TO_CLEAN_GARBAGE_BOX) {
                    TRACE2("GgafFactory::work H꒷ FPS͍ȂÅԂ𗘗păS~|łƂ܂B1");
                    GgafGarbageBox::_pGarbageBox->clean(5); //ɂȂ̂ŁAS~|
                    GgafGarbageBox::_cnt_cleaned = 0;
                }
            } else {
                if (ROOT_ORDER != nullptr && ROOT_ORDER->_pOrder_prev->_progress == 0) {
                    TRACE2("GgafFactory::work H꒷ EEE̒CzB["<<ROOT_ORDER->_pOrder_prev->_id<<"]Ȃ̂HB");
                    CREATING_ORDER = CREATING_ORDER->_pOrder_next;
                    END_SYNCHRONIZED1; // <----- rI
                    continue;
                } else {
                    TRACE2("GgafFactory::work H꒷ āA͖B`Iɐς̂܂Ă邷Aɗ₪IBiҋ@j");
                    END_SYNCHRONIZED1; // <----- rI
                    if (GgafGod::_pGod->_fps >= PROPERTY::FPS_TO_CLEAN_GARBAGE_BOX) {
                        TRACE2("GgafFactory::work H꒷ FPS͍ȂÅԂ𗘗păS~|łƂ܂B2");
                        GgafGarbageBox::_pGarbageBox->clean(5); //ɂȂ̂ŁAS~|
                        GgafGarbageBox::_cnt_cleaned = 0;
                    }
                }
            }
            Sleep(2);
        }
        TRACE2("GgafFactory::work H꒷ H͂ɂēX܂łB悤ȂA܂܂傤B");
        _was_finished_flg = true;
    } catch (GgafCriticalException& e) {
        debuginfo();
        _TRACE_("HO ƂƂ݂܂G"<<e.getMsg());
        _is_working_flg = false;
        _was_finished_flg = true;
        GgafGod::_pException_Factory = NEW GgafCriticalException(e.getMsg());
        return 1;
    }
    return 0;
}

