#ifndef GGAFCORE_GGAFRGB_H_
#define GGAFCORE_GGAFRGB_H_
#include "jp/ggaf/core/GgafObject.h"

#include "jp/ggaf/core/exception/GgafCriticalException.h"
#include "jp/ggaf/core/util/GgafUtil.h"

namespace GgafCore {

/**
 * RGBlNX .
 * @version 1.00
 * @since 2011/05/13
 * @author Masatoshi Tsuge
 */
class GgafRgb : public GgafObject {
private :
    std::string _allowedChars;

    bool isValid();
public:
    /** [r/w] Redl(0`255) */
    size_t _red;
    /** [r/w] Greenl(0`255) */
    size_t _green;
    /** [r/w] Bruel(0`255) */
    size_t _blue;
    /** [r/w] Redl(0.0`1.0) */
    float _r;
    /** [r/w] Greenl(0.0`1.0) */
    float _g;
    /** [r/w] Bruel(0.0`1.0 */
    float _b;
    /** PUi\RGB */
    std::string _hex;
    /** F񂪑Óǂ */
    bool _is_valid;

    static bool _is_init;
    static std::map<std::string, std::string> _cname;

public:
    /**
     * RXgN^ .
     * ێRGB(0, 0, 0)
     */
    GgafRgb();

    /**
     * RXgN^ .
     * ̕RGBlƂ܂B
     * @param prm_str_color "#FFFFFF"`̕i"#"͏ȗjA܂X11F
     */
    GgafRgb(std::string prm_str_color);

    void init();

    /**
     * ̕RGBlƂݒ肵܂ .
     * @param prm_hex "#FFFFFF"`̕ i"#"͏ȗjA܂X11F
     */
    void set(std::string prm_hex);

    /**
     * ێRGBl𕶎Ŏ擾
     * @return "#FFFFFF"`̕
     */
    std::string toStr();
};



}
#endif /*GGAFCORE_GGAFRGB_H_*/
