/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seasar.extension.jdbc.gen.internal.util.TableUtil;
import org.seasar.extension.jdbc.gen.meta.DbColumnMeta;
import org.seasar.extension.jdbc.gen.meta.DbForeignKeyMeta;
import org.seasar.extension.jdbc.gen.meta.DbUniqueKeyMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTableMeta {
    protected String catalogName;
    protected String schemaName;
    protected String name;
    protected String comment;
    protected List<DbColumnMeta> columnMetaList = new ArrayList<DbColumnMeta>();
    protected List<DbColumnMeta> primaryKeyColumnMetaList = new ArrayList<DbColumnMeta>();
    protected List<DbForeignKeyMeta> foreignKeyMetaList = new ArrayList<DbForeignKeyMeta>();
    protected List<DbUniqueKeyMeta> uniqueKeyMetaList = new ArrayList<DbUniqueKeyMeta>();

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<DbColumnMeta> getColumnMetaList() {
        return Collections.unmodifiableList(this.columnMetaList);
    }

    public void addColumnMeta(DbColumnMeta columnDesc) {
        this.columnMetaList.add(columnDesc);
        if (columnDesc.isPrimaryKey()) {
            this.primaryKeyColumnMetaList.add(columnDesc);
        }
    }

    public List<DbColumnMeta> getPrimaryKeyColumnMetaList() {
        return Collections.unmodifiableList(this.primaryKeyColumnMetaList);
    }

    public List<DbForeignKeyMeta> getForeignKeyMetaList() {
        return Collections.unmodifiableList(this.foreignKeyMetaList);
    }

    public void addForeignKeyMeta(DbForeignKeyMeta foreignKeyMeta) {
        this.foreignKeyMetaList.add(foreignKeyMeta);
    }

    public List<DbUniqueKeyMeta> getUniqueKeyMetaList() {
        return Collections.unmodifiableList(this.uniqueKeyMetaList);
    }

    public void addUniqueKeyMeta(DbUniqueKeyMeta uniqueKeyMeta) {
        this.uniqueKeyMetaList.add(uniqueKeyMeta);
    }

    public String getFullTableName() {
        return TableUtil.buildFullTableName(this.catalogName, this.schemaName, this.name);
    }

    public boolean hasCompositePrimaryKey() {
        return this.primaryKeyColumnMetaList.size() > 1;
    }
}

