/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.version;

import java.io.File;
import org.seasar.extension.jdbc.gen.internal.version.DdlInfoFileImpl;
import org.seasar.extension.jdbc.gen.internal.version.DdlVersionDirectoryImpl;
import org.seasar.extension.jdbc.gen.version.DdlInfoFile;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectory;
import org.seasar.extension.jdbc.gen.version.DdlVersionDirectoryTree;
import org.seasar.framework.log.Logger;

public class DdlVersionDirectoryTreeImpl
implements DdlVersionDirectoryTree {
    protected static String CREATE_DIR_NAME = "create";
    protected static String DROP_DIR_NAME = "drop";
    protected static Logger logger = Logger.getLogger(DdlVersionDirectoryTreeImpl.class);
    protected File baseDir;
    protected String versionNoPattern;
    protected String env;
    protected DdlInfoFile ddlInfoFile;

    public DdlVersionDirectoryTreeImpl(File baseDir, File versionFile, String versionNoPattern, String env) {
        if (baseDir == null) {
            throw new NullPointerException("baseDir");
        }
        if (versionFile == null) {
            throw new NullPointerException("versionFile");
        }
        if (versionNoPattern == null) {
            throw new NullPointerException("versionNoPattern");
        }
        this.baseDir = baseDir;
        this.versionNoPattern = versionNoPattern;
        this.env = env;
        this.ddlInfoFile = this.createDdlInfoFile(versionFile);
    }

    public DdlVersionDirectory getCurrentVersionDirectory() {
        return this.createDdlVersionDirectory(this.ddlInfoFile.getCurrentVersionNo());
    }

    public DdlVersionDirectory getNextVersionDirectory() {
        return this.createDdlVersionDirectory(this.ddlInfoFile.getNextVersionNo());
    }

    public DdlVersionDirectory getVersionDirectory(int versionNo) {
        return this.createDdlVersionDirectory(versionNo);
    }

    public DdlInfoFile getDdlInfoFile() {
        return this.ddlInfoFile;
    }

    protected DdlInfoFile createDdlInfoFile(File file) {
        return new DdlInfoFileImpl(file);
    }

    protected DdlVersionDirectory createDdlVersionDirectory(int versionNo) {
        return new DdlVersionDirectoryImpl(this.baseDir, versionNo, this.versionNoPattern, this.env);
    }
}

