/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.sql;

public class SqlFileTokenizer {
    protected char statementDelimiter;
    protected String blockDelimiter;
    protected String line;
    protected int pos;
    protected int nextPos;
    protected int length;
    protected String token;
    protected TokenType type;
    protected boolean blockCommentStarted;

    public SqlFileTokenizer(char statementDelimiter, String blockDelimiter) {
        if (SqlFileTokenizer.isOther(statementDelimiter) || statementDelimiter == '\'') {
            throw new IllegalArgumentException("statementDelimiter");
        }
        this.statementDelimiter = statementDelimiter;
        this.blockDelimiter = blockDelimiter;
        this.type = TokenType.END_OF_LINE;
    }

    public void addLine(String line) {
        if (line == null) {
            this.type = TokenType.END_OF_FILE;
            return;
        }
        this.line = line;
        this.length = line.length();
        this.pos = 0;
        this.nextPos = 0;
        if (this.blockCommentStarted) {
            this.type = TokenType.BLOCK_COMMENT;
        } else if (line.trim().equalsIgnoreCase(this.blockDelimiter)) {
            this.type = TokenType.BLOCK_DELIMITER;
            this.nextPos = this.length;
        } else {
            this.peek(this.pos);
        }
    }

    protected void peek(int index) {
        if (index < this.length) {
            char c = this.line.charAt(index);
            if (c == '\'') {
                this.type = TokenType.QUOTE;
                this.pos = index;
                this.nextPos = index + 1;
            } else {
                int nextIndex = index + 1;
                if (nextIndex < this.length) {
                    char c2 = this.line.charAt(nextIndex);
                    if (c == '-' && c2 == '-') {
                        this.type = TokenType.LINE_COMMENT;
                        this.pos = index;
                        this.nextPos = index + 2;
                    } else if (c == '/' && c2 == '*') {
                        this.type = TokenType.START_OF_BLOCK_COMMENT;
                        this.pos = index;
                        this.nextPos = index + 2;
                    } else {
                        this.peekChar(index, c);
                    }
                } else {
                    this.peekChar(index, c);
                }
            }
        } else {
            this.type = TokenType.END_OF_LINE;
            this.pos = this.length;
            this.nextPos = this.length;
        }
    }

    protected void peekChar(int index, char c) {
        this.type = c == this.statementDelimiter ? TokenType.STATEMENT_DELIMITER : (SqlFileTokenizer.isOther(c) ? TokenType.OTHER : TokenType.WORD);
        this.pos = index;
        this.nextPos = index + 1;
    }

    public TokenType nextToken() {
        switch (this.type) {
            case END_OF_FILE: {
                this.token = null;
                this.type = TokenType.END_OF_FILE;
                return TokenType.END_OF_FILE;
            }
            case END_OF_LINE: {
                this.token = "";
                this.type = TokenType.END_OF_LINE;
                return TokenType.END_OF_LINE;
            }
            case BLOCK_DELIMITER: {
                this.token = this.line;
                this.type = TokenType.END_OF_LINE;
                return TokenType.BLOCK_DELIMITER;
            }
            case STATEMENT_DELIMITER: {
                this.token = this.line.substring(this.pos, this.nextPos);
                this.peek(this.nextPos);
                return TokenType.STATEMENT_DELIMITER;
            }
            case LINE_COMMENT: {
                this.token = this.line.substring(this.pos, this.length);
                this.type = TokenType.END_OF_LINE;
                return TokenType.LINE_COMMENT;
            }
            case START_OF_BLOCK_COMMENT: {
                this.token = this.line.substring(this.pos, this.nextPos);
                this.type = TokenType.BLOCK_COMMENT;
                this.pos += 2;
                this.nextPos = this.pos + 2;
                return TokenType.START_OF_BLOCK_COMMENT;
            }
            case BLOCK_COMMENT: {
                for (int i = this.nextPos; i < this.length; ++i) {
                    char c = this.line.charAt(i);
                    int nextIndex = i + 1;
                    if (nextIndex >= this.length) continue;
                    char c2 = this.line.charAt(nextIndex);
                    if (c != '*' || c2 != '/') continue;
                    this.blockCommentStarted = false;
                    this.token = this.line.substring(this.pos, i);
                    this.type = TokenType.END_OF_BLOCK_COMMENT;
                    this.pos = i;
                    this.nextPos = i + 2;
                    return TokenType.BLOCK_COMMENT;
                }
                this.blockCommentStarted = true;
                this.token = this.line.substring(this.pos, this.length);
                this.type = TokenType.END_OF_LINE;
                return TokenType.BLOCK_COMMENT;
            }
            case END_OF_BLOCK_COMMENT: {
                this.token = this.line.substring(this.pos, this.nextPos);
                this.peek(this.nextPos);
                return TokenType.END_OF_BLOCK_COMMENT;
            }
            case QUOTE: {
                for (int i = this.nextPos; i < this.length; ++i) {
                    char c = this.line.charAt(i);
                    if (c != '\'') continue;
                    if (++i >= this.length) {
                        this.token = this.line.substring(this.pos, i);
                        this.type = TokenType.END_OF_LINE;
                        return TokenType.QUOTE;
                    }
                    if (this.line.charAt(i) == '\'') continue;
                    this.token = this.line.substring(this.pos, i);
                    this.peek(i);
                    return TokenType.QUOTE;
                }
                this.token = this.line.substring(this.pos, this.length);
                this.type = TokenType.END_OF_LINE;
                return TokenType.QUOTE;
            }
            case WORD: {
                int wordStartPos = this.pos;
                while (this.type == TokenType.WORD && this.pos < this.length) {
                    this.peek(this.nextPos);
                }
                this.token = this.line.substring(wordStartPos, this.pos);
                return TokenType.WORD;
            }
            case OTHER: {
                int otherStartPos = this.pos;
                while (this.type == TokenType.OTHER && this.pos < this.length) {
                    this.peek(this.nextPos);
                }
                this.token = this.line.substring(otherStartPos, this.pos);
                return TokenType.OTHER;
            }
        }
        throw new IllegalStateException(this.type.name());
    }

    protected static boolean isOther(char c) {
        return Character.isWhitespace(c) || c == '=' || c == '?' || c == '<' || c == '>' || c == '(' || c == ')' || c == '!' || c == '*' || c == '-' || c == ',';
    }

    public String getToken() {
        return this.token;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TokenType {
        QUOTE,
        LINE_COMMENT,
        START_OF_BLOCK_COMMENT,
        BLOCK_COMMENT,
        END_OF_BLOCK_COMMENT,
        STATEMENT_DELIMITER,
        BLOCK_DELIMITER,
        WORD,
        OTHER,
        END_OF_LINE,
        END_OF_FILE;

    }
}

