/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import java.lang.reflect.Field;
import javax.persistence.Column;
import org.seasar.extension.jdbc.PropertyMeta;
import org.seasar.extension.jdbc.gen.internal.util.AnnotationUtil;
import org.seasar.extension.jdbc.gen.model.ConditionAttributeModel;
import org.seasar.extension.jdbc.gen.model.ConditionAttributeModelFactory;
import org.seasar.extension.jdbc.where.condition.NotNullableCondition;
import org.seasar.extension.jdbc.where.condition.NotNullableStringCondition;
import org.seasar.extension.jdbc.where.condition.NullableCondition;
import org.seasar.extension.jdbc.where.condition.NullableStringCondition;
import org.seasar.framework.util.ClassUtil;

public class ConditionAttributeModelFactoryImpl
implements ConditionAttributeModelFactory {
    public ConditionAttributeModel getConditionAttributeModel(PropertyMeta propertyMeta) {
        ConditionAttributeModel attributeModel = new ConditionAttributeModel();
        attributeModel.setName(propertyMeta.getName());
        Class clazz = ClassUtil.getWrapperClassIfPrimitive((Class)propertyMeta.getPropertyClass());
        attributeModel.setAttributeClass(clazz);
        Field field = propertyMeta.getField();
        Column column = field.getAnnotation(Column.class);
        if (column == null) {
            column = AnnotationUtil.getDefaultColumn();
        }
        Class conditionClass = null;
        if (clazz == String.class) {
            conditionClass = column.nullable() ? NullableStringCondition.class : NotNullableStringCondition.class;
        } else {
            conditionClass = column.nullable() ? NullableCondition.class : NotNullableCondition.class;
            attributeModel.setParameterized(true);
        }
        attributeModel.setConditionClass(conditionClass);
        return attributeModel;
    }
}

