/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.model;

import org.seasar.extension.jdbc.gen.desc.AssociationDesc;
import org.seasar.extension.jdbc.gen.desc.AssociationType;
import org.seasar.extension.jdbc.gen.model.AssociationModel;
import org.seasar.extension.jdbc.gen.model.AssociationModelFactory;
import org.seasar.extension.jdbc.gen.model.JoinColumnModel;
import org.seasar.extension.jdbc.gen.model.JoinColumnsModel;

public class AssociationModelFactoryImpl
implements AssociationModelFactory {
    protected boolean showJoinColumn;

    public AssociationModelFactoryImpl(boolean showJoinColumn) {
        this.showJoinColumn = showJoinColumn;
    }

    public AssociationModel getAssociationModel(AssociationDesc associationDesc) {
        AssociationModel model = new AssociationModel();
        model.setName(associationDesc.getName());
        if (associationDesc.getAssociationType() == AssociationType.ONE_TO_MANY) {
            String entityName = associationDesc.getReferencedEntityDesc().getName();
            model.setShortClassName("List<" + entityName + ">");
        } else {
            model.setShortClassName(associationDesc.getReferencedEntityDesc().getName());
        }
        model.setAssociationType(associationDesc.getAssociationType());
        model.setMappedBy(associationDesc.getMappedBy());
        if (associationDesc.getColumnNameList().size() == 1) {
            this.doJoinColumnModel(model, associationDesc);
        } else if (associationDesc.getColumnNameList().size() > 1) {
            this.doJoinColumnsModel(model, associationDesc);
        }
        return model;
    }

    protected void doJoinColumnModel(AssociationModel associationModel, AssociationDesc associationDesc) {
        String propertyName = associationDesc.getName();
        String columnName = associationDesc.getColumnNameList().get(0);
        String referencedColumnName = associationDesc.getReferencedColumnNameList().get(0);
        if (this.showJoinColumn || !this.matchesDefaultMappingRule(propertyName, columnName, referencedColumnName)) {
            JoinColumnModel joinColumnModel = new JoinColumnModel();
            joinColumnModel.setName(columnName);
            joinColumnModel.setReferencedColumnName(referencedColumnName);
            associationModel.setJoinColumnModel(joinColumnModel);
        }
    }

    protected boolean matchesDefaultMappingRule(String propertyName, String columnName, String referencedColumnName) {
        return columnName.equalsIgnoreCase(propertyName + "_" + referencedColumnName);
    }

    protected void doJoinColumnsModel(AssociationModel associationModel, AssociationDesc associationDesc) {
        JoinColumnsModel joinColumnsModel = new JoinColumnsModel();
        int i = 0;
        for (String name : associationDesc.getColumnNameList()) {
            String referencedColumnName = associationDesc.getReferencedColumnNameList().get(i);
            JoinColumnModel joinColumnModel = new JoinColumnModel();
            joinColumnModel.setName(name);
            joinColumnModel.setReferencedColumnName(referencedColumnName);
            joinColumnsModel.addJoinColumnModel(joinColumnModel);
            ++i;
        }
        associationModel.setJoinColumnsModel(joinColumnsModel);
    }
}

