/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.h2.message.Message;
import org.h2.store.FileLister;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.Tool;

public class Restore
extends Tool {
    private void showUsage() {
        this.out.println("Restores a database backup.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-file <filename>]  The source file name (default: backup.zip)\n" + " [-dir <dir>]        Target directory (default: .)\n" + " [-db <database>]    Target database name\n" + " [-quiet]            Do not print progress information");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] args) throws SQLException {
        new Restore().run(args);
    }

    public void run(String[] args) throws SQLException {
        String zipFileName = "backup.zip";
        String dir = ".";
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (arg.equals("-file")) {
                zipFileName = args[++i];
                continue;
            }
            if (arg.equals("-db")) {
                db = args[++i];
                continue;
            }
            if (arg.equals("-quiet")) {
                quiet = true;
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + arg);
            this.showUsage();
            return;
        }
        this.process(zipFileName, dir, db, quiet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getOriginalDbName(String fileName, String db) throws IOException {
        InputStream in = null;
        try {
            ZipEntry entry;
            in = FileUtils.openFileInputStream(fileName);
            ZipInputStream zipIn = new ZipInputStream(in);
            String originalDbName = null;
            boolean multiple = false;
            while ((entry = zipIn.getNextEntry()) != null) {
                String entryName = entry.getName();
                zipIn.closeEntry();
                String name = FileLister.getDatabaseNameFromFileName(entryName);
                if (name == null) continue;
                if (db.equals(name)) {
                    originalDbName = name;
                    break;
                }
                if (originalDbName == null) {
                    originalDbName = name;
                    continue;
                }
                multiple = true;
            }
            zipIn.close();
            if (multiple && !originalDbName.equals(db)) {
                throw new IOException("Multiple databases found, but not " + db);
            }
            String string = originalDbName;
            return string;
        }
        finally {
            IOUtils.closeSilently(in);
        }
    }

    public static void execute(String zipFileName, String directory, String db, boolean quiet) throws SQLException {
        new Restore().process(zipFileName, directory, db, quiet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(String zipFileName, String directory, String db, boolean quiet) throws SQLException {
        InputStream in = null;
        try {
            ZipEntry entry;
            if (!FileUtils.exists(zipFileName)) {
                throw new IOException("File not found: " + zipFileName);
            }
            String originalDbName = null;
            if (db != null) {
                originalDbName = Restore.getOriginalDbName(zipFileName, db);
                if (originalDbName == null) {
                    throw new IOException("No database named " + db + " found");
                }
                if (originalDbName.startsWith(File.separator)) {
                    originalDbName = originalDbName.substring(1);
                }
            }
            in = FileUtils.openFileInputStream(zipFileName);
            ZipInputStream zipIn = new ZipInputStream(in);
            while ((entry = zipIn.getNextEntry()) != null) {
                String fileName = entry.getName();
                fileName = fileName.replace('\\', File.separatorChar);
                if ((fileName = fileName.replace('/', File.separatorChar)).startsWith(File.separator)) {
                    fileName = fileName.substring(1);
                }
                boolean copy = false;
                if (db == null) {
                    copy = true;
                } else if (fileName.startsWith(originalDbName)) {
                    fileName = db + fileName.substring(originalDbName.length());
                    copy = true;
                }
                if (copy) {
                    OutputStream out = null;
                    try {
                        out = FileUtils.openFileOutputStream(directory + File.separator + fileName, false);
                        IOUtils.copy(zipIn, out);
                        out.close();
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeSilently(out);
                        throw throwable;
                    }
                    IOUtils.closeSilently(out);
                }
                zipIn.closeEntry();
            }
            zipIn.closeEntry();
            zipIn.close();
        }
        catch (IOException e) {
            try {
                throw Message.convertIOException(e, zipFileName);
            }
            catch (Throwable throwable) {
                IOUtils.closeSilently(in);
                throw throwable;
            }
        }
        IOUtils.closeSilently(in);
    }
}

