/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store.fs;

import java.io.IOException;
import java.io.InputStream;
import org.h2.store.fs.FileObject;

public class FileObjectInputStream
extends InputStream {
    private FileObject file;
    private byte[] buffer = new byte[1];

    FileObjectInputStream(FileObject file) {
        this.file = file;
    }

    public int read() throws IOException {
        if (this.file.getFilePointer() >= this.file.length()) {
            return -1;
        }
        this.file.readFully(this.buffer, 0, 1);
        return this.buffer[0] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.file.getFilePointer() + (long)len < this.file.length()) {
            this.file.readFully(b, off, len);
            return len;
        }
        return super.read(b, off, len);
    }

    public void close() throws IOException {
        this.file.close();
    }
}

