/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.Message;

public class DropUser
extends DefineCommand {
    private boolean ifExists;
    private String userName;

    public DropUser(Session session) {
        super(session);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        User user = db.findUser(this.userName);
        if (user == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90032, this.userName);
            }
        } else {
            if (user == this.session.getUser()) {
                throw Message.getSQLException(90019);
            }
            user.checkOwnsNoSchemas();
            db.removeDatabaseObject(this.session, user);
        }
        return 0;
    }

    public boolean isTransactional() {
        return false;
    }
}

