/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.dialect;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.StandardGenDialect;
import org.seasar.extension.jdbc.gen.internal.sqltype.BinaryType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BlobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.ClobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DecimalType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DoubleType;
import org.seasar.extension.jdbc.gen.internal.sqltype.FloatType;
import org.seasar.extension.jdbc.gen.internal.sqltype.IntegerType;

public class MysqlGenDialect
extends StandardGenDialect {
    protected static int TABLE_NOT_FOUND_ERROR_CODE = 1146;
    protected static int COLUMN_NOT_FOUND_ERROR_CODE = 1054;

    public MysqlGenDialect() {
        this.sqlTypeMap.put(-2, new BinaryType("binary($l)"));
        this.sqlTypeMap.put(2004, new BlobType(){

            public String getDataType(int length, int precision, int scale, boolean identity) {
                if (length <= 255) {
                    return "tinyblob";
                }
                if (length <= 65535) {
                    return "blob";
                }
                if (length <= 0xFFFFFF) {
                    return "mediumblob";
                }
                return "longblob";
            }
        });
        this.sqlTypeMap.put(2005, new ClobType(){

            public String getDataType(int length, int precision, int scale, boolean identity) {
                if (length <= 255) {
                    return "tinytext";
                }
                if (length <= 65535) {
                    return "text";
                }
                if (length <= 0xFFFFFF) {
                    return "mediumtext";
                }
                return "longtext";
            }
        });
        this.sqlTypeMap.put(3, new DecimalType("decimal($p,$s)"));
        this.sqlTypeMap.put(8, new DoubleType("double($p,$s)"));
        this.sqlTypeMap.put(6, new FloatType("float($p,$s)"));
        this.sqlTypeMap.put(4, new IntegerType("int"));
        this.columnTypeMap.put("bigint unsigned", MysqlColumnType.BIGINT_UNSIGNED);
        this.columnTypeMap.put("binary", MysqlColumnType.BINARY);
        this.columnTypeMap.put("bit", MysqlColumnType.BIT);
        this.columnTypeMap.put("blob", MysqlColumnType.BLOB);
        this.columnTypeMap.put("datetime", MysqlColumnType.DATETIME);
        this.columnTypeMap.put("decimal", MysqlColumnType.DECIMAL);
        this.columnTypeMap.put("double", MysqlColumnType.DOUBLE);
        this.columnTypeMap.put("int", MysqlColumnType.INT);
        this.columnTypeMap.put("int unsigned", MysqlColumnType.INT_UNSIGNED);
        this.columnTypeMap.put("longblob", MysqlColumnType.LONGBLOB);
        this.columnTypeMap.put("longtext", MysqlColumnType.LONGTEXT);
        this.columnTypeMap.put("mediumblob", MysqlColumnType.MEDIUMBLOB);
        this.columnTypeMap.put("mediumint", MysqlColumnType.MEDIUMINT);
        this.columnTypeMap.put("mediumint unsigned", MysqlColumnType.MEDIUMINT_UNSIGNED);
        this.columnTypeMap.put("mediumtext", MysqlColumnType.MEDIUMTEXT);
        this.columnTypeMap.put("smallint unsigned", MysqlColumnType.SMALLINT_UNSIGNED);
        this.columnTypeMap.put("tinyblob", MysqlColumnType.TINYBLOB);
        this.columnTypeMap.put("tinyint", MysqlColumnType.TINYINT);
        this.columnTypeMap.put("tinyint unsigned", MysqlColumnType.TINYINT_UNSIGNED);
        this.columnTypeMap.put("tinytext", MysqlColumnType.TINYTEXT);
        this.columnTypeMap.put("text", MysqlColumnType.TEXT);
        this.columnTypeMap.put("year", MysqlColumnType.YEAR);
    }

    public String getName() {
        return "mysql";
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    public String getSqlBlockDelimiter() {
        return "/";
    }

    public String getIdentityColumnDefinition() {
        return "not null auto_increment";
    }

    public String getDropForeignKeySyntax() {
        return "drop foreign key";
    }

    public String getDropUniqueKeySyntax() {
        return "drop index";
    }

    public boolean isTableNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == TABLE_NOT_FOUND_ERROR_CODE;
    }

    public boolean isColumnNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == COLUMN_NOT_FOUND_ERROR_CODE;
    }

    public GenDialect.SqlBlockContext createSqlBlockContext() {
        return new MysqlSqlBlockContext();
    }

    public boolean supportsIdentityInsert() {
        return true;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public boolean supportsCommentInCreateTable() {
        return true;
    }

    public boolean supportsCommentOn() {
        return false;
    }

    public static class MysqlSqlBlockContext
    extends StandardGenDialect.StandardSqlBlockContext {
        protected MysqlSqlBlockContext() {
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("declare"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("begin"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MysqlColumnType
    extends StandardGenDialect.StandardColumnType {
        private static MysqlColumnType BIGINT_UNSIGNED = new MysqlColumnType("bigint unsigned", BigInteger.class);
        private static MysqlColumnType BINARY = new MysqlColumnType("binary($l)", byte[].class);
        private static MysqlColumnType BIT = new MysqlColumnType("bit($l)", (Class)byte[].class){

            @Override
            public Class<?> getAttributeClass(int length, int precision, int scale) {
                return length == 0 ? Boolean.class : super.getAttributeClass(length, precision, scale);
            }

            @Override
            public String getColumnDefinition(int length, int precision, int scale, String defaultValue) {
                if (length == 0) {
                    return this.getColumnDefinitionInternal("bool", defaultValue);
                }
                return super.getColumnDefinition(length, precision, scale, defaultValue);
            }
        };
        private static MysqlColumnType BLOB = new MysqlColumnType("blob", byte[].class, true);
        private static MysqlColumnType DATETIME = new MysqlColumnType("datetime", Timestamp.class);
        private static MysqlColumnType DECIMAL = new MysqlColumnType("decimal($p,$s)", BigDecimal.class);
        private static MysqlColumnType DOUBLE = new MysqlColumnType("double($p,$s)", Double.class);
        private static MysqlColumnType INT = new MysqlColumnType("int", Integer.class);
        private static MysqlColumnType INT_UNSIGNED = new MysqlColumnType("int unsigned", Long.class);
        private static MysqlColumnType LONGBLOB = new MysqlColumnType("longblob", byte[].class, true);
        private static MysqlColumnType LONGTEXT = new MysqlColumnType("longtext", String.class, true);
        private static MysqlColumnType MEDIUMBLOB = new MysqlColumnType("mediumblob", byte[].class, true);
        private static MysqlColumnType MEDIUMINT = new MysqlColumnType("mediumint", Integer.class);
        private static MysqlColumnType MEDIUMINT_UNSIGNED = new MysqlColumnType("mediumint unsigned", Integer.class);
        private static MysqlColumnType MEDIUMTEXT = new MysqlColumnType("mediumtext", String.class, true);
        private static MysqlColumnType SMALLINT_UNSIGNED = new MysqlColumnType("smallint unsigned", Integer.class);
        private static MysqlColumnType TINYBLOB = new MysqlColumnType("tinyblob", byte[].class, true);
        private static MysqlColumnType TINYINT = new MysqlColumnType("tinyint", Byte.class);
        private static MysqlColumnType TINYINT_UNSIGNED = new MysqlColumnType("tinyint unsigned", Short.class);
        private static MysqlColumnType TINYTEXT = new MysqlColumnType("tinytext", String.class, true);
        private static MysqlColumnType TEXT = new MysqlColumnType("text", String.class, true);
        private static MysqlColumnType YEAR = new MysqlColumnType("year", Date.class);

        public MysqlColumnType(String dataType, Class<?> attributeClass) {
            super(dataType, attributeClass);
        }

        public MysqlColumnType(String dataType, Class<?> attributeClass, boolean lob) {
            super(dataType, attributeClass, lob);
        }
    }
}

