/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.dialect;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.gen.dialect.GenDialect;
import org.seasar.extension.jdbc.gen.internal.dialect.StandardGenDialect;
import org.seasar.extension.jdbc.gen.internal.sqltype.BinaryType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BlobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BooleanType;
import org.seasar.extension.jdbc.gen.internal.sqltype.ClobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DateType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DecimalType;
import org.seasar.extension.jdbc.gen.internal.sqltype.DoubleType;
import org.seasar.extension.jdbc.gen.internal.sqltype.IntegerType;
import org.seasar.extension.jdbc.gen.internal.sqltype.TimeType;
import org.seasar.extension.jdbc.gen.internal.sqltype.TimestampType;
import org.seasar.framework.util.StringUtil;

public class MssqlGenDialect
extends StandardGenDialect {
    protected static List<Integer> TABLE_NOT_FOUND_ERROR_CODES = Arrays.asList(208, 1088);
    protected static int COLUMN_NOT_FOUND_ERROR_CODE = 207;

    public MssqlGenDialect() {
        this.sqlTypeMap.put(-2, new BinaryType("varbinary($l)"));
        this.sqlTypeMap.put(16, new BooleanType("bit"));
        this.sqlTypeMap.put(2004, new BlobType("image"));
        this.sqlTypeMap.put(2005, new ClobType("text"));
        this.sqlTypeMap.put(91, new DateType("datetime"));
        this.sqlTypeMap.put(3, new DecimalType("decimal($p,$s)"));
        this.sqlTypeMap.put(8, new DoubleType("double precision"));
        this.sqlTypeMap.put(4, new IntegerType("int"));
        this.sqlTypeMap.put(92, new TimeType("datetime"));
        this.sqlTypeMap.put(93, new TimestampType("datetime"));
        this.columnTypeMap.put("binary", MssqlColumnType.BINARY);
        this.columnTypeMap.put("bit", MssqlColumnType.BIT);
        this.columnTypeMap.put("datetime", MssqlColumnType.DATETIME);
        this.columnTypeMap.put("decimal", MssqlColumnType.DECIMAL);
        this.columnTypeMap.put("image", MssqlColumnType.IMAGE);
        this.columnTypeMap.put("int", MssqlColumnType.INT);
        this.columnTypeMap.put("money", MssqlColumnType.MONEY);
        this.columnTypeMap.put("nchar", MssqlColumnType.NCHAR);
        this.columnTypeMap.put("ntext", MssqlColumnType.NTEXT);
        this.columnTypeMap.put("numeric", MssqlColumnType.NUMERIC);
        this.columnTypeMap.put("nvarchar", MssqlColumnType.NVARCHAR);
        this.columnTypeMap.put("smalldatetime", MssqlColumnType.SMALLDATETIME);
        this.columnTypeMap.put("smallmoney", MssqlColumnType.SMALLMONEY);
        this.columnTypeMap.put("text", MssqlColumnType.TEXT);
        this.columnTypeMap.put("varbinary", MssqlColumnType.VARBINARY);
    }

    public String getName() {
        return "mssql";
    }

    public String getDefaultSchemaName(String userName) {
        return "dbo";
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    public String getOpenQuote() {
        return "[";
    }

    public String getCloseQuote() {
        return "]";
    }

    public String getSqlBlockDelimiter() {
        return "go";
    }

    public String getIdentityColumnDefinition() {
        return "identity not null";
    }

    public boolean isTableNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return TABLE_NOT_FOUND_ERROR_CODES.contains(errorCode);
    }

    public boolean isColumnNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == COLUMN_NOT_FOUND_ERROR_CODE;
    }

    public GenDialect.ColumnType getColumnType(String typeName, int sqlType) {
        GenDialect.ColumnType columnType = (GenDialect.ColumnType)this.columnTypeMap.get(typeName);
        if (columnType != null) {
            return columnType;
        }
        if (StringUtil.startsWithIgnoreCase((String)typeName, (String)"int")) {
            typeName = "int";
        } else if (StringUtil.startsWithIgnoreCase((String)typeName, (String)"bigint")) {
            typeName = "bigint";
        } else if (StringUtil.startsWithIgnoreCase((String)typeName, (String)"smallint")) {
            typeName = "smallint";
        } else if (StringUtil.startsWithIgnoreCase((String)typeName, (String)"tinyint")) {
            typeName = "tinyint";
        } else if (StringUtil.startsWithIgnoreCase((String)typeName, (String)"decimal")) {
            typeName = "decimal";
        } else if (StringUtil.startsWithIgnoreCase((String)typeName, (String)"numeric")) {
            typeName = "numeric";
        }
        return super.getColumnType(typeName, sqlType);
    }

    public GenDialect.SqlBlockContext createSqlBlockContext() {
        return new MssqlSqlBlockContext();
    }

    public boolean supportsIdentityInsert() {
        return true;
    }

    public boolean supportsIdentityInsertControlStatement() {
        return true;
    }

    public String getIdentityInsertEnableStatement(String tableName) {
        return "set identity_insert " + tableName + " on";
    }

    public String getIdentityInsertDisableStatement(String tableName) {
        return "set identity_insert " + tableName + " off";
    }

    public boolean supportsIdentity() {
        return true;
    }

    public static class MssqlSqlBlockContext
    extends StandardGenDialect.StandardSqlBlockContext {
        protected MssqlSqlBlockContext() {
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("create", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "procedure"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "function"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("alter", "trigger"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("declare"));
            this.sqlBlockStartKeywordsList.add(Arrays.asList("begin"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MssqlColumnType
    extends StandardGenDialect.StandardColumnType {
        private static MssqlColumnType BINARY = new MssqlColumnType("binary($l)", byte[].class);
        private static MssqlColumnType BIT = new MssqlColumnType("bit", Boolean.class);
        private static MssqlColumnType DATETIME = new MssqlColumnType("datetime", Timestamp.class);
        private static MssqlColumnType DECIMAL = new MssqlColumnType("decimal($p,$s)", BigDecimal.class);
        private static MssqlColumnType IMAGE = new MssqlColumnType("image", byte[].class, true);
        private static MssqlColumnType INT = new MssqlColumnType("int", Integer.class);
        private static MssqlColumnType MONEY = new MssqlColumnType("money", BigDecimal.class);
        private static MssqlColumnType NCHAR = new MssqlColumnType("nchar($l)", String.class);
        private static MssqlColumnType NTEXT = new MssqlColumnType("ntext", String.class);
        private static MssqlColumnType NUMERIC = new MssqlColumnType("numeric($p,$s)", BigDecimal.class);
        private static MssqlColumnType NVARCHAR = new MssqlColumnType("nvarchar($l)", String.class);
        private static MssqlColumnType SMALLDATETIME = new MssqlColumnType("smalldatetime", Timestamp.class);
        private static MssqlColumnType SMALLMONEY = new MssqlColumnType("smallmoney", BigDecimal.class);
        private static MssqlColumnType TEXT = new MssqlColumnType("text", String.class);
        private static MssqlColumnType VARBINARY = new MssqlColumnType("varbinary($l)", byte[].class);

        public MssqlColumnType(String dataType, Class<?> attributeClass) {
            super(dataType, attributeClass);
        }

        public MssqlColumnType(String dataType, Class<?> attributeClass, boolean lob) {
            super(dataType, attributeClass, lob);
        }
    }
}

