/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.dialect;

import javax.persistence.GenerationType;
import org.seasar.extension.jdbc.gen.internal.dialect.StandardGenDialect;
import org.seasar.extension.jdbc.gen.internal.sqltype.BinaryType;
import org.seasar.extension.jdbc.gen.internal.sqltype.BlobType;
import org.seasar.extension.jdbc.gen.internal.sqltype.ClobType;

public class HsqlGenDialect
extends StandardGenDialect {
    protected static int TABLE_NOT_FOUND_ERROR_CODE = -22;
    protected static int COLUMN_NOT_FOUND_ERROR_CODE = -28;
    protected static int SEQUENCE_NOT_FOUND_ERROR_CODE = -191;

    public HsqlGenDialect() {
        this.sqlTypeMap.put(-2, new BinaryType("varbinary($l)"));
        this.sqlTypeMap.put(2004, new BlobType("longvarbinary"));
        this.sqlTypeMap.put(2005, new ClobType("longvarchar"));
        this.columnTypeMap.put("int", HsqlColumnType.INT);
        this.columnTypeMap.put("varchar_ignorecase", HsqlColumnType.VARCHAR_IGNORECASE);
    }

    public String getName() {
        return "hsql";
    }

    public String getDefaultSchemaName(String userName) {
        return null;
    }

    public GenerationType getDefaultGenerationType() {
        return GenerationType.IDENTITY;
    }

    public boolean supportsSequence() {
        return true;
    }

    public String getSequenceDefinitionFragment(String dataType, long initialValue, int allocationSize) {
        return "as " + dataType + " start with " + initialValue + " increment By " + allocationSize;
    }

    public String getIdentityColumnDefinition() {
        return "generated by default as identity(start with 1)";
    }

    public boolean isTableNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == TABLE_NOT_FOUND_ERROR_CODE;
    }

    public boolean isColumnNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == COLUMN_NOT_FOUND_ERROR_CODE;
    }

    public boolean isSequenceNotFound(Throwable throwable) {
        Integer errorCode = this.getErrorCode(throwable);
        return errorCode != null && errorCode == SEQUENCE_NOT_FOUND_ERROR_CODE;
    }

    public boolean supportsIdentity() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName, int allocationSize) {
        return "SELECT NEXT VALUE FOR " + sequenceName + " FROM INFORMATION_SCHEMA.SYSTEM_TABLES WHERE table_name = 'SYSTEM_TABLES'";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HsqlColumnType
    extends StandardGenDialect.StandardColumnType {
        private static HsqlColumnType INT = new HsqlColumnType("int", Integer.class);
        private static HsqlColumnType VARCHAR_IGNORECASE = new HsqlColumnType("varchar_ignorecase", String.class);

        public HsqlColumnType(String dataType, Class<?> attributeClass) {
            super(dataType, attributeClass);
        }
    }
}

