/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.internal.command;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.seasar.extension.jdbc.gen.generator.GenerationContext;
import org.seasar.extension.jdbc.gen.generator.Generator;
import org.seasar.extension.jdbc.gen.internal.command.AbstractCommand;
import org.seasar.extension.jdbc.gen.internal.exception.RequiredPropertyNullRuntimeException;
import org.seasar.extension.jdbc.gen.internal.model.SqlFileConstantNamingRuleImpl;
import org.seasar.extension.jdbc.gen.internal.util.FileUtil;
import org.seasar.extension.jdbc.gen.internal.util.ReflectUtil;
import org.seasar.extension.jdbc.gen.model.ClassModel;
import org.seasar.extension.jdbc.gen.model.SqlFileConstantNamingRule;
import org.seasar.extension.jdbc.gen.model.SqlFileConstantsModel;
import org.seasar.extension.jdbc.gen.model.SqlFileConstantsModelFactory;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerateSqlFileConstantsCommand
extends AbstractCommand {
    protected static Logger logger = Logger.getLogger(GenerateSqlFileConstantsCommand.class);
    protected File classpathDir;
    protected Set<File> sqlFileSet = new HashSet<File>();
    protected String rootPackageName = "";
    protected String subPackageName = "";
    protected String shortClassName = "SqlFiles";
    protected String templateFileName = "java/sqlfileconstants.ftl";
    protected String templateFileEncoding = "UTF-8";
    protected File templateFilePrimaryDir = null;
    protected File javaFileDestDir = new File(new File("src", "main"), "java");
    protected String javaFileEncoding = "UTF-8";
    protected boolean overwrite = true;
    protected String sqlFileConstantNamingRuleClassName = SqlFileConstantNamingRuleImpl.class.getName();
    protected SqlFileConstantNamingRule sqlFileConstantNamingRule;
    protected SqlFileConstantsModelFactory sqlFileConstantsModelFactory;
    protected Generator generator;

    public String getSubPackageName() {
        return this.subPackageName;
    }

    public void setSubPackageName(String subPackageName) {
        this.subPackageName = subPackageName;
    }

    public String getTemplateFileName() {
        return this.templateFileName;
    }

    public void setTemplateFileName(String templateFileName) {
        this.templateFileName = templateFileName;
    }

    public File getJavaFileDestDir() {
        return this.javaFileDestDir;
    }

    public void setJavaFileDestDir(File javaFileDestDir) {
        this.javaFileDestDir = javaFileDestDir;
    }

    public String getJavaFileEncoding() {
        return this.javaFileEncoding;
    }

    public void setJavaFileEncoding(String javaFileEncoding) {
        this.javaFileEncoding = javaFileEncoding;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public String getRootPackageName() {
        return this.rootPackageName;
    }

    public void setRootPackageName(String rootPackageName) {
        this.rootPackageName = rootPackageName;
    }

    public String getTemplateFileEncoding() {
        return this.templateFileEncoding;
    }

    public void setTemplateFileEncoding(String templateFileEncoding) {
        this.templateFileEncoding = templateFileEncoding;
    }

    public File getTemplateFilePrimaryDir() {
        return this.templateFilePrimaryDir;
    }

    public void setTemplateFilePrimaryDir(File templateFilePrimaryDir) {
        this.templateFilePrimaryDir = templateFilePrimaryDir;
    }

    public File getClasspathDir() {
        return this.classpathDir;
    }

    public void setClasspathDir(File classpathDir) {
        this.classpathDir = classpathDir;
    }

    public Set<File> getSqlFileSet() {
        return this.sqlFileSet;
    }

    public void setSqlFileSet(Set<File> sqlFileSet) {
        this.sqlFileSet = sqlFileSet;
    }

    public String getShortClassName() {
        return this.shortClassName;
    }

    public void setShortClassName(String shortClassName) {
        this.shortClassName = shortClassName;
    }

    public String getSqlFileConstantNamingRuleClassName() {
        return this.sqlFileConstantNamingRuleClassName;
    }

    public void setSqlFileConstantNamingRuleClassName(String sqlFileConstantNamingRuleClassName) {
        this.sqlFileConstantNamingRuleClassName = sqlFileConstantNamingRuleClassName;
    }

    @Override
    protected void doValidate() {
        if (this.classpathDir == null) {
            throw new RequiredPropertyNullRuntimeException("classpathDir");
        }
    }

    @Override
    protected void doInit() {
        this.sqlFileConstantNamingRule = ReflectUtil.newInstance(SqlFileConstantNamingRule.class, this.sqlFileConstantNamingRuleClassName);
        this.sqlFileConstantsModelFactory = this.createSqlFileConstantsModelFactory();
        this.generator = this.createGenerator();
    }

    @Override
    protected void doExecute() {
        SqlFileConstantsModel model = this.sqlFileConstantsModelFactory.getSqlFileConstantsModel();
        GenerationContext context = this.createGenerationContext(model, this.templateFileName);
        this.generator.generate(context);
    }

    @Override
    protected void doDestroy() {
    }

    protected SqlFileConstantsModelFactory createSqlFileConstantsModelFactory() {
        return this.factory.createSqlFileConstantsModelFactory(this, this.classpathDir, this.sqlFileSet, this.sqlFileConstantNamingRule, ClassUtil.concatName((String)this.rootPackageName, (String)this.subPackageName), this.shortClassName);
    }

    protected Generator createGenerator() {
        return this.factory.createGenerator(this, this.templateFileEncoding, this.templateFilePrimaryDir);
    }

    protected GenerationContext createGenerationContext(ClassModel model, String templateName) {
        File file = FileUtil.createJavaFile(this.javaFileDestDir, model.getPackageName(), model.getShortClassName());
        return this.factory.createGenerationContext(this, model, file, templateName, this.javaFileEncoding, this.overwrite);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }
}

