/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.gen.desc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seasar.extension.jdbc.annotation.ReferentialActionType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyDesc {
    protected final Key key = new Key();
    protected List<String> columnNameList = new ArrayList<String>();
    protected String referencedCatalogName;
    protected String referencedSchemaName;
    protected String referencedTableName;
    protected String referencedFullTableName;
    protected List<String> referencedColumnNameList = new ArrayList<String>();
    protected ReferentialActionType onDelete;
    protected ReferentialActionType onUpdate;

    public List<String> getColumnNameList() {
        return Collections.unmodifiableList(this.columnNameList);
    }

    public void addColumnName(String columnName) {
        this.columnNameList.add(columnName);
        this.key.addColumnName(columnName);
    }

    public String getReferencedCatalogName() {
        return this.referencedCatalogName;
    }

    public void setReferencedCatalogName(String referencedCatalogName) {
        this.referencedCatalogName = referencedCatalogName;
        this.key.setReferencedCatalogName(referencedCatalogName);
    }

    public String getReferencedSchemaName() {
        return this.referencedSchemaName;
    }

    public void setReferencedSchemaName(String referencedSchemaName) {
        this.referencedSchemaName = referencedSchemaName;
        this.key.setReferencedSchemaName(referencedSchemaName);
    }

    public String getReferencedTableName() {
        return this.referencedTableName;
    }

    public void setReferencedTableName(String referencedTableName) {
        this.referencedTableName = referencedTableName;
        this.key.setReferencedTableName(referencedTableName);
    }

    public List<String> getReferencedColumnNameList() {
        return Collections.unmodifiableList(this.referencedColumnNameList);
    }

    public void addReferencedColumnName(String referencedColumnName) {
        this.referencedColumnNameList.add(referencedColumnName);
        this.key.addtReferencedColumnName(referencedColumnName);
    }

    public void setReferencedFullTableName(String referencedFullTableName) {
        this.referencedFullTableName = referencedFullTableName;
    }

    public String getReferencedFullTableName() {
        return this.referencedFullTableName;
    }

    public ReferentialActionType getOnDelete() {
        return this.onDelete;
    }

    public void setOnDelete(ReferentialActionType onDelete) {
        this.onDelete = onDelete;
    }

    public ReferentialActionType getOnUpdate() {
        return this.onUpdate;
    }

    public void setOnUpdate(ReferentialActionType onUpdate) {
        this.onUpdate = onUpdate;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForeignKeyDesc other = (ForeignKeyDesc)obj;
        return this.key.equals(other.key);
    }

    protected static class Key {
        protected List<String> columnNameList = new ArrayList<String>();
        protected String referencedCatalogName;
        protected String referencedSchemaName;
        protected String referencedTableName;
        protected List<String> referencedColumnNameList = new ArrayList<String>();

        protected Key() {
        }

        protected void addColumnName(String columnName) {
            if (columnName != null) {
                this.columnNameList.add(columnName.toLowerCase());
            } else {
                this.columnNameList.add(null);
            }
        }

        protected void setReferencedCatalogName(String referencedCatalogName) {
            if (referencedCatalogName != null) {
                this.referencedCatalogName = referencedCatalogName.toLowerCase();
            }
        }

        protected void setReferencedSchemaName(String referencedSchemaName) {
            if (referencedSchemaName != null) {
                this.referencedSchemaName = referencedSchemaName.toLowerCase();
            }
        }

        protected void setReferencedTableName(String referencedTableName) {
            if (referencedTableName != null) {
                this.referencedTableName = referencedTableName.toLowerCase();
            }
        }

        protected void addtReferencedColumnName(String referencedColumnName) {
            if (referencedColumnName != null) {
                this.referencedColumnNameList.add(referencedColumnName.toLowerCase());
            } else {
                this.referencedColumnNameList.add(null);
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.columnNameList == null ? 0 : ((Object)this.columnNameList).hashCode());
            result = 31 * result + (this.referencedCatalogName == null ? 0 : this.referencedCatalogName.hashCode());
            result = 31 * result + (this.referencedSchemaName == null ? 0 : this.referencedSchemaName.hashCode());
            result = 31 * result + (this.referencedTableName == null ? 0 : this.referencedTableName.hashCode());
            result = 31 * result + (this.referencedColumnNameList == null ? 0 : ((Object)this.referencedColumnNameList).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.columnNameList == null ? other.columnNameList != null : !((Object)this.columnNameList).equals(other.columnNameList)) {
                return false;
            }
            if (this.referencedCatalogName == null ? other.referencedCatalogName != null : !this.referencedCatalogName.equals(other.referencedCatalogName)) {
                return false;
            }
            if (this.referencedSchemaName == null ? other.referencedSchemaName != null : !this.referencedSchemaName.equals(other.referencedSchemaName)) {
                return false;
            }
            if (this.referencedTableName == null ? other.referencedTableName != null : !this.referencedTableName.equals(other.referencedTableName)) {
                return false;
            }
            return !(this.referencedColumnNameList == null ? other.referencedColumnNameList != null : !((Object)this.referencedColumnNameList).equals(other.referencedColumnNameList));
        }
    }
}

