﻿using nft.framework;
using nft.framework.plugin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nft.ui.ui.docking
{
    public class VDockContentId : VAbstractIdentifier
    {
        static public readonly string CID_Sepalator = "::";

        internal static VDockContentId RestoreFromString(string idstr)
        {
            return new VDockContentId(idstr);
        }

        private VDockContentId(string idstr) : base(idstr)
        {
        }

        public VDockContentId(VContributionId id, string name) : base(id.AsString + CID_Sepalator + name)
        {
        }

        public VContributionId ContributionID
        {
            get
            {
                int n = AsString.IndexOf(CID_Sepalator);
                return VContributionId.FromString(AsString.Substring(0, n));
            }
        }

        public string Name
        {
            get
            {
                int n = AsString.IndexOf(CID_Sepalator);
                return AsString.Substring(n + CID_Sepalator.Length);
            }
        }
    }
}
