﻿using System;
using System.Collections.Generic;
using System.Text;
using WeifenLuo.WinFormsUI.Docking;
using System.Windows.Forms;
using System.Diagnostics;

namespace nft.ui.docking {
    public class DefaultDockForm: DockContent {
        protected readonly SubformHolder holder;

        public DefaultDockForm(SubformHolder sh) {
            this.holder = sh;
            KeyDown += new KeyEventHandler(DefaultDockForm_KeyDown);
        }

        void DefaultDockForm_KeyDown(object sender, KeyEventArgs e) {
            Debug.WriteLine("SubForm KeyDown=" + e.KeyCode);
        }

        public SubformHolder Holder {
            get { return holder; }
        }

        public virtual void OnBeforeSaveLayout() {
            if (holder.HasOption(StyleOption.NoSaveLayout) || holder.HasOption(StyleOption.Tempolaly)) {
                Close();
            }
        }

        protected override string GetPersistString() {
            if (holder.HasOption(StyleOption.NoSaveLayout)) {
                return null;
            } else {
                return holder.ContentID.AsString;
            }
        }

        protected override bool ProcessDialogKey(Keys keyData) {
            Keys k = keyData & Keys.KeyCode;
            if (k == Keys.Left || k == Keys.Right || k == Keys.Up || k == Keys.Down) {
                return false;
            }
            return base.ProcessDialogKey(keyData);
        }

        /*
        protected override bool ProcessKeyPreview(ref Message m) {
            Keys key = ((Keys)m.WParam.ToInt32() & Keys.KeyCode);
            if (key == Keys.Left || key == Keys.Down　) {
                Debug.WriteLine("XXX!Handled!");
                return true;
            } else {
                Debug.Write(string.Format("%x", m.Msg));
                Debug.Write((Keys)m.WParam.ToInt32());
            }
            return base.ProcessKeyPreview(ref m);
        }
         */
    }
}
