﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;

namespace nft.framework
{
    [AttributeUsage(AttributeTargets.Method, AllowMultiple=true)]
    public class TestEntryAttribute: Attribute
    {
        protected object[] _arguments = null;
        protected string _caps;
        protected bool _onUIThread = false;

        public TestEntryAttribute(bool onUIThread = false)
            : this(null, null, onUIThread) {
        }
        public TestEntryAttribute(String caption, bool onUIThread = false)
            : this(caption, null, onUIThread) {
        }
        public TestEntryAttribute(object[] args, bool onUIThread = false)
            : this(null, args, onUIThread) {
        }
        public TestEntryAttribute(String caption, object[] args, bool onUIThread = false) {
            this._arguments = args;
            this._caps = caption;
            this._onUIThread = onUIThread;
        }

        public String Caption {
            get { return _caps; }
            set { _caps = value; }
        }

        public object[] Arguments {
            get { return _arguments; }
            set { _arguments = value; }
        }

        public bool ShouldRunOnUIThread
        {
            get { return _onUIThread; }
            set { _onUIThread = value; }
        }
    }
}
