﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.core.view;
using nft.impl.game;
using nft.core.game;

namespace nft.impl.selectors {
    public class CubeSelectorBase : ITargetSelector, IPointerHandler {
        IGame game;
        public CubeSelectorBase() {
        }

        protected TerrainMapImpl TerrainMap {
            get {
                return ((GameImpl)game).TerrainMap;
            }
        }

        #region ITargetSelector implementation
        public int MaxPhases {
            get {
                return 1;
            }
        }

        public int CurrentPhase {
            get {
                return 1;
            }
        }

        public object CurrentSelection {
            get {
                throw new NotImplementedException();
            }
        }

        public event TargetSelectorEvent OnSelectionChanged;

        public event TargetSelectorEvent OnPhaseChanged;

        public event TargetSelectorEvent OnViewChanged;
        #endregion

        #region IPointerHandler implementation
        public void OnAttach(IGame g) {
            this.game = g;
        }

        public void OnDetach(IGame g) {
            this.game = null;
        }

        public void OnMouseButtonDown(PointerEventArgs args) {
            throw new NotImplementedException();
        }

        public void OnMouseButtonUp(PointerEventArgs args) {
            throw new NotImplementedException();
        }

        public void OnMouseMove(PointerEventArgs args) {
            throw new NotImplementedException();
        }
        #endregion
    }
}
