﻿using System;
using System.Collections.Generic;
using System.Text;

namespace nft.core.structure {
    public interface ICatalogSource<T> {
        IEnumerable<KeyValuePair<String,ICatalogVariable>> CatalogVariables {
            get;
        }

        /// <summary>
        /// カタログ変数に応じて、エントリを選択する
        /// </summary>
        /// <param name="valueMap">現在の選択状態を保持するパラメーターマップ</param>
        /// <param name="result">選択結果、見つからなければnull</param>
        /// <param name="child">さらに子の要素があれば返す</param>
        /// <returns>選択結果がnullでなければtrue</returns>
        bool Select(CatalogVariableCollection.ValueMap valueMap, out T result, out ICatalogSource<T> child);
    }
}
