﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.core.view;
using nft.core.geometry;
using nft.framework;
using System.Windows.Forms;

namespace nft.core.game {
    public class ToolCollection : IEnumerable<IPointerHandler>{

        protected List<IPointerHandler> modelesses;
        protected List<IPointerHandler> modals;
        protected IPointerHandler current;
        protected GameManager manager;

        public ToolCollection(GameManager gm) {
            manager = gm;
            modals = new List<IPointerHandler>();
            modelesses = new List<IPointerHandler>();
            current = null;
            manager.OnGameStart += ManagerOnGameStart;
            manager.OnGameClose += ManagerOnGameClose;
        }

        protected virtual void ManagerOnGameStart(GameEventArgs args) {
            IGame g = args.Game;
            foreach (IPointerHandler h in this) {
                h.OnAttach(g);
            }
        }

        protected virtual void ManagerOnGameClose(GameEventArgs args) {
            IGame g = args.Game;
            foreach (IPointerHandler h in this) {
                h.OnDetach(g);
            }
        }

        public virtual IPointerHandler ActiveTool {
            get {
                return current;
            }
            set {
                if (value != null && modals.Contains(value)) {
                    current = value;
                } else {
                    current = null;
                }
            }
        }

        public void Add(IPointerHandler h) {
            this.Add(h, true);
        }

        public void Add(IPointerHandler h, bool modal) {
            if (modal) {
                modals.Add(h);
            } else {
                modelesses.Add(h);
            }
        }

        public void Remove(IPointerHandler h) {
            this.Remove(h, true);
        }

        public void Remove(IPointerHandler h, bool modal) {
            if (modal) {
                modals.Remove(h);
            } else {
                modelesses.Remove(h);
            }
        }

        public IList<IPointerHandler> ModalTools {
            get { return new List<IPointerHandler>(modals); }
        }

        public IList<IPointerHandler> ModelessTools {
            get { return new List<IPointerHandler>(modelesses); }
        }

        public IEnumerator<IPointerHandler> EnumAwakeTools() {
            if (current != null) {
                yield return current;
            }
            foreach (IPointerHandler h in modelesses) yield return h;
        }


        #region IEnumerable implementation
        public IEnumerator<IPointerHandler> GetEnumerator()
        {
            foreach (IPointerHandler h in modals) yield return h;
            foreach (IPointerHandler h in modelesses) yield return h;
        }

        System.Collections.IEnumerator  System.Collections.IEnumerable.GetEnumerator()
        {
            return GetEnumerator();
        }
        #endregion
    }
}
