﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Reactive.Linq;
using System.Reactive.Subjects;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace nft.test.test.RxPractice {
    public partial class RxPracticeForm : Form {
        public RxPracticeForm() {
            InitializeComponent();
        }

        public void SetMessage(string msg) {
            this.msgLabel.Text = msg;
        }

        public void SetStatusText(string txt) {
            this.mainStatusLabel.Text = txt;
        }

        public IObservable<MouseEventArgs> ObserveMouseMove(){
            return Observable.FromEventPattern<MouseEventArgs>(
                x => this.MouseMove += x.Invoke, x => this.MouseMove -= x.Invoke
            ).Select( x => x.EventArgs );
        }

        public IObservable<EventArgs> ObserveClickA() {
            return Observable.FromEventPattern<EventArgs>(
                x => this.buttonA.Click += x.Invoke, x => this.buttonA.Click -= x.Invoke
            ).Select(x => x.EventArgs);
        }

        public IObservable<EventArgs> ObserveClickB() {
            return Observable.FromEventPattern<EventArgs>(
                x => this.buttonB.Click += x.Invoke, x => this.buttonB.Click -= x.Invoke
            ).Select(x => x.EventArgs);
        }
    }
}
