﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using static System.Diagnostics.Trace;
using static Microsoft.VisualStudio.TestTools.UnitTesting.Assert;
using System.Collections.Generic;

namespace nft.test
{
    [TestClass]
    public class TestExample
    {

        [TestMethod]
        public void TestMethod1()
        {
            Console.WriteLine("テスト中のコンソール出力は Test Explorer の Output をクリック");
            // Doubleは第三引数で許容誤差を指定できる
            AreEqual(0.1, 0.11, 0.01, "誤算0.01以内に収まりません");

            var expected = new List<int> { 1, 1, 2, 3, 4, 5 };
            // コレクション専用のAssertクラスあり
            CollectionAssert.AreEquivalent(expected, new List<int> { 1, 5, 4, 3, 2, 1 });
        }

        [AssemblyInitialize]
        public static void AssemblyInit(TestContext c) => WriteLine("Assembly単位の初期化処理");
        [ClassInitialize]
        public static void ClassInit(TestContext c) => WriteLine("TestClass単位の初期化処理 ", c.TestName);
        [TestInitialize]
        public void TestInitialize() => WriteLine("Testメソッド単位の初期化処理");        
        [TestCleanup]
        public void TestCleanup() => WriteLine("Testメソッド単位の解放処理");
        [ClassCleanup]
        public static void ClassCleanup() => WriteLine("TestClass単位の解放処理");
        [AssemblyCleanup]
        public static void AssemblyCleanup() =>  WriteLine("Assemblyの解放処理");

    }
}
