using System;
using System.Diagnostics;
using System.Windows.Forms;
using System.Collections.Generic;
using nft.util;
using nft.ui.mainframe_old;
using System.Threading;
using System.Linq;
using nft.core;
using nft.framework;

namespace nft.starter
{
	public class Starter
	{
		//[DllImport("DirectDraw.AlphaBlend.dll",EntryPoint="DllRegisterServer")]
		//private static extern void regsvr();

		[STAThread]
		static void Main( string[] args ) 
		{
            if (Debugger.IsAttached) {
                run(args);
            } else {
                Application.SetUnhandledExceptionMode(UnhandledExceptionMode.CatchException);
                Application.ThreadException += new ThreadExceptionEventHandler(Application_ThreadException);
                try {
                    run(args);
                } catch (Exception e) {
                    if(UIUtil.ShowException("G[܂", e, UIInformLevel.normal))
                        throw;
                }
            }
		}

		private static void run( string[] args ) {
            // start the game
            Application.Run(new Main(args));
		}



        static void Application_ThreadException(object sender, ThreadExceptionEventArgs e) {
            if(UIUtil.ShowException(e.Exception.Message, e.Exception, UIInformLevel.severe))
                throw e.Exception;
        }
	}
}
