﻿using System;
using System.Collections.Generic;
using System.Text;

namespace nft.ui.command {
    public interface ICommandProcedure {
        bool Enable { get; }
        event EventHandler EnableChanged;
    }

    public interface ITriggerCommandProcedure : ICommandProcedure {
        void Execute();
    }

    public delegate void ListModelventHandler(ISingleSelectCommandProcedure sender, EventArgs e);

    public interface ISingleSelectCommandProcedure : ICommandProcedure {
        void Select(string name);
        string Current { get; set; }
        event ListModelventHandler SelectionChanged;
        void SelectNext();
        void SelectPrev();
    }
}
