﻿using nft.framework;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace nft.framework.repository
{
    public class RepositoryBase<S,T> : IRepository<S,T> where T: class, IHasNameAndID where S:IIdentifier
    {
        protected Dictionary<S, T> dictionary = new Dictionary<S, T>();

        public T this[S id]
        {
            get
            {
                T ret;
                if( dictionary.TryGetValue(id, out ret) ) return ret;
                return null;
            }
        }

        public int Count
        {
            get
            {
                return dictionary.Count;
            }
        }

        public IEnumerable<T> List
        {
            get
            {
                return dictionary.Values;
            }
        }

        public void Add(T model)
        {
            dictionary.Add((S)model.ID, model);
        }

        public T RemoveByID(S id)
        {
            T ret = this[id];
            dictionary.Remove(id);
            return ret;
        }
    }
}
